/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.AssumeNoSideEffectsChecker;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.KeepClassMemberChecker;
import proguard.classfile.util.WarningPrinter;

public class ConfigurationChecker {
    private final Configuration configuration;

    public ConfigurationChecker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void check() throws IOException {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        ClassPath classPath = this.configuration.programJars;
        ClassPath classPath2 = this.configuration.libraryJars;
        if (classPath == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        ClassPathEntry classPathEntry = classPath.get(0);
        if (classPathEntry.isOutput()) {
            throw new IOException("The output jar [" + classPathEntry.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (int i = 0; i < classPath.size() - 1; ++i) {
            ClassPathEntry classPathEntry2 = classPath.get(i);
            if (!classPathEntry2.isOutput() || classPathEntry2.isFiltered() || !classPath.get(i + 1).isOutput()) continue;
            throw new IOException("The output jar [" + classPathEntry2.getName() + "] must have a filter, or all subsequent output jars will be empty.");
        }
        this.checkConflicts(classPath, classPath);
        this.checkConflicts(classPath, classPath2);
        this.checkConflicts(classPath2, classPath2);
        if (this.configuration.note == null || !this.configuration.note.isEmpty()) {
            int n;
            String string;
            if (this.configuration.obfuscate && this.configuration.useMixedCaseClassNames && this.configuration.classObfuscationDictionary == null && ((string = System.getProperty("os.name").toLowerCase()).startsWith("windows") || string.startsWith("mac os"))) {
                for (int i = 0; i < classPath.size(); ++i) {
                    ClassPathEntry classPathEntry3 = classPath.get(i);
                    if (!classPathEntry3.isOutput() || classPathEntry3.isApk() || classPathEntry3.isJar() || classPathEntry3.isAar() || classPathEntry3.isWar() || classPathEntry3.isEar() || classPathEntry3.isJmod() || classPathEntry3.isZip()) continue;
                    printWriter.println("Note: you're writing the processed class files to a directory [" + classPathEntry3.getName() + "].");
                    printWriter.println("      This will likely cause problems with obfuscated mixed-case class names.");
                    printWriter.println("      You should consider writing the output to a jar file, or otherwise");
                    printWriter.println("      specify '-dontusemixedcaseclassnames'.");
                    break;
                }
            }
            if (this.configuration.adaptResourceFileContents != null && (this.configuration.adaptResourceFileContents.isEmpty() || this.configuration.adaptResourceFileContents.get(0).equals("**"))) {
                printWriter.println("Note: you're specifying '-adaptresourcefilecontents' for all resource files.");
                printWriter.println("      This will most likely cause problems with binary files.");
            }
            WarningPrinter warningPrinter = new WarningPrinter(printWriter, this.configuration.note);
            new KeepClassMemberChecker(warningPrinter).checkClassSpecifications(this.configuration.keep);
            WarningPrinter warningPrinter2 = new WarningPrinter(printWriter, this.configuration.note);
            new AssumeNoSideEffectsChecker(warningPrinter2).checkClassSpecifications(this.configuration.assumeNoSideEffects);
            int n2 = warningPrinter.getWarningCount();
            if (n2 > 0) {
                printWriter.println("Note: there were " + n2 + " '-keepclassmembers' options that didn't specify class");
                printWriter.println("      members. You should specify at least some class members or consider");
                printWriter.println("      if you just need '-keep'.");
                printWriter.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#classmembers)");
            }
            if ((n = warningPrinter2.getWarningCount()) > 0) {
                printWriter.println("Note: there were " + n + " '-assumenosideeffects' options that try to match all");
                printWriter.println("      methods with wildcards. This will likely cause problems with methods like");
                printWriter.println("      'wait()' and 'notify()'. You should specify the methods more precisely.");
                printWriter.println("      (http://proguard.sourceforge.net/manual/troubleshooting.html#nosideeffects)");
            }
        }
    }

    private void checkConflicts(ClassPath classPath, ClassPath classPath2) throws IOException {
        if (classPath == null || classPath2 == null) {
            return;
        }
        for (int i = 0; i < classPath.size(); ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            for (int j = 0; j < classPath2.size(); ++j) {
                ClassPathEntry classPathEntry2;
                if (classPath == classPath2 && i == j || !(classPathEntry2 = classPath2.get(j)).getName().equals(classPathEntry.getName())) continue;
                if (classPathEntry.isOutput()) {
                    if (classPathEntry2.isOutput()) {
                        throw new IOException("The same output jar [" + classPathEntry.getName() + "] is specified twice.");
                    }
                    throw new IOException("Input jars and output jars must be different [" + classPathEntry.getName() + "].");
                }
                if (classPathEntry2.isOutput()) {
                    throw new IOException("Input jars and output jars must be different [" + classPathEntry.getName() + "].");
                }
                if (classPathEntry.isFiltered() && classPathEntry2.isFiltered()) continue;
                throw new IOException("The same input jar [" + classPathEntry.getName() + "] is specified twice.");
            }
        }
    }
}

