/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import proguard.obfuscate.MappingProcessor;
import proguard.retrace.FrameInfo;

public class FrameRemapper
implements MappingProcessor {
    private final Map<String, String> classMap = new HashMap<String, String>();
    private final Map<String, Map<String, Set<FieldInfo>>> classFieldMap = new HashMap<String, Map<String, Set<FieldInfo>>>();
    private final Map<String, Map<String, Set<MethodInfo>>> classMethodMap = new HashMap<String, Map<String, Set<MethodInfo>>>();

    public List<FrameInfo> transform(FrameInfo frameInfo) {
        String string = this.originalClassName(frameInfo.getClassName());
        if (string == null) {
            return null;
        }
        ArrayList<FrameInfo> arrayList = new ArrayList<FrameInfo>();
        this.transformFieldInfo(frameInfo, string, arrayList);
        this.transformMethodInfo(frameInfo, string, arrayList);
        if (arrayList.isEmpty()) {
            arrayList.add(new FrameInfo(string, this.sourceFileName(string), frameInfo.getLineNumber(), frameInfo.getType(), frameInfo.getFieldName(), frameInfo.getMethodName(), frameInfo.getArguments()));
        }
        return arrayList;
    }

    private void transformFieldInfo(FrameInfo frameInfo, String string, List<FrameInfo> list) {
        String string2;
        Set<FieldInfo> set;
        Map<String, Set<FieldInfo>> map = this.classFieldMap.get(string);
        if (map != null && (set = map.get(string2 = frameInfo.getFieldName())) != null) {
            String string3 = frameInfo.getType();
            String string4 = string3 == null ? null : this.originalType(string3);
            for (FieldInfo fieldInfo : set) {
                if (!fieldInfo.matches(string4)) continue;
                list.add(new FrameInfo(fieldInfo.originalClassName, this.sourceFileName(fieldInfo.originalClassName), frameInfo.getLineNumber(), fieldInfo.originalType, fieldInfo.originalName, frameInfo.getMethodName(), frameInfo.getArguments()));
            }
        }
    }

    private void transformMethodInfo(FrameInfo frameInfo, String string, List<FrameInfo> list) {
        String string2;
        Set<MethodInfo> set;
        Map<String, Set<MethodInfo>> map = this.classMethodMap.get(string);
        if (map != null && (set = map.get(string2 = frameInfo.getMethodName())) != null) {
            int n = frameInfo.getLineNumber();
            String string3 = frameInfo.getType();
            String string4 = string3 == null ? null : this.originalType(string3);
            String string5 = frameInfo.getArguments();
            String string6 = string5 == null ? null : this.originalArguments(string5);
            for (MethodInfo methodInfo : set) {
                if (!methodInfo.matches(n, string4, string6)) continue;
                int n2 = frameInfo.getLineNumber();
                if (methodInfo.originalFirstLineNumber != methodInfo.obfuscatedFirstLineNumber) {
                    n2 = methodInfo.originalLastLineNumber != 0 && methodInfo.originalLastLineNumber != methodInfo.originalFirstLineNumber && methodInfo.obfuscatedFirstLineNumber != 0 && n2 != 0 ? methodInfo.originalFirstLineNumber - methodInfo.obfuscatedFirstLineNumber + n2 : methodInfo.originalFirstLineNumber;
                }
                list.add(new FrameInfo(methodInfo.originalClassName, this.sourceFileName(methodInfo.originalClassName), n2, methodInfo.originalType, frameInfo.getFieldName(), methodInfo.originalName, methodInfo.originalArguments));
            }
        }
    }

    private String originalArguments(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) >= 0) {
            stringBuilder.append(this.originalType(string.substring(n2, n).trim())).append(',');
            n2 = n + 1;
        }
        stringBuilder.append(this.originalType(string.substring(n2).trim()));
        return stringBuilder.toString();
    }

    private String originalType(String string) {
        int n = string.indexOf(91);
        return n >= 0 ? this.originalClassName(string.substring(0, n)) + string.substring(n) : this.originalClassName(string);
    }

    private String originalClassName(String string) {
        String string2 = this.classMap.get(string);
        return string2 != null ? string2 : string;
    }

    private String sourceFileName(String string) {
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.indexOf(36, n);
        return (n2 > 0 ? string.substring(n, n2) : string.substring(n)) + ".java";
    }

    @Override
    public boolean processClassMapping(String string, String string2) {
        this.classMap.put(string2, string);
        return true;
    }

    @Override
    public void processFieldMapping(String string, String string2, String string3, String string4, String string5) {
        Set<FieldInfo> set;
        Map<String, Set<FieldInfo>> map = this.classFieldMap.get(string4);
        if (map == null) {
            map = new HashMap<String, Set<FieldInfo>>();
            this.classFieldMap.put(string4, map);
        }
        if ((set = map.get(string5)) == null) {
            set = new LinkedHashSet<FieldInfo>();
            map.put(string5, set);
        }
        set.add(new FieldInfo(string, string2, string3));
    }

    @Override
    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4, String string5, int n3, int n4, String string6) {
        Set<MethodInfo> set;
        Map<String, Set<MethodInfo>> map = this.classMethodMap.get(string5);
        if (map == null) {
            map = new HashMap<String, Set<MethodInfo>>();
            this.classMethodMap.put(string5, map);
        }
        if ((set = map.get(string6)) == null) {
            set = new LinkedHashSet<MethodInfo>();
            map.put(string6, set);
        }
        set.add(new MethodInfo(n3, n4, string, n, n2, string2, string3, string4));
    }

    private static class MethodInfo {
        private final int obfuscatedFirstLineNumber;
        private final int obfuscatedLastLineNumber;
        private final String originalClassName;
        private final int originalFirstLineNumber;
        private final int originalLastLineNumber;
        private final String originalType;
        private final String originalName;
        private final String originalArguments;

        private MethodInfo(int n, int n2, String string, int n3, int n4, String string2, String string3, String string4) {
            this.obfuscatedFirstLineNumber = n;
            this.obfuscatedLastLineNumber = n2;
            this.originalType = string2;
            this.originalArguments = string4;
            this.originalClassName = string;
            this.originalName = string3;
            this.originalFirstLineNumber = n3;
            this.originalLastLineNumber = n4;
        }

        private boolean matches(int n, String string, String string2) {
            return !(!(n == 0 ? this.obfuscatedLastLineNumber == 0 : this.obfuscatedFirstLineNumber <= n && n <= this.obfuscatedLastLineNumber) || string != null && !string.equals(this.originalType) || string2 != null && !string2.equals(this.originalArguments));
        }
    }

    private static class FieldInfo {
        private final String originalClassName;
        private final String originalType;
        private final String originalName;

        private FieldInfo(String string, String string2, String string3) {
            this.originalClassName = string;
            this.originalType = string2;
            this.originalName = string3;
        }

        private boolean matches(String string) {
            return string == null || string.equals(this.originalType);
        }
    }
}

