## Version 7.0 (Jun 2020)

| Version| Issue    | Module   | Explanation
|--------|----------|----------|----------------------------------
| 7.0.1  | DGD-2382 | CORE     | Fixed processing of Kotlin 1.4 metadata annotations.
| 7.0.1  | DGD-2494 | CORE     | Fix naming conflict resolution potentially resulting in the renaming of library members.
| 7.0.1  |          | RETRACE  | Extend expressions supported by Retrace.
| 7.0.0  |          | CORE     | Added support for [Kotlin metadata](manual/kotlin.md), with new option `-keepkotlinmetadata`.
| 7.0.0  | PGD-32   | CORE     | Allowing Java 14 class files.
| 7.0.0  |          | CORE     | Optimizing away instance references to constructor-less classes.
| 7.0.0  | DGD-1489 | CORE     | Fixed potential `IllegalArgumentException` with message `Value "x" is not a reference value` when optimizing code with conditional casts.
| 7.0.0  | PGD-12   | CORE     | Fixed building gradle plugin.

## Version 6.2 (Oct 2019)

| Version| Issue    | Module   | Explanation
|--------|----------|----------|----------------------------------
| 6.2.2  |          | GRADLE   | Fixed missing runtime dependencies.
| 6.2.1  | PGD-12   | GRADLE   | Fixed build of Gradle plugin.
| 6.2.1  | DGD-827  | CORE     | Fixed retracing of obfuscated class / method names in some cases.
| 6.2.1  | PGD-15   | CORE     | Fixed potential `ClassFormatError` due to corrupt LineNumberTables when processing class files generated by groovy 2.5.5+.
| 6.2.1  | DGD-1503 | CORE     | Added default filter to prevent processing of versioned class files.
| 6.2.1  | DGD-1364 | DOCS     | Documented the mapping file format.
| 6.2.1  | DGD-950  | CORE     | Fixed potential `EmptyStackException` when generating mapping files with inlined methods in rare cases.
| 6.2.1  | PGD-10   | CORE     | Fixed potential `VerifyError` when optimizing classes with class version `11+` due to nest based access.
| 6.2.1  | PGD-11   | CORE     | Fixed gradle example for processing libraries.
| 6.2.1  | PGD-8    | CORE     | Fixed potential `IllegalArgumentException` with message `Value "x" is not a reference value` when optimizing code with conditional casts.
| 6.2.1  | DGD-1424 | CORE     | Fixed incomplete fix in case of inlining method with type annotations.
| 6.2.0  | DGD-1359 | CORE     | Fixed removal of non-static write-only fields (optimization `field/removal/writeonly`).
| 6.2.0  | DGD-1424 | CORE     | Fixed potential build error when inlining methods into code attributes with type annotations.
| 6.2.0  | PGD-764  | GUI      | Fixed text fields for obfuscation dictionaries.
| 6.2.0  | PGD-751  | GUI      | Fixed boilerplate settings and foldable panels.
| 6.2.0  | DGD-1418 | CORE     | Fixed class member access checking for backporting of closures.
| 6.2.0  | DGD-1359 | CORE     | Fixed removal of write-only fields.
| 6.2.0  | PGD-756  | CORE     | Fixed detection of functional interfaces.
| 6.2.0  | DGD-1317 | CORE     | Fixed potential build errors when optimizing methods with many parameters.
| 6.2.0  | PGD-753  | CORE     | Fixed processing of signature attributes in constructors of inner classes and enum types.
| 6.2.0  | PGD-759  | CORE     | Fixed backporting of Java 8 API types when used as parameters in private methods.
| 6.2.0  | PGD-1    | CORE     | Fixed optimization of exception handling in Kotlin runtime.

## Version 6.1 (May 2019)

- \[PGD-750\] Fixed UnsupportedOperationException when optimizing enum types
  in closure arguments.
- \[DGD-1276\] Fixed optimization of Groovy code constructs causing Dalvik
  conversion errors.
- \[DGD-1258\] Fixed potential VerifyError in JVM caused by inlining methods
  from super class.
- \[PGD-752\] Fixed preverification of initializers with inlined exception
  throwing code.
- \[PGD-755\] Fixed compatibility with older versions of ProGuard
  when used in combination with the Android gradle plugin.
- Fixed potential NullPointerException when using keep rules with
  includecode modifier.
- \[PGD-749\] Fixed merging of classes containing type annotations with empty
  targets.
- \[PGD-748\] Fixed optimization of exceptions as unused parameters.
- \[PGD-747\] Removed unwanted logging injection for native library loading.
- \[PGD-745\] Fixed IllegalArgumentException for comparison of constant arrays
  with NaN float/double values.
- \[PGD-744\] Fixed potential ClassCastException when optimizing method handles
  of simple enum types.
- \[DGD-504\] Fixed potential build errors when optimizing Kotlin
  code that combines `let` and the Elvis operator `?:`.
- \[PGD-741\] Improved incremental obfuscation.
- \[DGD-1050\] Fixed obfuscation of enums in annotations, for
  conversion by dx or D8.
- \[PGD-739\] Fixed the counter for the number of inlined
  constant parameters.
- \[PGD-188\] Added support for Java 10, 11, and 12.
- \[PGD-740\] Fixed shrinking of nest member attributes.
- \[PGD-735\] Fixed processing of parameter annotations in
  constructors of inner classes and enum types.
- \[PGD-734\] Fixed processing of lambda expressions for non-obvious
  functional interfaces.
- Added optimization of code that uses the GSON library, removing
  reflection to improve size and performance of the processed code.
- Added automatic backporting of code using the Java 8 stream API,
  enabled by adding net.sourceforge.streamsupport as a library.
- Added automatic backporting of Java 8 time API, enabled by adding
  org.threeten as a library.
- Added option `-assumevalues`, with corresponding optimizations on
  integer intervals.
- \[PGD-731\] Fixed incorrect error message about generics in
  wildcard expressions.
- \[PGD-730\] Fixed infinite loop in optimization.
- \[PGD-720\] Fixed unboxed enum types being compared to null.
- Fixed writing out mapping files with duplicate lines.
- Fixed potentially inconsistent local variable type table.
- Fixed backporting of default interface methods if an interface
  extends another one.
- Now uniformly reading and writing text files with UTF-8 encoding.
- \[PGD-708\] Fixed possible verification error due to exception
  handlers in Kotlin initializers.
- \[PGD-712\] Fixed NullPointerException triggered by `module-info`
  classes with `requires` without version.
- \[PGD-709\] Improved error messages for problems parsing wildcards.

## Version 6.0 (Feb 2018)

- \[PGD-701\] Fixed potential VerifyError in the presence of branches
  to instruction offset 0.
- Fixed backporting of lambda functions using the alternative
  factory method.
- \[PGD-699\] Fixed obfuscation of closures that implement
  multiple interfaces.
- \[PGD-694\] Fixed classes prefix when writing output to directories.
- \[PGD-186\] Added support for Java 10.
- \[PGD-698\] Fixed possible NullPointerException when
  parsing configuration.
- \[PGD-655\] Fixed access from static methods to protected methods
  in superclasses.
- \[PGD-693\] Fixed obfuscation of closures for functional interfaces
  with default methods.
- Added new option `-if`, to specify conditions for [`-keep`](manual/usage.md#keep) options.
- Added new option `-addconfigurationdebugging`, to instrument the
  code to get feedback about missing configuration at runtime.
- Added new option [`-android`](manual/usage.md#android) to tune processing for Android.
- Added support for references to matched wildcards in regular
  expressions in `-keep` options.
- Added new options `-assumenoexternalsideeffects`,
  `-assumenoescapingparameters`, and `-assumenoexternalreturnvalues`,
  to express fine-grained assumptions for better code optimization.
- Added backporting of Java 8 code.
- Added backporting and support for Java 9 code.
- Improved vertical class merging.
- \[PGD-689\] Fixed optimization potentially causing unexpected error
  while processing Kotlin bytecode.
- \[PGD-690\] Fixed NullPointerException when editing keep
  specifications in GUI.
- \[PGD-688\] Fixed UnsupportedOperationException while optimizing
  type annotations.
- \[PGD-654\] Fixed processing of MethodParameters attributes with
  nameless parameters.
- \[PGD-662\] Fixed obfuscation causing clashing private and default
  method names.
- \[PGD-684\] Fixed obfuscation of extensions of functional interfaces
  that are implemented with closures.
- \[PGD-681\] Fixed potential IllegalArgumentException in
  simplification of tail recursion.
- \[PGD-672\] Fixed memory leak writing compressed zip entries.
- \[PGD-652\] Fixed possible NullPointerException due to missing
  variable initialization.
- \[PGD-641\] Fixed possible NullPointerException due to optimized
  enum types.
- \[PGD-630\] Fixed possible NullPointerException in
  optimization step.
- \[PGD-637\] Fixed simplification of enum types in
  invokedynamic calls.
- Fixed merging of classes sometimes resulting in final methods
  being overridden.
- Fixed simplification of enum types that are stored in arrays.
- Fixed VerifyError triggered by merging classes with
  shrinking disabled.

## Version 5.3 (Sep 2016)

- Avoiding obfuscated name clashes with library classes.
- Fixed processing of generic signatures with inner classes.
- Fixed processing of generic signatures with array types as bounds.
- Fixed processing of wide branch instructions.
- Fixed shrinking of nameless parameters attribute.
- Fixed optimization of code with unreachable exception handlers.
- Fixed optimization of enum types with custom fields.
- Fixed optimization of enum types with custom static methods.
- Fixed optimization of lambda method types.
- Fixed optimization of parameter annotations.
- Fixed optimization of swap/pop constructs.
- Fixed adapting class access for referenced class members.
- Fixed adapting invocations for referenced class members.
- Preserving class member signature classes if
  `includedescriptorclasses` is specified.
- Allowing empty output jars if [`-ignorewarnings`](manual/usage.md#ignorewarnings) is specified.
- Avoiding exceptions when inlining invalid line number
  instruction offsets.
- Fixed preverification of wildcard exceptions.
- Fixed ReTrace for field names.
- Fixed ReTrace for negative line numbers.
- Improved ReTrace regular expression for Logback and Log4j.
- Added Gradle build file.
- Updated documentation and examples.

## Version 5.2 (Jan 2015)

- Added encoding of optimized line numbers in ProGuard.
- Added decoding of optimized stack frames in ReTrace.
- Added overflow checks when writing out class files.
- Fixed shrinking of default methods in subinterfaces.
- Fixed optimization of closures with signatures containing
  merged classes.
- Fixed conservative optimization of instructions that may
  throw exceptions.
- Fixed internal processing of primitive array types.
- Updated documentation and examples.

## Version 5.1 (Oct 2014)

- Fixed processing of various kinds of closures in Java 8.
- Fixed shrinking of generic signatures in classes and methods.
- Fixed shrinking of debug information about generic local
  variable types.
- Fixed optimization of default implementations in interfaces.
- Fixed optimization of variable initializations.
- Fixed obfuscation of internal class names in strings.
- Updated documentation and examples.

## Version 5.0 (Aug 2014)

- Added support for Java 8.
- Added [`-keep`](manual/usage.md#keep) modifier `includedescriptorclasses`.
- Added automatic suggestions for keeping attributes.
- Clearing preverification information when `-dontpreverify`
  is specified.
- Extended optimization support for conservative optimization with
  java system property `optimize.conservatively`.
- Fixed occasional preverification problem.
- Fixed shrinking of generic class signatures.
- Fixed shrinking of generic variable signatures.
- Fixed analysis of unused parameters for bootstrap methods in
  library classes.
- Fixed inlining problem of non-returning subroutines.
- Fixed possible IllegalArgumentException and
  ArrayIndexOutOfBoundsException in enum simplification.
- Fixed unnecessary notes about dynamic class instantiations with
  constant class names.
- Fixed preverification of unnecessary casts of null values.
- Fixed lazy resolution of output jars in Gradle task.
- Fixed processing of synthetic code with alternative
  initializer invocations.
- Improved handling of symbolic links in shell scripts.
- Improved default path in Windows bat files.
- Updated documentation and examples.

## Version 4.11 (Dec 2013)

- Added simplification of basic enum types.
- Added reading and writing of apk and aar archives.
- Fixed criteria for class merging.
- Fixed simplification of variable initializations.
- Fixed simplification of redundant boolean variables.
- Fixed optimization of unused stack entries in exception handlers.
- Fixed correction of access flags after class merging, method
  inlining, and class repackaging.
- Refined criterion for method inlining.
- Updated documentation and examples.

## Version 4.10 (Jul 2013)

- Made Gradle task resolve files lazily.
- Enabled as-needed execution in Gradle task.
- Using standard string interpolation for Gradle configuration.
- Reduced log levels for console output in Gradle task.
- Updated documentation and examples.

## Version 4.9 (Mar 2013)

- Added Gradle task.
- Added more peephole optimizations for strings.
- Improved optimization of classes with static initializers.
- Improved processing of finally blocks compiled with JDK 1.4
  or older.
- Fixed shrinking of access widening abstract methods, for the
  Dalvik VM.
- Fixed overly aggressive shrinking of class annotations.
- Fixed processing of unused classes in generic signatures.
- Fixed merging of classes with similar class members.
- Added java system property `optimize.conservatively` to allow for
  instructions intentionally throwing `NullPointerException`,
  `ArrayIndexOutOfBoundsException`, or `ClassCastException` without
  other useful effects.
- Fixed optimization of unnecessary variable initializations.
- Fixed optimization of code involving NaN.
- Fixed inlining of methods that are supposed to be kept.
- Fixed preverification of artificially convoluted dup constructs.
- Fixed quotes for java commands in .bat scripts.
- Improved handling of non-sequential line number information.
- Now requiring Java 5 or higher for running ProGuard.
- Updated build files.
- Updated documentation and examples.

## Version 4.8 (May 2012)

- Added more peephole optimizations for strings.
- Added support for multiple external configuration files in
  Ant configurations.
- Added support for Ant properties in external configuration files.
- Fixed parsing of empty file filters on input and output.
- Fixed parsing of '\*' wildcard for file filters and name filters.
- Fixed obfuscation of private methods that are overridden in concrete
  classes with intermediary abstract classes and interfaces
  (workaround for Oracle bugs \#6691741 and \#6684387).
- Fixed optimization of complex finally blocks, compiled with JDK 1.4
  or earlier.
- Fixed optimizing signatures of methods that are marked as not having
  side effects.
- Fixed optimization of long local variables possibly causing
  verification error for register pairs.
- Fixed merging of classes defined inside methods.
- Fixed stack consistency in optimization step.
- No longer removing debug information about unused parameters, for
  `-keepparameternames` or `-keepattributes`.
- Fixed updating manifest files with carriage return characters.
- Now removing unreachable code in preverification step.
- Improved default regular expression for stack traces in ReTrace.
- Updated documentation and examples.

## Version 4.7 (Dec 2011)

- Added support for Java 7.
- Parsing unquoted file names with special characters more leniently.
- Added support for instance methods overriding class methods.
- Added removal of unused parameterless constructors.
- Added removal of empty class initializers.
- Added peephole optimizations for constant strings.
- Avoiding idle optimization passes.
- Improved removal of unused constants after obfuscation.
- Fixed removal of unused classes referenced by annotations.
- Fixed simplifying parameters of constructors that should actually
  be preserved.
- Fixed simplifying parameters of large numbers of
  similar constructors.
- Fixed exceptions in optimization of unusual obfuscated code.
- Fixed NullPointerException when specifying `-keepclassmembers`
  without specific class or class members.
- Fixed potential problems with mixed-case class name dictionaries
  when not allowing mixed-case class names.
- Fixed obfuscation of classes with EnclosingMethod attributes that
  don't specify methods.
- Fixed preverification of returning try blocks with finally blocks,
  inside try blocks, when compiled with JDK 1.4.
- Fixed sorting of interfaces containing generics.
- Fixed paths in shell scripts.
- Fixed filling in of text fields showing class obfuscation dictionary
  and package obfuscation dictionary from configuration in GUI.
- Worked around Oracle Java 6/7 bug \#7027598 that locked the GUI
  on Linux.
- Updated documentation and examples.

## Version 4.6 (Feb 2011)

- Added support for synthetic, bridge, and varargs modifiers
  in configuration.
- Added detection of atomic updater construction with
  constant arguments.
- Fixed merging of package visible classes.
- Fixed optimization of fields that are only accessed by reflection.
- Fixed optimization of read-only or write-only fields that
  are volatile.
- Fixed handling of side-effects due to static initializers.
- Fixed handling of bridge flags in obfuscation step.
- Fixed handling of super flag when merging classes.
- Fixed updating of variable tables when optimizing variables.
- Fixed removal of unused parameters with 32 or more parameters.
- Fixed incorrect removal of exception handler for
  instanceof instruction.
- Fixed inlining of methods with unusual exception handlers.
- Fixed optimization of unusual code causing stack underflow.
- Fixed keeping of constructor parameter names.
- Fixed unwanted wrapping of non-standard META-INF files.
- Fixed filtering of warnings about references to array types.
- Fixed overriding of warning option and note option in Ant task.
- Improved detection of file name extensions for canonical paths.
- Improved printing of seeds specified by [`-keep`](manual/usage.md#keep) options.
- Improved printing of notes about unkept classes.
- Improved checking whether output is up to date.
- Updated documentation and examples.

## Version 4.5 (Jun 2010)

- Added option `-keepparameternames`.
- [`-dontskipnonpubliclibraryclasses`](manual/usage.md#dontskipnonpubliclibraryclasses) is now set by default. Added
  `-skipnonpubliclibraryclasses` as an option.
- Made processing independent of order of input classes to get even
  more deterministic output.
- Improved constant field propagation.
- Improved renaming of resource files in subdirectories of packages.
- Avoiding making fields in interfaces private.
- Optimizing exception handlers for monitorexit instruction.
- Reduced maximum allowed code length after inlining from 8000 bytes
  to 7000 bytes.
- Fixed missing warnings about missing library classes.
- Fixed shrinking of annotations with arrays of length 0.
- Fixed handling of -0.0 and NaN values when simplifying expressions.
- Fixed copying of exception handlers when simplifying tail
  recursion calls.
- Fixed optimization of introspected fields.
- Fixed simplification of unnecessary variable initializations.
- Fixed evaluation of subroutines in pre-JDK 1.5 code.
- Fixed updating of access flags in inner classes information.
- Fixed disabling of field privatization.
- Fixed invocations of privatized methods.
- Fixed updating of local variable debug information in
  optimization step.
- Fixed print settings without file name in GUI.
- Fixed field privatization setting in GUI.
- Fixed saving incorrectly quoted arguments in GUI.
- Fixed handling of regular expressions with only negators.
- Fixed unwanted wrapping of non-standard META-INF files.
- Fixed regular expression pattern for constructors in ReTrace.
- Updated documentation and examples.

## Version 4.4 (Jul 2009)

- Added new peephole optimizations.
- Added option [`-optimizations`](manual/usage.md#optimizations) for fine-grained configuration
  of optimizations.
- Added option [`-adaptclassstrings`](manual/usage.md#adaptclassstrings) for adapting string constants that
  correspond to obfuscated classes.
- Added option [`-keeppackagenames`](manual/usage.md#keeppackagenames) for keeping specified package names
  from being obfuscated.
- Added option [`-keepdirectories`](manual/usage.md#keepdirectories) for keeping specified directory
  entries in output jars.
- Extended options [`-dontnote`](manual/usage.md#dontnote) and [`-dontwarn`](manual/usage.md#dontwarn) for fine-grained
  configuration of notes and warnings.
- Added option `-regex` in ReTrace, for specifying alternative regular
  expressions to parse stack traces.
- Extended renaming of resource files based on obfuscation.
- Improved inlining of constant parameters and removal of
  unused parameters.
- Avoiding bug in IBM's JVM for JSE, in optimization step.
- Avoiding ArrayIndexOutOfBoundsException in optimization step.
- Fixed configuration with annotations that are not
  preserved themselves.
- Fixed preverification of invocations of super constructors with
  arguments containing ternary operators.
- Fixed processing of unreachable exception handlers.
- Fixed merging of exception classes.
- Fixed repeated method inlining.
- Fixed inlining of finally blocks surrounded by large try blocks,
  compiled with JDK 1.4 or earlier.
- Fixed optimization of complex finally blocks, compiled with JDK 1.4
  or earlier.
- Fixed obfuscation of anonymous class names, if `EnclosingMethod`
  attributes are being kept.
- Fixed obfuscation of inner class names in generic types.
- Fixed decoding of UTF-8 strings containing special characters.
- Fixed copying of debug information and annotations when
  merging classes.
- Fixed writing out of unknown attributes.
- Fixed updating manifest files with split lines.
- Updated documentation and examples.

## Version 4.3 (Dec 2008)

- Added class merging.
- Added static single assignment analysis.
- Added support for annotation and enumeration class types
  in configuration.
- Refined shrinking of fields in case of unusual
  `-keepclassmembers` options.
- Added simplification of tail recursion calls.
- Added new peephole optimizations.
- Fixed optimization of unused variable initializations causing
  negative stack sizes.
- Fixed optimization of unusual initialization code
  causing NullPointerExceptions.
- Fixed optimization of half-used long and double parameters.
- Fixed processing of complex generics signatures.
- Working around suspected java compiler bug with parameter
  annotations on constructors of non-static inner classes.
- Fixed obfuscation of classes with inner classes whose names
  are preserved.
- Fixed access of protected methods in repackaged classes.
- Added options [`-classobfuscationdictionary`](manual/usage.md#classobfuscationdictionary) and
  `-packageobfuscationdictionary`.
- Adapting more types of resource file names based on obfuscation.
- Extended warnings about incorrect dependencies.
- Added start-up scripts and build scripts.
- Updated documentation and examples.

## Version 4.2 (Mar 2008)

- Refined data flow analysis in optimization step.
- Fixed handling of exceptions when inlining subroutines.
- Fixed inlining of incompatible code constructs between different
  java versions.
- Fixed computation of local variable frame size.
- Fixed optimization of infinite loops.
- Fixed optimization of subroutine invocations.
- Fixed optimization of floating point remainder computations.
- Fixed removal of unused parameters in method descriptors containing
  arrays of longs or doubles.
- Added undocumented java system properties
  `maximum.inlined.code.length` (default is 8) and
  `maximum.resulting.code.length` (defaults are 8000 for JSE and 2000
  for JME), for expert users who read release notes.
- Fixed processing of generic types in Signature attributes in
  shrinking and optimization steps.
- Fixed processing of inner class names in Signature attributes in
  obfuscation step.
- Improved adapting resource file names following obfuscated
  class names.
- Fixed interpretation of package names in GUI.
- Fixed default settings for Xlets in GUI.
- Updated documentation and examples.

## Version 4.1 (Dec 2007)

- Fixed shrinking of default annotation element values.
- Fixed optimization of invocations of methods in same class that are
  accessed through extensions.
- Fixed optimization of invocations of synchronized methods without
  other side-effects.
- Fixed optimization of some non-returning subroutines.
- Fixed handling of local variable debug information when
  inlining methods.
- Avoiding StackOverflowErrors during optimization of complex methods.
- Fixed obfuscation of potentially ambiguous non-primitive constants
  in interfaces.
- Fixed preverification of some code constructs involving String,
  Class, and exception types.
- The Ant task now allows empty `<injars>` and
  `<libraryjars>` elements.
- Updated documentation and examples.

## Version 4.0 (Sep 2007)

- Added preverifier for Java 6 and Java Micro Edition, with new
  options `-microedition` and `-dontpreverify`.
- Added new option [`-target`](manual/usage.md#target) to modify java version of processed
  class files.
- Made [`-keep`](manual/usage.md#keep) options more orthogonal and flexible, with option
  modifiers `allowshrinking`, `allowoptimization`, and
  `allowobfuscation`.
- Added new wildcards for class member descriptors: "`***`", matching
  any type, and "`...`", matching any number of arguments.
- Added support for configuration by means of annotations.
- Improved shrinking of unused annotations.
- Added check on modification times of input and output, to avoid
  unnecessary processing, with new option `-forceprocessing`.
- Added new options [`-flattenpackagehierarchy`](manual/usage.md#flattenpackagehierarchy) and `-repackageclasses`
  (replacing `-defaultpackage`) to control obfuscation of
  package names.
- Added new options [`-adaptresourcefilenames`](manual/usage.md#adaptresourcefilenames) and
  `-adaptresourcefilecontents`, with file filters, to update resource
  files corresponding to obfuscated class names.
- Added detection of dynamically accessed fields and methods.
- Now treating `Exceptions` attributes as optional.
- Now respecting naming rule for nested class names
  (`EnclosingClass$InnerClass`) in obfuscation step, if `InnerClasses`
  attributes or `EnclosingMethod` attributes are being kept.
- Added new inter-procedural optimizations: method inlining and
  propagation of constant fields, constant arguments, and constant
  return values.
- Added optimized local variable allocation.
- Added more than 250 new peephole optimizations.
- Improved making classes and class members public or protected.
- Now printing notes on suspiciously unkept classes in parameters of
  specified methods.
- Now printing notes for class names that don't seem to be
  fully qualified.
- Added support for uppercase filename extensions.
- Added tool tips to the GUI.
- Rewritten class file I/O code.
- Updated documentation and examples.

Upgrade considerations:

- Since ProGuard now treats the `Exceptions` attribute as optional,
  you may have to specify `-keepattributes Exceptions`, notably when
  processing code that is to be used as a library.
- ProGuard now preverifies code for Java Micro Edition, if you specify
  the option `-microedition`. You then no longer need to process the
  code with an external preverifier.
- You should preferably specify [`-repackageclasses`](manual/usage.md#repackageclasses) instead of the old
  option name `-defaultpackage`.

## Version 3.11 (Dec 2007)

- Fixed optimization of invocations of methods in same class that are
  accessed through extensions.
- Fixed optimization of invocations of synchronized methods without
  other side-effects.
- Updated documentation and examples.

## Version 3.10 (Aug 2007)

- Now handling mixed-case input class names when
  `-dontusemixedcaseclassnames` is specified.
- Fixed optimization of synchronization on classes, as compiled by
  Eclipse and Jikes.
- Fixed optimization of switch statements with unreachable cases.
- Avoiding merging subsequent identically named files.
- Updated documentation and examples.

## Version 3.9 (Jun 2007)

- Fixed processing of .class constructs in Java 6.
- Fixed repeated processing of .class constructs.
- Fixed possible division by 0 in optimization step.
- Fixed handling of variable instructions with variable indices larger
  than 255.
- Updated documentation and examples.

## Version 3.8 (Mar 2007)

- Fixed optimization of parameters used as local variables.
- Fixed obfuscation with conflicting class member names.
- Fixed incremental obfuscation with incomplete mapping file for
  library jars.
- Updated documentation and examples.

## Version 3.7 (Dec 2006)

- Now accepting Java 6 class files.
- Fixed shrinking of partially used annotations.
- Improved incremental obfuscation, with new option
  `-useuniqueclassmembernames`.
- Printing more information in case of conflicting configuration
  and input.
- Fixed optimization of repeated array length instruction.
- Fixed optimization of subsequent try/catch/finally blocks with
  return statements.
- Fixed optimization of complex stack operations.
- Fixed optimization of simple infinite loops.
- Fixed optimization of expressions with constant doubles.
- Tuned optimization to improve size reduction after preverification.
- Fixed overflows of offsets in long code blocks.
- Now allowing class names containing dashes.
- Updated documentation and examples.

## Version 3.6 (May 2006)

- No longer automatically keeping classes in parameters of specified
  methods from obfuscation and optimization (introduced in
  version 3.4).
- Fixed inlining of interfaces that are used in .class constructs.
- Fixed removal of busy-waiting loops reading volatile fields.
- Fixed optimization of comparisons of known integers.
- Fixed optimization of known branches.
- Fixed optimization of method calls on arrays of interfaces.
- Fixed optimization of method calls without side-effects.
- Fixed optimization of nested try/catch/finally blocks with
  return statements.
- Fixed initialization of library classes that only appear
  in descriptors.
- Fixed matching of primitive type wildcards in configuration.
- Fixed the boilerplate specification for enumerations in the GUI.
- Updated documentation and examples.

## Version 3.5 (Jan 2006)

- Fixed obfuscation of class members with complex visibility.
- Fixed optimization bugs causing stack verification errors.
- Fixed optimization bug causing overridden methods to be finalized.
- Fixed optimization bug causing abstract method errors for
  retro-fitted library methods.
- Fixed optimization bug evaluating code with constant long values.
- Fixed bug in updating of optional local variable table attributes
  and local variable type table attributes after optimization.
- Fixed interpretation of comma-separated class names
  without wildcards.
- Updated documentation and examples.

## Version 3.4 (Oct 2005)

- Extended optimizations: removing duplicate code within methods.
- Extended regular expressions for class names to
  comma-separated lists.
- Now automatically keeping classes in descriptors of kept
  class members.
- Added verbose statistics for optimizations.
- Added boilerplate Number optimizations in GUI.
- Fixed `Class.forName` detection.
- Fixed incremental obfuscation bug.
- Fixed optimization bug causing stack verification errors.
- Fixed optimization bugs related to removal of unused parameters.
- Fixed exception when optimizing code with many local variables.
- Fixed exception when saving configuration with initializers in GUI.
- Updated documentation and examples.

## Version 3.3 (Jun 2005)

- Extended optimizations: making methods private and static when
  possible, making classes static when possible, removing
  unused parameters.
- Made file names relative to the configuration files in which they
  are specified. Added `-basedirectory` option.
- Added [`-whyareyoukeeping`](manual/usage.md#whyareyoukeeping) option to get details on why given classes
  and class members are being kept.
- Added warnings for misplaced class files.
- Improved printing of notes for `Class.forName` constructs.
- Implemented '`assumenosideeffects`' nested element in Ant task.
- Improved processing of annotations.
- Fixed reading and writing of parameter annotations.
- Fixed various optimization bugs.
- Fixed wildcards not matching '-' character.
- Fixed wildcard bug and checkbox bugs in GUI.
- Setting file chooser defaults in GUI.
- Leaving room for growBox in GUI on Mac OS X.
- Properly closing configuration files.
- Updated documentation and examples.

## Version 3.2 (Dec 2004)

- Fixed JDK5.0 processing bugs.
- Fixed optimization bugs.
- Fixed relative paths in Ant task.
- Improved speed of shrinking step.
- Updated documentation and examples.

## Version 3.1 (Nov 2004)

- Improved obfuscation and shrinking of private class members.
- Added inlining of interfaces with single implementations.
- Added option to specify obfuscation dictionary.
- Added option to read package visible library class members.
- Extended support for JDK5.0 attributes.
- Fixed various optimization bugs.
- Modified Ant task to accept paths instead of filesets.
- Fixed two Ant task bugs.
- Updated documentation and examples.

## Version 3.0 (Aug 2004)

- Added bytecode optimization step, between shrinking step and
  obfuscation step.
- Generalized filtered recursive reading and writing of jars, wars,
  ears, zips, and directories.
- Added support for grouping input and output jars, wars, ears, zips,
  and directories.
- Added support for applying mapping files to library classes.
- Removed `-resourcejars` option. Resources should now be read using
  regular `-injars` options, using filters if necessary.
- Rewrote Ant task. Input and output modification dates are not
  checked at the moment. Minor changes in XML schema:
  -   Filters now specified using attributes.
  -   '`outjars`' now nested element instead of attribute.
  -   '`type`' attribute of `<method>` element no longer defaults to
      '`void`'.
  -   `<` and `>` characters now have to be encoded in
      embedded configurations.
  -   `<proguardconfiguration>` task no longer accepts attributes.
- Updated J2ME WTK plugin, now customizable through
  configuration file.
- Updated GUI.
- Fixed various processing bugs.
- Fixed ReTrace parsing bugs.
- Improved jar compression.
- Updated documentation and examples.

## Version 2.1 (Mar 2004)

- Added support for JDK1.5 classes.
- Added additional wildcard for matching primitive types.
- Added possibility to switch off notes about duplicate
  class definitions.
- Fixed use of multiple filters on output jars.
- Fixed option to keep all attributes.
- Fixed various Ant task bugs.
- Updated documentation and examples.

## Version 2.0 (Dec 2003)

- Added a graphical user interface for ProGuard and ReTrace.
- Added [`-applymapping`](manual/usage.md#applymapping) option for incremental obfuscation.
- Added support for filtering input and output files.
- Added support for the J++ `SourceDir` attribute.
- Improved detection of `.class` constructs.
- Improved handling of misplaced manifest files.
- Improved implementation of ReTrace.
- Worked around String UTF-8 encoding bug affecting
  foreign characters.
- Fixed exception when ignoring warnings.
- Fixed various Ant task bugs.
- Updated documentation and examples.

## Version 1.7 (Aug 2003)

- Fixed various Ant task bugs.
- Fixed ClassCastException due to explicitly used abstract classes
  with implicitly used interfaces targeted at JRE1.2 (the default
  in JDK1.4).
- Fixed `-defaultpackage` bug for protected classes and class members.
- Fixed ReTrace bug when retracing without line number tables.
- Worked around zip package problems with duplicate out entries and
  rogue manifest files.
- Added work-around for handling malformed legacy interface
  class files.
- Updated documentation and examples.

## Version 1.6 (May 2003)

- Added support for Ant.
- Added support for the J2ME Wireless Toolkit.
- Added support for reading and writing directory hierarchies.
- Added option for specifying resource jars and directories.
- Added support for wildcards in class member specifications.
- Improved handling of the `-defaultpackage` option.
- Improved stack trace parsing in ReTrace tool.
- Fixed processing of libraries containing public as well as
  non-public extensions of non-public classes.
- Fixed examples for processing libraries, midlets, and
  serializable code.
- Updated documentation and examples.

## Version 1.5 (Jan 2003)

- Fixed processing of retrofitted library interfaces.
- Fixed processing of `.class` constructs in internal classes targeted
  at JRE1.2 (the default in JDK1.4).
- Fixed [`-dump`](manual/usage.md#dump) option when `-outjar` option is not present.
- Updated documentation and examples.

## Version 1.4 (Nov 2002)

- Now copying resource files over from the input jars to the
  output jar.
- Added option to obfuscate using lower-case class names only.
- Added better option for obfuscating native methods.
- Added option not to ignore non-public library classes.
- Added automatic `.class` detection for classes compiled with Jikes.
- Updated documentation and examples.

## Version 1.3 (Sep 2002)

- Added support for wildcards in class names.
- Added tool to de-obfuscate stack traces.
- Added options to print processing information to files.
- Added option to rename source file attributes.
- Fixed processing of implicitly used interfaces targeted at JRE1.2
  (the default in JDK1.4)
- Fixed processing of configurations with negated access modifiers.
- Fixed duplicate class entry bug.
- Updated documentation and examples.

## Version 1.2 (Aug 2002)

- Improved speed.
- Fixed processing of classes targeted at JRE1.2 (the default in
  JDK1.4) with references to their own subclasses.
- Fixed processing of static initializers in J2ME MIDP applications.
- Fixed processing of retrofitted interfaces (again).
- Added more flexible handling of white space in configuration.
- Updated documentation.

## Version 1.1 (Jul 2002)

- Added automatic detection of `Class.forName("MyClass")`,
  `MyClass.class`, and
  `(MyClass)Class.forName(variable).newInstance()` constructs. This
  greatly simplifies configuration.
- Added options to keep class names and class member names without
  affecting any shrinking. They are mostly useful for native methods
  and serializable classes.
- Fixed processing of retrofitted interfaces.
- Added handling of missing/invalid manifest file in input jar.
- Updated documentation and examples.

## Version 1.0 (Jun 2002)

- First public release, based on class parsing code from Mark Welsh's
  **RetroGuard**.
