/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class MemberDescriptorSpecializer
implements MemberVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraParameterMemberVisitor;

    public MemberDescriptorSpecializer() {
        this(null);
    }

    public MemberDescriptorSpecializer(MemberVisitor extraParameterMemberVisitor) {
        this.extraParameterMemberVisitor = extraParameterMemberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz referencedClass;
        Value parameterValue = StoringInvocationUnit.getFieldValue(programField);
        if (parameterValue.computationalType() == 5 && programField.referencedClass != (referencedClass = parameterValue.referenceValue().getReferencedClass())) {
            programField.referencedClass = referencedClass;
            if (this.extraParameterMemberVisitor != null) {
                this.extraParameterMemberVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        boolean isStatic = (programMethod.getAccessFlags() & 8) != 0;
        int parameterStart = isStatic ? 0 : 1;
        int parameterCount = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass), isStatic);
        int classIndex = 0;
        for (int parameterIndex = parameterStart; parameterIndex < parameterCount; ++parameterIndex) {
            Value parameterValue = StoringInvocationUnit.getMethodParameterValue(programMethod, parameterIndex);
            if (parameterValue.computationalType() != 5) continue;
            Clazz referencedClass = parameterValue.referenceValue().getReferencedClass();
            if (programMethod.referencedClasses[classIndex] != referencedClass) {
                programMethod.referencedClasses[classIndex] = referencedClass;
                if (this.extraParameterMemberVisitor != null) {
                    this.extraParameterMemberVisitor.visitProgramMethod(programClass, programMethod);
                }
            }
            ++classIndex;
        }
    }
}

