/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.editor.LineNumberTableAttributeEditor;

public class LineNumberInfoAdder
implements AttributeVisitor,
LineNumberInfoVisitor {
    private final LineNumberTableAttributeEditor lineNumberTableAttributeEditor;
    private String source;

    public LineNumberInfoAdder(LineNumberTableAttribute targetLineNumberTableAttribute) {
        this.lineNumberTableAttributeEditor = new LineNumberTableAttributeEditor(targetLineNumberTableAttribute);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.source = clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ':' + lineNumberTableAttribute.getLowestLineNumber() + ':' + lineNumberTableAttribute.getHighestLineNumber();
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        String newSource = lineNumberInfo.getSource() != null ? lineNumberInfo.getSource() : this.source;
        ExtendedLineNumberInfo newLineNumberInfo = new ExtendedLineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber, newSource);
        this.lineNumberTableAttributeEditor.addLineNumberInfo(newLineNumberInfo);
    }
}

