/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class AllAttributeVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final boolean deep;
    private final AttributeVisitor attributeVisitor;

    public AllAttributeVisitor(AttributeVisitor attributeVisitor) {
        this(false, attributeVisitor);
    }

    public AllAttributeVisitor(boolean deep, AttributeVisitor attributeVisitor) {
        this.deep = deep;
        this.attributeVisitor = attributeVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.attributesAccept(this.attributeVisitor);
        if (this.deep) {
            programClass.fieldsAccept(this);
            programClass.methodsAccept(this);
            programClass.attributesAccept(this);
        }
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.attributesAccept(programClass, this.attributeVisitor);
        if (this.deep) {
            programMember.attributesAccept(programClass, this);
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass programClass, LibraryMember programMember) {
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this.attributeVisitor);
    }
}

