/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassPrinter;
import proguard.DuplicateResourceFilePrinter;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.DirectorySource;
import proguard.io.NameFilteredDataEntryReader;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.io.ResourceFileDataEntryReader;
import proguard.resources.file.visitor.MultiResourceFileVisitor;
import proguard.resources.file.visitor.ResourceFilePoolFiller;
import proguard.resources.file.visitor.ResourceFilePresenceFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.io.KotlinModuleDataEntryReader;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class InputReader {
    private static final boolean FAVOR_LIBRARY_CLASSES = System.getProperty("favor.library.classes") != null;
    private final Configuration configuration;
    private String featureName;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool) throws IOException {
        int warningCount;
        int noteCount;
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        WarningPrinter notePrinter = new WarningPrinter(out, this.configuration.note);
        WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
        DuplicateClassPrinter duplicateClassPrinter = new DuplicateClassPrinter(notePrinter);
        DuplicateResourceFilePrinter duplicateResourceFilePrinter = new DuplicateResourceFilePrinter(notePrinter);
        ClassPresenceFilter classPoolFiller = new ClassPresenceFilter(programClassPool, duplicateClassPrinter, new MultiClassVisitor(new ClassPoolFiller(programClassPool), new ProgramClassFilter(clazz -> clazz.setFeatureName(this.featureName))));
        ClassReader classReader = new ClassReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate, warningPrinter, classPoolFiller);
        DataEntryNameFilter adaptedDataEntryFilter = this.configuration.adaptResourceFileContents != null ? new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(this.configuration.adaptResourceFileContents)) : null;
        ResourceFilePresenceFilter resourceFilePoolFiller = new ResourceFilePresenceFilter(resourceFilePool, duplicateResourceFilePrinter, new MultiResourceFileVisitor(new ResourceFilePoolFiller(resourceFilePool), new MyResourceFileFeatureNameSetter()));
        DataEntryReader resourceReader = new ResourceFileDataEntryReader(resourceFilePoolFiller, adaptedDataEntryFilter);
        if (this.configuration.keepKotlinMetadata) {
            resourceReader = new NameFilteredDataEntryReader("META-INF/*.kotlin_module", (DataEntryReader)new KotlinModuleDataEntryReader(resourceFilePoolFiller), resourceReader);
        }
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFilter(classReader, resourceReader));
        if (programClassPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null && (this.configuration.printSeeds != null || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.backport)) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFilter(new ClassReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, true, warningPrinter, new ClassPresenceFilter(programClassPool, duplicateClassPrinter, new ClassPresenceFilter(libraryClassPool, duplicateClassPrinter, new ClassPoolFiller(libraryClassPool))))));
        }
        if ((noteCount = notePrinter.getWarningCount()) > 0) {
            err.println("Note: there were " + noteCount + " duplicate class definitions.");
            err.println("      (https://www.guardsquare.com/proguard/manual/troubleshooting#duplicateclass)");
        }
        if ((warningCount = warningPrinter.getWarningCount()) > 0) {
            err.println("Warning: there were " + warningCount + " classes in incorrectly named files.");
            err.println("         You should make sure all file names correspond to their class names.");
            err.println("         The directory hierarchies must correspond to the package hierarchies.");
            err.println("         (https://www.guardsquare.com/proguard/manual/troubleshooting#unexpectedclass)");
            if (!this.configuration.ignoreWarnings) {
                err.println("         If you don't mind the mentioned classes not being written out,");
                err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void readInput(String messagePrefix, ClassPath classPath, DataEntryReader reader) throws IOException {
        this.readInput(messagePrefix, classPath, 0, classPath.size(), reader);
    }

    public void readInput(String messagePrefix, ClassPath classPath, int fromIndex, int toIndex, DataEntryReader reader) throws IOException {
        for (int index = fromIndex; index < toIndex; ++index) {
            ClassPathEntry entry = classPath.get(index);
            if (entry.isOutput()) continue;
            this.readInput(messagePrefix, entry, reader);
        }
    }

    private void readInput(String messagePrefix, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader reader = new DataEntryReaderFactory(this.configuration.android).createDataEntryReader(messagePrefix, classPathEntry, dataEntryReader);
            DirectorySource source = new DirectorySource(classPathEntry.getFile());
            this.featureName = classPathEntry.getFeatureName();
            source.pumpDataEntries(reader);
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Can't read [" + classPathEntry + "] (" + ex.getMessage() + ")").initCause(ex);
        }
    }

    private class MyResourceFileFeatureNameSetter
    implements ResourceFileVisitor {
        private MyResourceFileFeatureNameSetter() {
        }

        @Override
        public void visitAnyResourceFile(ResourceFile resourceFile) {
            resourceFile.setFeatureName(InputReader.this.featureName);
        }
    }
}

