/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;

public class UnreachableExceptionRemover
implements AttributeVisitor,
ExceptionInfoVisitor {
    private final ExceptionInfoVisitor extraExceptionInfoVisitor;

    public UnreachableExceptionRemover() {
        this(null);
    }

    public UnreachableExceptionRemover(ExceptionInfoVisitor extraExceptionInfoVisitor) {
        this.extraExceptionInfoVisitor = extraExceptionInfoVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        if (!this.mayThrowExceptions(clazz, method, codeAttribute, exceptionInfo.u2startPC, exceptionInfo.u2endPC)) {
            exceptionInfo.u2endPC = exceptionInfo.u2startPC;
            if (this.extraExceptionInfoVisitor != null) {
                this.extraExceptionInfoVisitor.visitExceptionInfo(clazz, method, codeAttribute, exceptionInfo);
            }
        }
    }

    private boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int startOffset, int endOffset) {
        Instruction instruction;
        byte[] code = codeAttribute.code;
        for (int offset = startOffset; offset < endOffset; offset += instruction.length(offset)) {
            instruction = InstructionFactory.create(code, offset);
            if (!instruction.mayThrowExceptions()) continue;
            return true;
        }
        return false;
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfos, int exceptionInfoCount) {
        int newIndex = 0;
        for (int index = 0; index < exceptionInfoCount; ++index) {
            ExceptionInfo exceptionInfo = exceptionInfos[index];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfos[newIndex++] = exceptionInfo;
        }
        return newIndex;
    }
}

