/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationsAttributeEditor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.ParameterAnnotationsAttributeEditor;

class MarkedAnnotationDeleter
implements AttributeVisitor {
    private final Object mark;

    public MarkedAnnotationDeleter(Object mark) {
        this.mark = mark;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, Member member, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, runtimeVisibleAnnotationsAttribute, "RuntimeVisibleAnnotations");
    }

    @Override
    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, Member member, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, runtimeInvisibleAnnotationsAttribute, "RuntimeInvisibleAnnotations");
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, method, runtimeVisibleParameterAnnotationsAttribute, "RuntimeVisibleParameterAnnotations");
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        this.cleanParameterAnnotationsAttribute(clazz, method, runtimeInvisibleParameterAnnotationsAttribute, "RuntimeInvisibleParameterAnnotations");
    }

    @Override
    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, Member member, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, runtimeVisibleTypeAnnotationsAttribute, "RuntimeVisibleTypeAnnotations");
    }

    @Override
    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, Member member, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        this.cleanAnnotationsAttribute(clazz, member, runtimeInvisibleTypeAnnotationsAttribute, "RuntimeInvisibleTypeAnnotations");
    }

    private void cleanAnnotationsAttribute(Clazz clazz, Member member, AnnotationsAttribute attribute, String attributeName) {
        AnnotationsAttributeEditor annotationsAttributeEditor = new AnnotationsAttributeEditor(attribute);
        Annotation[] annotations = attribute.annotations;
        for (int index = 0; index < attribute.u2annotationsCount; ++index) {
            Annotation annotation = annotations[index];
            if (annotation.getProcessingInfo() != this.mark) continue;
            annotationsAttributeEditor.deleteAnnotation(index);
        }
        if (attribute.u2annotationsCount == 0) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)member, false);
            attributesEditor.deleteAttribute(attributeName);
        }
    }

    private void cleanParameterAnnotationsAttribute(Clazz clazz, Member member, ParameterAnnotationsAttribute attribute, String attributeName) {
        ParameterAnnotationsAttributeEditor annotationsAttributeEditor = new ParameterAnnotationsAttributeEditor(attribute);
        boolean allEmpty = true;
        for (int parameterIndex = 0; parameterIndex < attribute.u1parametersCount; ++parameterIndex) {
            int annotationsCount = attribute.u2parameterAnnotationsCount[parameterIndex];
            Annotation[] annotations = attribute.parameterAnnotations[parameterIndex];
            for (int annotationIndex = 0; annotationIndex < annotationsCount; ++annotationIndex) {
                Annotation annotation = annotations[annotationIndex];
                if (annotation.getProcessingInfo() != this.mark) continue;
                annotationsAttributeEditor.deleteAnnotation(parameterIndex, annotationIndex);
            }
            if (attribute.u2parameterAnnotationsCount[parameterIndex] == 0) continue;
            allEmpty = false;
        }
        if (allEmpty) {
            AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, (ProgramMember)member, false);
            attributesEditor.deleteAttribute(attributeName);
        }
    }
}

