/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintWriter;
import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final PrintWriter pw;
    private boolean printed;

    public MappingPrinter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String name = programClass.getName();
        String newName = ClassObfuscator.newClassName(programClass);
        this.pw.println(ClassUtil.externalClassName(name) + " -> " + ClassUtil.externalClassName(newName) + ":");
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String fieldName = programField.getName(programClass);
        String obfuscatedFieldName = MemberObfuscator.newMemberName(programField);
        if (obfuscatedFieldName == null) {
            obfuscatedFieldName = fieldName;
        }
        this.pw.println("    " + ClassUtil.externalType(programField.getDescriptor(programClass)) + " " + fieldName + " -> " + obfuscatedFieldName);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String methodName = programMethod.getName(programClass);
        String obfuscatedMethodName = MemberObfuscator.newMemberName(programMethod);
        if (obfuscatedMethodName == null) {
            obfuscatedMethodName = methodName;
        }
        this.printed = false;
        programMethod.attributesAccept(programClass, this);
        if (!this.printed) {
            this.pw.println("    " + ClassUtil.externalMethodReturnType(programMethod.getDescriptor(programClass)) + " " + methodName + '(' + ClassUtil.externalMethodArguments(programMethod.getDescriptor(programClass)) + ')' + " -> " + obfuscatedMethodName);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumberInfo[] lineNumberTable = lineNumberTableAttribute.lineNumberTable;
        int lineNumberTableLength = lineNumberTableAttribute.u2lineNumberTableLength;
        String methodName = method.getName(clazz);
        String methodDescriptor = method.getDescriptor(clazz);
        String obfuscatedMethodName = MemberObfuscator.newMemberName(method);
        if (obfuscatedMethodName == null) {
            obfuscatedMethodName = methodName;
        }
        int lowestLineNumber = lineNumberTableAttribute.getLowestLineNumber();
        int highestLineNumber = lineNumberTableAttribute.getHighestLineNumber();
        if (lineNumberTableAttribute.getSource(codeAttribute.u4codeLength) == null) {
            if (lowestLineNumber > 0) {
                this.pw.println("    " + lowestLineNumber + ":" + highestLineNumber + ":" + ClassUtil.externalMethodReturnType(method.getDescriptor(clazz)) + " " + methodName + '(' + ClassUtil.externalMethodArguments(method.getDescriptor(clazz)) + ')' + " -> " + obfuscatedMethodName);
            } else {
                this.pw.println("    " + ClassUtil.externalMethodReturnType(method.getDescriptor(clazz)) + " " + methodName + '(' + ClassUtil.externalMethodArguments(method.getDescriptor(clazz)) + ')' + " -> " + obfuscatedMethodName);
            }
        }
        Stack<LineNumberInfo> enclosingLineNumbers = new Stack<LineNumberInfo>();
        LineNumberInfo previousInfo = new LineNumberInfo(0, 0);
        for (int index = 0; index < lineNumberTableLength; ++index) {
            LineNumberInfo info = lineNumberTable[index];
            String previousSource = previousInfo.getSource();
            String source = info.getSource();
            if (source != null && source != previousSource) {
                int lineNumber = info.u2lineNumber;
                int previousLineNumber = previousInfo.u2lineNumber;
                if (lineNumber > previousLineNumber) {
                    if (index > 0) {
                        enclosingLineNumbers.push(previousInfo);
                    }
                    this.printInlinedMethodMapping(clazz.getName(), methodName, methodDescriptor, info, enclosingLineNumbers, obfuscatedMethodName);
                } else if (!enclosingLineNumbers.isEmpty()) {
                    enclosingLineNumbers.pop();
                }
            } else if (source == null && previousSource != null && !enclosingLineNumbers.isEmpty()) {
                enclosingLineNumbers.pop();
            }
            previousInfo = info;
        }
        this.printed = true;
    }

    private void printInlinedMethodMapping(String className, String methodName, String methodDescriptor, LineNumberInfo inlinedInfo, Stack enclosingLineNumbers, String obfuscatedMethodName) {
        String source = inlinedInfo.getSource();
        int separatorIndex1 = source.indexOf(46);
        int separatorIndex2 = source.indexOf(40, separatorIndex1 + 1);
        int separatorIndex3 = source.indexOf(58, separatorIndex2 + 1);
        int separatorIndex4 = source.indexOf(58, separatorIndex3 + 1);
        String inlinedClassName = source.substring(0, separatorIndex1);
        String inlinedMethodName = source.substring(separatorIndex1 + 1, separatorIndex2);
        String inlinedMethodDescriptor = source.substring(separatorIndex2, separatorIndex3);
        String inlinedRange = source.substring(separatorIndex3);
        int startLineNumber = Integer.parseInt(source.substring(separatorIndex3 + 1, separatorIndex4));
        int endLineNumber = Integer.parseInt(source.substring(separatorIndex4 + 1));
        int shiftedStartLineNumber = inlinedInfo.u2lineNumber;
        int shiftedEndLineNumber = shiftedStartLineNumber + endLineNumber - startLineNumber;
        this.pw.println("    " + shiftedStartLineNumber + ":" + shiftedEndLineNumber + ":" + ClassUtil.externalMethodReturnType(inlinedMethodDescriptor) + " " + (inlinedClassName.equals(className) ? "" : ClassUtil.externalClassName(inlinedClassName) + '.') + inlinedMethodName + '(' + ClassUtil.externalMethodArguments(inlinedMethodDescriptor) + ')' + inlinedRange + " -> " + obfuscatedMethodName);
        for (int enclosingIndex = enclosingLineNumbers.size() - 1; enclosingIndex >= 0; --enclosingIndex) {
            LineNumberInfo enclosingInfo = (LineNumberInfo)enclosingLineNumbers.get(enclosingIndex);
            this.printEnclosingMethodMapping(className, methodName, methodDescriptor, shiftedStartLineNumber + ":" + shiftedEndLineNumber, enclosingInfo, obfuscatedMethodName);
        }
    }

    private void printEnclosingMethodMapping(String className, String methodName, String methodDescriptor, String shiftedRange, LineNumberInfo enclosingInfo, String obfuscatedMethodName) {
        int enclosingLineNumber;
        String enclosingMethodDescriptor;
        String enclosingMethodName;
        String enclosingClassName;
        String enclosingSource = enclosingInfo.getSource();
        if (enclosingSource == null) {
            enclosingClassName = className;
            enclosingMethodName = methodName;
            enclosingMethodDescriptor = methodDescriptor;
            enclosingLineNumber = enclosingInfo.u2lineNumber;
        } else {
            int enclosingSeparatorIndex1 = enclosingSource.indexOf(46);
            int enclosingSeparatorIndex2 = enclosingSource.indexOf(40, enclosingSeparatorIndex1 + 1);
            int enclosingSeparatorIndex3 = enclosingSource.indexOf(58, enclosingSeparatorIndex2 + 1);
            int enclosingSeparatorIndex4 = enclosingSource.indexOf(58, enclosingSeparatorIndex3 + 1);
            int firstLineNumber = Integer.parseInt(enclosingSource.substring(enclosingSeparatorIndex3 + 1, enclosingSeparatorIndex4));
            enclosingClassName = enclosingSource.substring(0, enclosingSeparatorIndex1);
            enclosingMethodName = enclosingSource.substring(enclosingSeparatorIndex1 + 1, enclosingSeparatorIndex2);
            enclosingMethodDescriptor = enclosingSource.substring(enclosingSeparatorIndex2, enclosingSeparatorIndex3);
            enclosingLineNumber = (enclosingInfo.u2lineNumber - firstLineNumber) % 1000 + firstLineNumber;
        }
        this.pw.println("    " + shiftedRange + ":" + ClassUtil.externalMethodReturnType(enclosingMethodDescriptor) + " " + (enclosingClassName.equals(className) ? "" : ClassUtil.externalClassName(enclosingClassName) + '.') + enclosingMethodName + '(' + ClassUtil.externalMethodArguments(enclosingMethodDescriptor) + ')' + ":" + enclosingLineNumber + " -> " + obfuscatedMethodName);
    }
}

