/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataInput;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDebugExtensionAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypePathInfo;
import proguard.classfile.attribute.annotation.target.CatchTargetInfo;
import proguard.classfile.attribute.annotation.target.EmptyTargetInfo;
import proguard.classfile.attribute.annotation.target.FormalParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.SuperTypeTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.ThrowsTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeArgumentTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterBoundTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.TypePathInfoVisitor;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.DoubleType;
import proguard.classfile.attribute.preverification.FloatType;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.IntegerType;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.LongType;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.NullType;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.TopType;
import proguard.classfile.attribute.preverification.UninitializedThisType;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.io.RuntimeDataInput;

public class ProgramClassReader
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
ParameterInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
RequiresInfoVisitor,
ExportsInfoVisitor,
OpensInfoVisitor,
ProvidesInfoVisitor,
AnnotationVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
TypePathInfoVisitor,
LocalVariableTargetElementVisitor,
ElementValueVisitor {
    private final RuntimeDataInput dataInput;
    private final boolean ignoreStackMapAttributes;

    public ProgramClassReader(DataInput dataInput) {
        this(dataInput, false);
    }

    public ProgramClassReader(DataInput dataInput, boolean ignoreStackMapAttributes) {
        this.dataInput = new RuntimeDataInput(dataInput);
        this.ignoreStackMapAttributes = ignoreStackMapAttributes;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int index;
        int u4magic = this.dataInput.readInt();
        ClassUtil.checkMagicNumber(u4magic);
        int u2minorVersion = this.dataInput.readUnsignedShort();
        int u2majorVersion = this.dataInput.readUnsignedShort();
        programClass.u4version = ClassUtil.internalClassVersion(u2majorVersion, u2minorVersion);
        ClassUtil.checkVersionNumbers(programClass.u4version);
        programClass.u2constantPoolCount = this.dataInput.readUnsignedShort();
        programClass.constantPool = new Constant[programClass.u2constantPoolCount];
        for (index = 1; index < programClass.u2constantPoolCount; ++index) {
            Constant constant = this.createConstant();
            constant.accept(programClass, this);
            programClass.constantPool[index] = constant;
            int tag = constant.getTag();
            if (tag != 5 && tag != 6) continue;
            programClass.constantPool[++index] = null;
        }
        programClass.u2accessFlags = this.dataInput.readUnsignedShort();
        programClass.u2thisClass = this.dataInput.readUnsignedShort();
        programClass.u2superClass = this.dataInput.readUnsignedShort();
        programClass.u2interfacesCount = this.dataInput.readUnsignedShort();
        programClass.u2interfaces = this.readUnsignedShorts(programClass.u2interfacesCount);
        programClass.u2fieldsCount = this.dataInput.readUnsignedShort();
        programClass.fields = new ProgramField[programClass.u2fieldsCount];
        for (index = 0; index < programClass.u2fieldsCount; ++index) {
            ProgramField programField = new ProgramField();
            this.visitProgramField(programClass, programField);
            programClass.fields[index] = programField;
        }
        programClass.u2methodsCount = this.dataInput.readUnsignedShort();
        programClass.methods = new ProgramMethod[programClass.u2methodsCount];
        for (index = 0; index < programClass.u2methodsCount; ++index) {
            ProgramMethod programMethod = new ProgramMethod();
            this.visitProgramMethod(programClass, programMethod);
            programClass.methods[index] = programMethod;
        }
        programClass.u2attributesCount = this.dataInput.readUnsignedShort();
        programClass.attributes = new Attribute[programClass.u2attributesCount];
        for (index = 0; index < programClass.u2attributesCount; ++index) {
            Attribute attribute = this.createAttribute(programClass);
            attribute.accept(programClass, this);
            programClass.attributes[index] = attribute;
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.u2accessFlags = this.dataInput.readUnsignedShort();
        programField.u2nameIndex = this.dataInput.readUnsignedShort();
        programField.u2descriptorIndex = this.dataInput.readUnsignedShort();
        programField.u2attributesCount = this.dataInput.readUnsignedShort();
        programField.attributes = new Attribute[programField.u2attributesCount];
        for (int index = 0; index < programField.u2attributesCount; ++index) {
            Attribute attribute = this.createAttribute(programClass);
            attribute.accept((Clazz)programClass, programField, (AttributeVisitor)this);
            programField.attributes[index] = attribute;
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.u2accessFlags = this.dataInput.readUnsignedShort();
        programMethod.u2nameIndex = this.dataInput.readUnsignedShort();
        programMethod.u2descriptorIndex = this.dataInput.readUnsignedShort();
        programMethod.u2attributesCount = this.dataInput.readUnsignedShort();
        programMethod.attributes = new Attribute[programMethod.u2attributesCount];
        for (int index = 0; index < programMethod.u2attributesCount; ++index) {
            Attribute attribute = this.createAttribute(programClass);
            attribute.accept((Clazz)programClass, programMethod, (AttributeVisitor)this);
            programMethod.attributes[index] = attribute;
        }
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        integerConstant.u4value = this.dataInput.readInt();
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        longConstant.u8value = this.dataInput.readLong();
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        floatConstant.f4value = this.dataInput.readFloat();
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        doubleConstant.f8value = this.dataInput.readDouble();
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char u2primitiveType = this.dataInput.readChar();
        int u4length = this.dataInput.readInt();
        switch (u2primitiveType) {
            case 'Z': {
                boolean[] values2 = new boolean[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values2[index] = this.dataInput.readBoolean();
                }
                primitiveArrayConstant.values = values2;
                break;
            }
            case 'B': {
                byte[] values3 = new byte[u4length];
                this.dataInput.readFully(values3);
                primitiveArrayConstant.values = values3;
                break;
            }
            case 'C': {
                char[] values4 = new char[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values4[index] = this.dataInput.readChar();
                }
                primitiveArrayConstant.values = values4;
                break;
            }
            case 'S': {
                short[] values5 = new short[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values5[index] = this.dataInput.readShort();
                }
                primitiveArrayConstant.values = values5;
                break;
            }
            case 'I': {
                int[] values6 = new int[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values6[index] = this.dataInput.readInt();
                }
                primitiveArrayConstant.values = values6;
                break;
            }
            case 'F': {
                float[] values7 = new float[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values7[index] = this.dataInput.readFloat();
                }
                primitiveArrayConstant.values = values7;
                break;
            }
            case 'J': {
                long[] values8 = new long[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values8[index] = this.dataInput.readLong();
                }
                primitiveArrayConstant.values = values8;
                break;
            }
            case 'D': {
                double[] values9 = new double[u4length];
                for (int index = 0; index < u4length; ++index) {
                    values9[index] = this.dataInput.readDouble();
                }
                primitiveArrayConstant.values = values9;
                break;
            }
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.u2stringIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        int u2length = this.dataInput.readUnsignedShort();
        byte[] bytes = new byte[u2length];
        this.dataInput.readFully(bytes);
        utf8Constant.setBytes(bytes);
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        dynamicConstant.u2bootstrapMethodAttributeIndex = this.dataInput.readUnsignedShort();
        dynamicConstant.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.u2bootstrapMethodAttributeIndex = this.dataInput.readUnsignedShort();
        invokeDynamicConstant.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.u1referenceKind = this.dataInput.readUnsignedByte();
        methodHandleConstant.u2referenceIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        moduleConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        packageConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.u2classIndex = this.dataInput.readUnsignedShort();
        refConstant.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.u2descriptorIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        nameAndTypeConstant.u2nameIndex = this.dataInput.readUnsignedShort();
        nameAndTypeConstant.u2descriptorIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        byte[] info = new byte[unknownAttribute.u4attributeLength];
        this.dataInput.readFully(info);
        unknownAttribute.info = info;
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.u2bootstrapMethodsCount = this.dataInput.readUnsignedShort();
        bootstrapMethodsAttribute.bootstrapMethods = new BootstrapMethodInfo[bootstrapMethodsAttribute.u2bootstrapMethodsCount];
        for (int index = 0; index < bootstrapMethodsAttribute.u2bootstrapMethodsCount; ++index) {
            BootstrapMethodInfo bootstrapMethodInfo = new BootstrapMethodInfo();
            this.visitBootstrapMethodInfo(clazz, bootstrapMethodInfo);
            bootstrapMethodsAttribute.bootstrapMethods[index] = bootstrapMethodInfo;
        }
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        sourceFileAttribute.u2sourceFileIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        sourceDirAttribute.u2sourceDirIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitSourceDebugExtensionAttribute(Clazz clazz, SourceDebugExtensionAttribute sourceDebugExtensionAttribute) {
        byte[] info = new byte[sourceDebugExtensionAttribute.u4attributeLength];
        this.dataInput.readFully(info);
        sourceDebugExtensionAttribute.info = info;
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.dataInput.readUnsignedShort();
        innerClassesAttribute.classes = new InnerClassesInfo[innerClassesAttribute.u2classesCount];
        for (int index = 0; index < innerClassesAttribute.u2classesCount; ++index) {
            InnerClassesInfo innerClassesInfo = new InnerClassesInfo();
            this.visitInnerClassesInfo(clazz, innerClassesInfo);
            innerClassesAttribute.classes[index] = innerClassesInfo;
        }
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.u2classIndex = this.dataInput.readUnsignedShort();
        enclosingMethodAttribute.u2nameAndTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        nestHostAttribute.u2hostClassIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        nestMembersAttribute.u2classesCount = this.dataInput.readUnsignedShort();
        nestMembersAttribute.u2classes = this.readUnsignedShorts(nestMembersAttribute.u2classesCount);
    }

    @Override
    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        int index;
        moduleAttribute.u2moduleNameIndex = this.dataInput.readUnsignedShort();
        moduleAttribute.u2moduleFlags = this.dataInput.readUnsignedShort();
        moduleAttribute.u2moduleVersionIndex = this.dataInput.readUnsignedShort();
        moduleAttribute.u2requiresCount = this.dataInput.readUnsignedShort();
        moduleAttribute.requires = new RequiresInfo[moduleAttribute.u2requiresCount];
        for (index = 0; index < moduleAttribute.u2requiresCount; ++index) {
            RequiresInfo requiresInfo = new RequiresInfo();
            this.visitRequiresInfo(clazz, requiresInfo);
            moduleAttribute.requires[index] = requiresInfo;
        }
        moduleAttribute.u2exportsCount = this.dataInput.readUnsignedShort();
        moduleAttribute.exports = new ExportsInfo[moduleAttribute.u2exportsCount];
        for (index = 0; index < moduleAttribute.u2exportsCount; ++index) {
            ExportsInfo exportsInfo = new ExportsInfo();
            this.visitExportsInfo(clazz, exportsInfo);
            moduleAttribute.exports[index] = exportsInfo;
        }
        moduleAttribute.u2opensCount = this.dataInput.readUnsignedShort();
        moduleAttribute.opens = new OpensInfo[moduleAttribute.u2opensCount];
        for (index = 0; index < moduleAttribute.u2opensCount; ++index) {
            OpensInfo opensInfo = new OpensInfo();
            this.visitOpensInfo(clazz, opensInfo);
            moduleAttribute.opens[index] = opensInfo;
        }
        moduleAttribute.u2usesCount = this.dataInput.readUnsignedShort();
        moduleAttribute.u2uses = this.readUnsignedShorts(moduleAttribute.u2usesCount);
        moduleAttribute.u2providesCount = this.dataInput.readUnsignedShort();
        moduleAttribute.provides = new ProvidesInfo[moduleAttribute.u2providesCount];
        for (index = 0; index < moduleAttribute.u2providesCount; ++index) {
            ProvidesInfo providesInfo = new ProvidesInfo();
            this.visitProvidesInfo(clazz, providesInfo);
            moduleAttribute.provides[index] = providesInfo;
        }
    }

    @Override
    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        moduleMainClassAttribute.u2mainClass = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        modulePackagesAttribute.u2packagesCount = this.dataInput.readUnsignedShort();
        modulePackagesAttribute.u2packages = this.readUnsignedShorts(modulePackagesAttribute.u2packagesCount);
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.u2signatureIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        constantValueAttribute.u2constantValueIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        methodParametersAttribute.u1parametersCount = this.dataInput.readUnsignedByte();
        methodParametersAttribute.parameters = new ParameterInfo[methodParametersAttribute.u1parametersCount];
        for (int index = 0; index < methodParametersAttribute.u1parametersCount; ++index) {
            ParameterInfo parameterInfo = new ParameterInfo();
            this.visitParameterInfo(clazz, method, index, parameterInfo);
            methodParametersAttribute.parameters[index] = parameterInfo;
        }
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        exceptionsAttribute.u2exceptionIndexTableLength = this.dataInput.readUnsignedShort();
        exceptionsAttribute.u2exceptionIndexTable = this.readUnsignedShorts(exceptionsAttribute.u2exceptionIndexTableLength);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int index;
        codeAttribute.u2maxStack = this.dataInput.readUnsignedShort();
        codeAttribute.u2maxLocals = this.dataInput.readUnsignedShort();
        codeAttribute.u4codeLength = this.dataInput.readInt();
        byte[] code = new byte[codeAttribute.u4codeLength];
        this.dataInput.readFully(code);
        codeAttribute.code = code;
        codeAttribute.u2exceptionTableLength = this.dataInput.readUnsignedShort();
        codeAttribute.exceptionTable = new ExceptionInfo[codeAttribute.u2exceptionTableLength];
        for (index = 0; index < codeAttribute.u2exceptionTableLength; ++index) {
            ExceptionInfo exceptionInfo = new ExceptionInfo();
            this.visitExceptionInfo(clazz, method, codeAttribute, exceptionInfo);
            codeAttribute.exceptionTable[index] = exceptionInfo;
        }
        codeAttribute.u2attributesCount = this.dataInput.readUnsignedShort();
        codeAttribute.attributes = new Attribute[codeAttribute.u2attributesCount];
        for (index = 0; index < codeAttribute.u2attributesCount; ++index) {
            Attribute attribute = this.createAttribute(clazz);
            attribute.accept(clazz, method, codeAttribute, this);
            codeAttribute.attributes[index] = attribute;
        }
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        stackMapAttribute.u2stackMapFramesCount = this.dataInput.readUnsignedShort();
        stackMapAttribute.stackMapFrames = new FullFrame[stackMapAttribute.u2stackMapFramesCount];
        for (int index = 0; index < stackMapAttribute.u2stackMapFramesCount; ++index) {
            FullFrame stackMapFrame = new FullFrame();
            this.visitFullFrame(clazz, method, codeAttribute, index, stackMapFrame);
            stackMapAttribute.stackMapFrames[index] = stackMapFrame;
        }
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        stackMapTableAttribute.u2stackMapFramesCount = this.dataInput.readUnsignedShort();
        stackMapTableAttribute.stackMapFrames = new StackMapFrame[stackMapTableAttribute.u2stackMapFramesCount];
        for (int index = 0; index < stackMapTableAttribute.u2stackMapFramesCount; ++index) {
            StackMapFrame stackMapFrame = this.createStackMapFrame();
            stackMapFrame.accept(clazz, method, codeAttribute, 0, this);
            stackMapTableAttribute.stackMapFrames[index] = stackMapFrame;
        }
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.u2lineNumberTableLength = this.dataInput.readUnsignedShort();
        lineNumberTableAttribute.lineNumberTable = new LineNumberInfo[lineNumberTableAttribute.u2lineNumberTableLength];
        for (int index = 0; index < lineNumberTableAttribute.u2lineNumberTableLength; ++index) {
            LineNumberInfo lineNumberInfo = new LineNumberInfo();
            this.visitLineNumberInfo(clazz, method, codeAttribute, lineNumberInfo);
            lineNumberTableAttribute.lineNumberTable[index] = lineNumberInfo;
        }
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.dataInput.readUnsignedShort();
        localVariableTableAttribute.localVariableTable = new LocalVariableInfo[localVariableTableAttribute.u2localVariableTableLength];
        for (int index = 0; index < localVariableTableAttribute.u2localVariableTableLength; ++index) {
            LocalVariableInfo localVariableInfo = new LocalVariableInfo();
            this.visitLocalVariableInfo(clazz, method, codeAttribute, localVariableInfo);
            localVariableTableAttribute.localVariableTable[index] = localVariableInfo;
        }
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.dataInput.readUnsignedShort();
        localVariableTypeTableAttribute.localVariableTypeTable = new LocalVariableTypeInfo[localVariableTypeTableAttribute.u2localVariableTypeTableLength];
        for (int index = 0; index < localVariableTypeTableAttribute.u2localVariableTypeTableLength; ++index) {
            LocalVariableTypeInfo localVariableTypeInfo = new LocalVariableTypeInfo();
            this.visitLocalVariableTypeInfo(clazz, method, codeAttribute, localVariableTypeInfo);
            localVariableTypeTableAttribute.localVariableTypeTable[index] = localVariableTypeInfo;
        }
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.dataInput.readUnsignedShort();
        annotationsAttribute.annotations = new Annotation[annotationsAttribute.u2annotationsCount];
        for (int index = 0; index < annotationsAttribute.u2annotationsCount; ++index) {
            Annotation annotation = new Annotation();
            this.visitAnnotation(clazz, annotation);
            annotationsAttribute.annotations[index] = annotation;
        }
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.u1parametersCount = this.dataInput.readUnsignedByte();
        parameterAnnotationsAttribute.u2parameterAnnotationsCount = new int[parameterAnnotationsAttribute.u1parametersCount];
        parameterAnnotationsAttribute.parameterAnnotations = new Annotation[parameterAnnotationsAttribute.u1parametersCount][];
        for (int parameterIndex = 0; parameterIndex < parameterAnnotationsAttribute.u1parametersCount; ++parameterIndex) {
            int u2annotationsCount = this.dataInput.readUnsignedShort();
            Annotation[] annotations = new Annotation[u2annotationsCount];
            for (int index = 0; index < u2annotationsCount; ++index) {
                Annotation annotation = new Annotation();
                this.visitAnnotation(clazz, annotation);
                annotations[index] = annotation;
            }
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[parameterIndex] = u2annotationsCount;
            parameterAnnotationsAttribute.parameterAnnotations[parameterIndex] = annotations;
        }
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.u2annotationsCount = this.dataInput.readUnsignedShort();
        typeAnnotationsAttribute.annotations = new TypeAnnotation[typeAnnotationsAttribute.u2annotationsCount];
        for (int index = 0; index < typeAnnotationsAttribute.u2annotationsCount; ++index) {
            TypeAnnotation typeAnnotation = new TypeAnnotation();
            this.visitTypeAnnotation(clazz, typeAnnotation);
            typeAnnotationsAttribute.annotations[index] = typeAnnotation;
        }
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        ElementValue elementValue = this.createElementValue();
        elementValue.accept(clazz, null, this);
        annotationDefaultAttribute.defaultValue = elementValue;
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        bootstrapMethodInfo.u2methodHandleIndex = this.dataInput.readUnsignedShort();
        bootstrapMethodInfo.u2methodArgumentCount = this.dataInput.readUnsignedShort();
        bootstrapMethodInfo.u2methodArguments = this.readUnsignedShorts(bootstrapMethodInfo.u2methodArgumentCount);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.u2innerClassIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2outerClassIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2innerNameIndex = this.dataInput.readUnsignedShort();
        innerClassesInfo.u2innerClassAccessFlags = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2endPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2handlerPC = this.dataInput.readUnsignedShort();
        exceptionInfo.u2catchType = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameZeroFrame sameZeroFrame) {
        if (sameZeroFrame.getTag() == 251) {
            sameZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        }
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        if (sameOneFrame.getTag() == 247) {
            sameOneFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        }
        VerificationType verificationType = this.createVerificationType();
        verificationType.accept(clazz, method, codeAttribute, offset, this);
        sameOneFrame.stackItem = verificationType;
    }

    @Override
    public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LessZeroFrame lessZeroFrame) {
        lessZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        moreZeroFrame.additionalVariables = new VerificationType[moreZeroFrame.additionalVariablesCount];
        for (int index = 0; index < moreZeroFrame.additionalVariablesCount; ++index) {
            VerificationType verificationType = this.createVerificationType();
            verificationType.accept(clazz, method, codeAttribute, offset, this);
            moreZeroFrame.additionalVariables[index] = verificationType;
        }
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        VerificationType verificationType;
        int index;
        fullFrame.u2offsetDelta = this.dataInput.readUnsignedShort();
        fullFrame.variablesCount = this.dataInput.readUnsignedShort();
        fullFrame.variables = new VerificationType[fullFrame.variablesCount];
        for (index = 0; index < fullFrame.variablesCount; ++index) {
            verificationType = this.createVerificationType();
            verificationType.variablesAccept(clazz, method, codeAttribute, offset, index, this);
            fullFrame.variables[index] = verificationType;
        }
        fullFrame.stackCount = this.dataInput.readUnsignedShort();
        fullFrame.stack = new VerificationType[fullFrame.stackCount];
        for (index = 0; index < fullFrame.stackCount; ++index) {
            verificationType = this.createVerificationType();
            verificationType.stackAccept(clazz, method, codeAttribute, offset, index, this);
            fullFrame.stack[index] = verificationType;
        }
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    @Override
    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ObjectType objectType) {
        objectType.u2classIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.dataInput.readUnsignedShort();
        lineNumberInfo.u2lineNumber = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitParameterInfo(Clazz clazz, Method method, int parameterIndex, ParameterInfo parameterInfo) {
        parameterInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        parameterInfo.u2accessFlags = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2startPC = this.dataInput.readUnsignedShort();
        localVariableInfo.u2length = this.dataInput.readUnsignedShort();
        localVariableInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        localVariableInfo.u2descriptorIndex = this.dataInput.readUnsignedShort();
        localVariableInfo.u2index = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2startPC = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2length = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2nameIndex = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2signatureIndex = this.dataInput.readUnsignedShort();
        localVariableTypeInfo.u2index = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
        requiresInfo.u2requiresIndex = this.dataInput.readUnsignedShort();
        requiresInfo.u2requiresFlags = this.dataInput.readUnsignedShort();
        requiresInfo.u2requiresVersionIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
        exportsInfo.u2exportsIndex = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsFlags = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsToCount = this.dataInput.readUnsignedShort();
        exportsInfo.u2exportsToIndex = this.readUnsignedShorts(exportsInfo.u2exportsToCount);
    }

    @Override
    public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
        opensInfo.u2opensIndex = this.dataInput.readUnsignedShort();
        opensInfo.u2opensFlags = this.dataInput.readUnsignedShort();
        opensInfo.u2opensToCount = this.dataInput.readUnsignedShort();
        opensInfo.u2opensToIndex = this.readUnsignedShorts(opensInfo.u2opensToCount);
    }

    @Override
    public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
        providesInfo.u2providesIndex = this.dataInput.readUnsignedShort();
        providesInfo.u2providesWithCount = this.dataInput.readUnsignedShort();
        providesInfo.u2providesWithIndex = this.readUnsignedShorts(providesInfo.u2providesWithCount);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2typeIndex = this.dataInput.readUnsignedShort();
        annotation.u2elementValuesCount = this.dataInput.readUnsignedShort();
        annotation.elementValues = new ElementValue[annotation.u2elementValuesCount];
        for (int index = 0; index < annotation.u2elementValuesCount; ++index) {
            int u2elementNameIndex = this.dataInput.readUnsignedShort();
            ElementValue elementValue = this.createElementValue();
            elementValue.u2elementNameIndex = u2elementNameIndex;
            elementValue.accept(clazz, annotation, this);
            annotation.elementValues[index] = elementValue;
        }
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        TargetInfo targetInfo = this.createTargetInfo();
        targetInfo.accept(clazz, typeAnnotation, this);
        typeAnnotation.targetInfo = targetInfo;
        int u1pathLength = this.dataInput.readUnsignedByte();
        typeAnnotation.typePath = new TypePathInfo[u1pathLength];
        for (int index = 0; index < u1pathLength; ++index) {
            TypePathInfo typePathInfo = new TypePathInfo();
            this.visitTypePathInfo(clazz, typeAnnotation, typePathInfo);
            typeAnnotation.typePath[index] = typePathInfo;
        }
        this.visitAnnotation(clazz, typeAnnotation);
    }

    @Override
    public void visitTypeParameterTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterTargetInfo typeParameterTargetInfo) {
        typeParameterTargetInfo.u1typeParameterIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitSuperTypeTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, SuperTypeTargetInfo superTypeTargetInfo) {
        superTypeTargetInfo.u2superTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitTypeParameterBoundTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterBoundTargetInfo typeParameterBoundTargetInfo) {
        typeParameterBoundTargetInfo.u1typeParameterIndex = this.dataInput.readUnsignedByte();
        typeParameterBoundTargetInfo.u1boundIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitEmptyTargetInfo(Clazz clazz, Member member, TypeAnnotation typeAnnotation, EmptyTargetInfo emptyTargetInfo) {
    }

    @Override
    public void visitFormalParameterTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, FormalParameterTargetInfo formalParameterTargetInfo) {
        formalParameterTargetInfo.u1formalParameterIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitThrowsTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, ThrowsTargetInfo throwsTargetInfo) {
        throwsTargetInfo.u2throwsTypeIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.u2tableLength = this.dataInput.readUnsignedShort();
        localVariableTargetInfo.table = new LocalVariableTargetElement[localVariableTargetInfo.u2tableLength];
        for (int index = 0; index < localVariableTargetInfo.u2tableLength; ++index) {
            LocalVariableTargetElement element = new LocalVariableTargetElement();
            this.visitLocalVariableTargetElement(clazz, method, codeAttribute, typeAnnotation, localVariableTargetInfo, element);
            localVariableTargetInfo.table[index] = element;
        }
    }

    @Override
    public void visitCatchTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, CatchTargetInfo catchTargetInfo) {
        catchTargetInfo.u2exceptionTableIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
        offsetTargetInfo.u2offset = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitTypeArgumentTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, TypeArgumentTargetInfo typeArgumentTargetInfo) {
        typeArgumentTargetInfo.u2offset = this.dataInput.readUnsignedShort();
        typeArgumentTargetInfo.u1typeArgumentIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitTypePathInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypePathInfo typePathInfo) {
        typePathInfo.u1typePathKind = this.dataInput.readUnsignedByte();
        typePathInfo.u1typeArgumentIndex = this.dataInput.readUnsignedByte();
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        localVariableTargetElement.u2startPC = this.dataInput.readShort();
        localVariableTargetElement.u2length = this.dataInput.readShort();
        localVariableTargetElement.u2index = this.dataInput.readShort();
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        constantElementValue.u2constantValueIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2typeNameIndex = this.dataInput.readUnsignedShort();
        enumConstantElementValue.u2constantNameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        classElementValue.u2classInfoIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        Annotation annotationValue = new Annotation();
        this.visitAnnotation(clazz, annotationValue);
        annotationElementValue.annotationValue = annotationValue;
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.dataInput.readUnsignedShort();
        arrayElementValue.elementValues = new ElementValue[arrayElementValue.u2elementValuesCount];
        for (int index = 0; index < arrayElementValue.u2elementValuesCount; ++index) {
            ElementValue elementValue = this.createElementValue();
            elementValue.accept(clazz, annotation, this);
            arrayElementValue.elementValues[index] = elementValue;
        }
    }

    private Constant createConstant() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 3: {
                return new IntegerConstant();
            }
            case 4: {
                return new FloatConstant();
            }
            case 5: {
                return new LongConstant();
            }
            case 6: {
                return new DoubleConstant();
            }
            case 99: {
                return new PrimitiveArrayConstant();
            }
            case 8: {
                return new StringConstant();
            }
            case 1: {
                return new Utf8Constant();
            }
            case 17: {
                return new DynamicConstant();
            }
            case 18: {
                return new InvokeDynamicConstant();
            }
            case 15: {
                return new MethodHandleConstant();
            }
            case 9: {
                return new FieldrefConstant();
            }
            case 10: {
                return new MethodrefConstant();
            }
            case 11: {
                return new InterfaceMethodrefConstant();
            }
            case 7: {
                return new ClassConstant();
            }
            case 16: {
                return new MethodTypeConstant();
            }
            case 12: {
                return new NameAndTypeConstant();
            }
            case 19: {
                return new ModuleConstant();
            }
            case 20: {
                return new PackageConstant();
            }
        }
        throw new RuntimeException("Unknown constant type [" + u1tag + "] in constant pool");
    }

    private Attribute createAttribute(Clazz clazz) {
        int u2attributeNameIndex = this.dataInput.readUnsignedShort();
        int u4attributeLength = this.dataInput.readInt();
        String attributeName = clazz.getString(u2attributeNameIndex);
        BootstrapMethodsAttribute attribute = attributeName.equals("BootstrapMethods") ? new BootstrapMethodsAttribute() : (attributeName.equals("SourceFile") ? new SourceFileAttribute() : (attributeName.equals("SourceDir") ? new SourceDirAttribute() : (attributeName.equals("SourceDebugExtension") ? new SourceDebugExtensionAttribute(0, u4attributeLength, null) : (attributeName.equals("InnerClasses") ? new InnerClassesAttribute() : (attributeName.equals("EnclosingMethod") ? new EnclosingMethodAttribute() : (attributeName.equals("NestHost") ? new NestHostAttribute() : (attributeName.equals("NestMembers") ? new NestMembersAttribute() : (attributeName.equals("Deprecated") ? new DeprecatedAttribute() : (attributeName.equals("Synthetic") ? new SyntheticAttribute() : (attributeName.equals("Signature") ? new SignatureAttribute() : (attributeName.equals("ConstantValue") ? new ConstantValueAttribute() : (attributeName.equals("MethodParameters") ? new MethodParametersAttribute() : (attributeName.equals("Exceptions") ? new ExceptionsAttribute() : (attributeName.equals("Code") ? new CodeAttribute() : (attributeName.equals("StackMap") && !this.ignoreStackMapAttributes ? new StackMapAttribute() : (attributeName.equals("StackMapTable") && !this.ignoreStackMapAttributes ? new StackMapTableAttribute() : (attributeName.equals("LineNumberTable") ? new LineNumberTableAttribute() : (attributeName.equals("LocalVariableTable") ? new LocalVariableTableAttribute() : (attributeName.equals("LocalVariableTypeTable") ? new LocalVariableTypeTableAttribute() : (attributeName.equals("RuntimeVisibleAnnotations") ? new RuntimeVisibleAnnotationsAttribute() : (attributeName.equals("RuntimeInvisibleAnnotations") ? new RuntimeInvisibleAnnotationsAttribute() : (attributeName.equals("RuntimeVisibleParameterAnnotations") ? new RuntimeVisibleParameterAnnotationsAttribute() : (attributeName.equals("RuntimeInvisibleParameterAnnotations") ? new RuntimeInvisibleParameterAnnotationsAttribute() : (attributeName.equals("RuntimeVisibleTypeAnnotations") ? new RuntimeVisibleTypeAnnotationsAttribute() : (attributeName.equals("RuntimeInvisibleTypeAnnotations") ? new RuntimeInvisibleTypeAnnotationsAttribute() : (attributeName.equals("AnnotationDefault") ? new AnnotationDefaultAttribute() : (attributeName.equals("Module") ? new ModuleAttribute() : (attributeName.equals("ModuleMainClass") ? new ModuleMainClassAttribute() : (attributeName.equals("ModulePackages") ? new ModulePackagesAttribute() : new UnknownAttribute(u2attributeNameIndex, u4attributeLength))))))))))))))))))))))))))))));
        attribute.u2attributeNameIndex = u2attributeNameIndex;
        return attribute;
    }

    private StackMapFrame createStackMapFrame() {
        int u1tag = this.dataInput.readUnsignedByte();
        return u1tag < 64 ? new SameZeroFrame(u1tag) : (u1tag < 247 ? new SameOneFrame(u1tag) : (u1tag < 248 ? new SameOneFrame(u1tag) : (u1tag < 251 ? new LessZeroFrame(u1tag) : (u1tag < 252 ? new SameZeroFrame(u1tag) : (u1tag < 255 ? new MoreZeroFrame(u1tag) : new FullFrame())))));
    }

    private VerificationType createVerificationType() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 1: {
                return new IntegerType();
            }
            case 2: {
                return new FloatType();
            }
            case 4: {
                return new LongType();
            }
            case 3: {
                return new DoubleType();
            }
            case 0: {
                return new TopType();
            }
            case 7: {
                return new ObjectType();
            }
            case 5: {
                return new NullType();
            }
            case 8: {
                return new UninitializedType();
            }
            case 6: {
                return new UninitializedThisType();
            }
        }
        throw new RuntimeException("Unknown verification type [" + u1tag + "] in stack map frame");
    }

    private TargetInfo createTargetInfo() {
        byte u1targetType = this.dataInput.readByte();
        switch (u1targetType) {
            case 0: 
            case 1: {
                return new TypeParameterTargetInfo(u1targetType);
            }
            case 16: {
                return new SuperTypeTargetInfo(u1targetType);
            }
            case 17: 
            case 18: {
                return new TypeParameterBoundTargetInfo(u1targetType);
            }
            case 19: 
            case 20: 
            case 21: {
                return new EmptyTargetInfo(u1targetType);
            }
            case 22: {
                return new FormalParameterTargetInfo(u1targetType);
            }
            case 23: {
                return new ThrowsTargetInfo(u1targetType);
            }
            case 64: 
            case 65: {
                return new LocalVariableTargetInfo(u1targetType);
            }
            case 66: {
                return new CatchTargetInfo(u1targetType);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return new OffsetTargetInfo(u1targetType);
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return new TypeArgumentTargetInfo(u1targetType);
            }
        }
        throw new RuntimeException("Unknown annotation target type [" + u1targetType + "]");
    }

    private ElementValue createElementValue() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new ConstantElementValue((char)u1tag);
            }
            case 101: {
                return new EnumConstantElementValue();
            }
            case 99: {
                return new ClassElementValue();
            }
            case 64: {
                return new AnnotationElementValue();
            }
            case 91: {
                return new ArrayElementValue();
            }
        }
        throw new IllegalArgumentException("Unknown element value tag [" + u1tag + "]");
    }

    private int[] readUnsignedShorts(int size) {
        int[] values2 = new int[size];
        for (int index = 0; index < size; ++index) {
            values2[index] = this.dataInput.readUnsignedShort();
        }
        return values2;
    }
}

