/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.AndStringFunction;
import proguard.util.ConstantStringFunction;
import proguard.util.MatchingStringFunction;
import proguard.util.NameParser;
import proguard.util.StringFunction;
import proguard.util.StringFunctionParser;
import proguard.util.StringParser;
import proguard.util.WildcardManager;

public class SingleFunctionParser
implements StringFunctionParser {
    private final StringParser stringParser;
    private final WildcardManager wildcardManager;

    public SingleFunctionParser(StringParser stringParser, WildcardManager wildcardManager) {
        this.stringParser = stringParser;
        this.wildcardManager = wildcardManager;
    }

    @Override
    public StringFunction parse(String regularExpression) {
        int arrowIndex;
        if (this.wildcardManager != null) {
            this.wildcardManager.reset();
        }
        if ((arrowIndex = regularExpression.indexOf("->")) < 0) {
            return new MatchingStringFunction(this.stringParser.parse(regularExpression));
        }
        String patternExpression = regularExpression.substring(0, arrowIndex);
        String replacementExpression = regularExpression.substring(arrowIndex + 2);
        MatchingStringFunction patternStringFunction = new MatchingStringFunction(this.stringParser.parse(patternExpression));
        StringFunction replacementStringFunction = this.wildcardManager == null ? new ConstantStringFunction(replacementExpression) : this.wildcardManager.createMatchedStringFunction(replacementExpression);
        return new AndStringFunction(patternStringFunction, replacementStringFunction);
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            WildcardManager wildcardManager = new WildcardManager();
            NameParser stringParser = new NameParser(wildcardManager);
            SingleFunctionParser stringFunctionParser = new SingleFunctionParser(stringParser, wildcardManager);
            StringFunction function = stringFunctionParser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String              [" + string + "]");
                System.out.println(" -> transformed = " + function.transform(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

