/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.evaluation.value.Value;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.util.ArrayUtil;

public class ProgramMethodOptimizationInfo
extends MethodOptimizationInfo {
    private static final Value[] EMPTY_PARAMETERS = new Value[0];
    private volatile boolean hasSideEffects = false;
    private volatile boolean canBeMadePrivate = true;
    private volatile boolean catchesExceptions = false;
    private volatile boolean branchesBackward = false;
    private volatile boolean invokesSuperMethods = false;
    private volatile boolean invokesDynamically = false;
    private volatile boolean accessesPrivateCode = false;
    private volatile boolean accessesPackageCode = false;
    private volatile boolean accessesProtectedCode = false;
    private volatile boolean hasSynchronizedBlock = false;
    private volatile boolean assignsFinalField = false;
    private volatile boolean returnsWithNonEmptyStack = false;
    private volatile int invocationCount = 0;
    private volatile int parameterSize = 0;
    private volatile long usedParameters = 0L;
    private volatile long escapedParameters = 0L;
    private volatile long escapingParameters = 0L;
    private volatile long modifiedParameters = 0L;
    private volatile boolean modifiesAnything = false;
    private volatile Value[] parameters;
    private volatile long returnedParameters = 0L;
    private volatile boolean returnsNewInstances = false;
    private volatile boolean returnsExternalValues = false;

    public ProgramMethodOptimizationInfo(Clazz clazz, Method method) {
        int parameterCount = ClassUtil.internalMethodParameterCount(method.getDescriptor(clazz), method.getAccessFlags());
        this.parameters = parameterCount == 0 ? EMPTY_PARAMETERS : new Value[parameterCount];
    }

    @Override
    public boolean isKept() {
        return false;
    }

    public void setSideEffects() {
        this.hasSideEffects = true;
    }

    @Override
    public boolean hasSideEffects() {
        return !this.hasNoSideEffects && this.hasSideEffects;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    @Override
    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void setCatchesExceptions() {
        this.catchesExceptions = true;
    }

    @Override
    public boolean catchesExceptions() {
        return this.catchesExceptions;
    }

    public void setBranchesBackward() {
        this.branchesBackward = true;
    }

    @Override
    public boolean branchesBackward() {
        return this.branchesBackward;
    }

    public void setInvokesSuperMethods() {
        this.invokesSuperMethods = true;
    }

    @Override
    public boolean invokesSuperMethods() {
        return this.invokesSuperMethods;
    }

    public void setInvokesDynamically() {
        this.invokesDynamically = true;
    }

    @Override
    public boolean invokesDynamically() {
        return this.invokesDynamically;
    }

    public void setAccessesPrivateCode() {
        this.accessesPrivateCode = true;
    }

    @Override
    public boolean accessesPrivateCode() {
        return this.accessesPrivateCode;
    }

    public void setAccessesPackageCode() {
        this.accessesPackageCode = true;
    }

    @Override
    public boolean accessesPackageCode() {
        return this.accessesPackageCode;
    }

    public void setAccessesProtectedCode() {
        this.accessesProtectedCode = true;
    }

    @Override
    public boolean accessesProtectedCode() {
        return this.accessesProtectedCode;
    }

    public void setHasSynchronizedBlock() {
        this.hasSynchronizedBlock = true;
    }

    @Override
    public boolean hasSynchronizedBlock() {
        return this.hasSynchronizedBlock;
    }

    public void setAssignsFinalField() {
        this.assignsFinalField = true;
    }

    @Override
    public boolean assignsFinalField() {
        return this.assignsFinalField;
    }

    public void setReturnsWithNonEmptyStack() {
        this.returnsWithNonEmptyStack = true;
    }

    @Override
    public boolean returnsWithNonEmptyStack() {
        return this.returnsWithNonEmptyStack;
    }

    public void incrementInvocationCount() {
        ++this.invocationCount;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    public synchronized void setParameterSize(int parameterSize) {
        this.parameterSize = parameterSize;
    }

    @Override
    public int getParameterSize() {
        return this.parameterSize;
    }

    public synchronized void setParameterUsed(int variableIndex) {
        this.usedParameters = this.setBit(this.usedParameters, variableIndex);
    }

    public synchronized void updateUsedParameters(long usedParameters) {
        this.usedParameters |= usedParameters;
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.parameterSize < 64 ? (this.usedParameters | -1L << this.parameterSize) != -1L : this.usedParameters != -1L;
    }

    @Override
    public boolean isParameterUsed(int variableIndex) {
        return this.isBitSet(this.usedParameters, variableIndex);
    }

    @Override
    public long getUsedParameters() {
        return this.usedParameters;
    }

    public synchronized void insertParameter(int parameterIndex) {
        this.escapedParameters = this.insertBit(this.escapedParameters, parameterIndex, 1L);
        this.escapingParameters = this.insertBit(this.escapingParameters, parameterIndex, 1L);
        this.modifiedParameters = this.insertBit(this.modifiedParameters, parameterIndex, 1L);
        this.returnedParameters = this.insertBit(this.returnedParameters, parameterIndex, 1L);
        this.parameters = ArrayUtil.insert(this.parameters, this.parameters.length, parameterIndex, null);
    }

    public synchronized void removeParameter(int parameterIndex) {
        this.escapedParameters = this.removeBit(this.escapedParameters, parameterIndex, 1L);
        this.escapingParameters = this.removeBit(this.escapingParameters, parameterIndex, 1L);
        this.modifiedParameters = this.removeBit(this.modifiedParameters, parameterIndex, 1L);
        this.returnedParameters = this.removeBit(this.returnedParameters, parameterIndex, 1L);
        ArrayUtil.remove(this.parameters, this.parameters.length, parameterIndex);
    }

    public synchronized void setParameterEscaped(int parameterIndex) {
        this.escapedParameters = this.setBit(this.escapedParameters, parameterIndex);
    }

    public synchronized void updateEscapedParameters(long escapedParameters) {
        this.escapedParameters |= escapedParameters;
    }

    @Override
    public boolean hasParameterEscaped(int parameterIndex) {
        return this.isBitSet(this.escapedParameters, parameterIndex);
    }

    @Override
    public long getEscapedParameters() {
        return this.escapedParameters;
    }

    public synchronized void setParameterEscaping(int parameterIndex) {
        this.escapingParameters = this.setBit(this.escapingParameters, parameterIndex);
    }

    public synchronized void updateEscapingParameters(long escapingParameters) {
        this.escapingParameters |= escapingParameters;
    }

    @Override
    public boolean isParameterEscaping(int parameterIndex) {
        return !this.hasNoEscapingParameters && this.isBitSet(this.escapingParameters, parameterIndex);
    }

    @Override
    public long getEscapingParameters() {
        return this.hasNoEscapingParameters ? 0L : this.escapingParameters;
    }

    public synchronized void setParameterModified(int parameterIndex) {
        this.modifiedParameters = this.setBit(this.modifiedParameters, parameterIndex);
    }

    public synchronized void updateModifiedParameters(long modifiedParameters) {
        this.modifiedParameters |= modifiedParameters;
    }

    @Override
    public boolean isParameterModified(int parameterIndex) {
        return !this.hasNoSideEffects && (!this.hasNoExternalSideEffects || parameterIndex == 0) && this.isBitSet(this.modifiesAnything ? this.modifiedParameters | this.escapedParameters : this.modifiedParameters, parameterIndex);
    }

    @Override
    public long getModifiedParameters() {
        return this.hasNoSideEffects ? 0L : (this.hasNoExternalSideEffects ? this.modifiedParameters & 1L : this.modifiedParameters);
    }

    public void setModifiesAnything() {
        this.modifiesAnything = true;
    }

    @Override
    public boolean modifiesAnything() {
        return !this.hasNoExternalSideEffects && this.modifiesAnything;
    }

    public synchronized void generalizeParameterValue(int parameterIndex, Value parameter) {
        this.parameters[parameterIndex] = this.parameters[parameterIndex] != null ? this.parameters[parameterIndex].generalize(parameter) : parameter;
    }

    @Override
    public Value getParameterValue(int parameterIndex) {
        return this.parameters != null ? this.parameters[parameterIndex] : null;
    }

    public synchronized void setParameterReturned(int parameterIndex) {
        this.returnedParameters = this.setBit(this.returnedParameters, parameterIndex);
    }

    public synchronized void updateReturnedParameters(long returnedParameters) {
        this.returnedParameters |= returnedParameters;
    }

    @Override
    public boolean returnsParameter(int parameterIndex) {
        return this.isBitSet(this.returnedParameters, parameterIndex);
    }

    @Override
    public long getReturnedParameters() {
        return this.returnedParameters;
    }

    public void setReturnsNewInstances() {
        this.returnsNewInstances = true;
    }

    @Override
    public boolean returnsNewInstances() {
        return this.returnsNewInstances;
    }

    public void setReturnsExternalValues() {
        this.returnsExternalValues = true;
    }

    @Override
    public boolean returnsExternalValues() {
        return !this.hasNoExternalReturnValues && this.returnsExternalValues;
    }

    public synchronized void generalizeReturnValue(Value returnValue) {
        this.returnValue = this.returnValue != null ? this.returnValue.generalize(returnValue) : returnValue;
    }

    public synchronized void merge(MethodOptimizationInfo other) {
        this.catchesExceptions |= other.catchesExceptions();
        this.branchesBackward |= other.branchesBackward();
        this.invokesSuperMethods |= other.invokesSuperMethods();
        this.invokesDynamically |= other.invokesDynamically();
        this.accessesPrivateCode |= other.accessesPrivateCode();
        this.accessesPackageCode |= other.accessesPackageCode();
        this.accessesProtectedCode |= other.accessesProtectedCode();
        this.hasSynchronizedBlock |= other.hasSynchronizedBlock();
        this.assignsFinalField |= other.assignsFinalField();
    }

    public static void setProgramMethodOptimizationInfo(Clazz clazz, Method method) {
        MethodLinker.lastMember(method).setProcessingInfo(new ProgramMethodOptimizationInfo(clazz, method));
    }

    public static ProgramMethodOptimizationInfo getProgramMethodOptimizationInfo(Method method) {
        return (ProgramMethodOptimizationInfo)MethodLinker.lastMember(method).getProcessingInfo();
    }

    private long setBit(long bits, int index) {
        return index < 64 ? bits | 1L << index : bits;
    }

    private boolean isBitSet(long bits, int index) {
        return index >= 64 || (bits & 1L << index) != 0L;
    }

    private long insertBit(long value, int bitIndex, long bitValue) {
        long higherMask = -1L << bitIndex;
        long lowerMask = higherMask ^ 0xFFFFFFFFFFFFFFFFL;
        return (value & higherMask) << 1 | value & lowerMask | bitValue << bitIndex;
    }

    private long removeBit(long value, int bitIndex, long highBitValue) {
        long higherMask = -1L << bitIndex;
        long lowerMask = higherMask ^ 0xFFFFFFFFFFFFFFFFL;
        return (value & higherMask << 1) >>> 1 | value & lowerMask | highBitValue << 63;
    }
}

