/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonSerializationInvocationFinder
implements InstructionVisitor {
    public static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final ClassVisitor domainClassVisitor;
    private final WarningPrinter warningPrinter;
    private final ToJsonInvocationMatcher[] toJsonInvocationMatchers;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.valueFactory, new BasicInvocationUnit(new TypedReferenceValueFactory()), true);
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor(this.partialEvaluator));

    public GsonSerializationInvocationFinder(ClassPool programClassPool, ClassPool libraryClassPool, ClassVisitor domainClassVisitor, WarningPrinter warningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.domainClassVisitor = domainClassVisitor;
        this.warningPrinter = warningPrinter;
        InstructionSequenceBuilder builder = new InstructionSequenceBuilder();
        Instruction[] toJsonObjectInstructions = builder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;)Ljava/lang/String;").instructions();
        Instruction[] toJsonObjectTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/String;").instructions();
        Instruction[] toJsonObjectAppendableInstructions = builder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/Appendable;)V").instructions();
        Instruction[] toJsonObjectTypeAppendableInstructions = builder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Ljava/lang/Appendable;)V").instructions();
        Instruction[] toJsonObjectTypeWriterInstructions = builder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Lcom/google/gson/stream/JsonWriter;)V").instructions();
        Instruction[] toJsonTreeObjectInstructions = builder.invokevirtual("com/google/gson/Gson", "toJsonTree", "(Ljava/lang/Object;)Lcom/google/gson/JsonElement;").instructions();
        Instruction[] toJsonTreeObjectTypeInstructions = builder.invokevirtual("com/google/gson/Gson", "toJsonTree", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Lcom/google/gson/JsonElement;").instructions();
        Constant[] constants = builder.constants();
        this.toJsonInvocationMatchers = new ToJsonInvocationMatcher[]{new ToJsonInvocationMatcher(constants, toJsonObjectInstructions, 0, -1), new ToJsonInvocationMatcher(constants, toJsonObjectTypeInstructions, 1, 0), new ToJsonInvocationMatcher(constants, toJsonObjectAppendableInstructions, 1, -1), new ToJsonInvocationMatcher(constants, toJsonObjectTypeAppendableInstructions, 2, 1), new ToJsonInvocationMatcher(constants, toJsonObjectTypeWriterInstructions, 2, 1), new ToJsonInvocationMatcher(constants, toJsonTreeObjectInstructions, 0, -1), new ToJsonInvocationMatcher(constants, toJsonTreeObjectTypeInstructions, 1, 0)};
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        ToJsonInvocationMatcher matchingMatcher = null;
        for (ToJsonInvocationMatcher matcher : this.toJsonInvocationMatchers) {
            instruction.accept(clazz, method, codeAttribute, offset, matcher);
            if (!matcher.isMatching()) continue;
            matchingMatcher = matcher;
            break;
        }
        if (matchingMatcher != null) {
            this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            if (matchingMatcher.typeStackElementIndex == -1) {
                int stackElementIndex = matchingMatcher.objectStackElementIndex;
                ReferenceValue top = this.partialEvaluator.getStackBefore(offset).getTop(stackElementIndex).referenceValue();
                Clazz targetClass = top.getReferencedClass();
                if (targetClass instanceof ProgramClass) {
                    targetClass.accept(this.domainClassVisitor);
                }
            } else {
                int stackElementIndex = matchingMatcher.typeStackElementIndex;
                InstructionOffsetValue producer = this.partialEvaluator.getStackBefore(offset).getTopActualProducerValue(stackElementIndex).instructionOffsetValue();
                TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.libraryClassPool, this.partialEvaluator);
                for (int i = 0; i < producer.instructionOffsetCount(); ++i) {
                    codeAttribute.instructionAccept(clazz, method, producer.instructionOffset(i), typeArgumentFinder);
                }
                String[] targetTypes = typeArgumentFinder.typeArgumentClasses;
                if (targetTypes != null) {
                    for (String targetType : targetTypes) {
                        this.programClassPool.classAccept(targetType, this.domainClassVisitor);
                    }
                } else if (this.warningPrinter != null) {
                    this.warningPrinter.print(clazz.getName(), "Warning: can't derive serialized type from toJson() invocation in " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
                }
            }
        }
    }

    private static class ToJsonInvocationMatcher
    extends InstructionSequenceMatcher {
        private int objectStackElementIndex;
        private int typeStackElementIndex;

        private ToJsonInvocationMatcher(Constant[] patternConstants, Instruction[] patternInstructions, int objectStackElementIndex, int typeStackElementIndex) {
            super(patternConstants, patternInstructions);
            this.objectStackElementIndex = objectStackElementIndex;
            this.typeStackElementIndex = typeStackElementIndex;
        }
    }
}

