function clean_generated_files(fortd_interform, gateways_interform, tools, mexdir)
%CLEAN_GENERATED_FILES remove files (other than MEX) generated by the MATLAB setup process

% Remove the interform directory `fortd_interform`
if exist(fortd_interform, 'dir')
    rmdir(fortd_interform, 's');
end

% Remove the interform directory `gateways_interform`
if exist(gateways_interform, 'dir')
    rmdir(gateways_interform, 's');
end

% Remove the generated files under `tools`
file_list = {'all_precisions.m', 'all_variants.m'};
for ifile = 1 : length(file_list)
    file = fullfile(tools, file_list{ifile});
    if exist(file, 'file')
        delete(file);
    end
end

% Remove the generated files under `mexdir`
file_list = {'all_solvers.m', 'all_precisions.m', 'all_variants.m', 'dbgstr.m', 'get_mexname.m', 'package_info.m'};
for ifile = 1 : length(file_list)
    file = fullfile(mexdir, file_list{ifile});
    if exist(file, 'file')
        delete(file);
    end
end

return
