.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER DATABASE" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DATABASE \- change a database

.SH SYNOPSIS
.sp
.nf
ALTER DATABASE \fIname\fR SET \fIparameter\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER DATABASE \fIname\fR RESET \fIparameter\fR

ALTER DATABASE \fIname\fR RENAME TO \fInewname\fR

ALTER DATABASE \fIname\fR OWNER TO \fInew_owner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DATABASE\fR changes the attributes
of a database.
.PP
The first two forms change the session default for a run-time
configuration variable for a PostgreSQL
database. Whenever a new session is subsequently started in that
database, the specified value becomes the session default value.
The database-specific default overrides whatever setting is present
in \fIpostgresql.conf\fR or has been received from the
\fBpostmaster\fR command line. Only the database
owner or a superuser can change the session defaults for a
database. Certain variables cannot be set this way, or can only be
set by a superuser.
.PP
The third form changes the name of the database. Only the database
owner or a superuser can rename a database; non-superuser owners must
also have the
CREATEDB privilege. The current database cannot
be renamed. (Connect to a different database if you need to do
that.)
.PP
The fourth form changes the owner of the database. Only a superuser
can change the database's owner.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the database whose attributes are to be altered.
.TP
\fB\fIparameter\fB\fR
.TP
\fB\fIvalue\fB\fR
Set this database's session default for the specified configuration
parameter to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
database-specific setting is removed, so the system-wide default
setting will be inherited in new sessions. Use RESET
ALL to clear all database-specific settings.

See SET [\fBset\fR(l)] and the documentation
for more information about allowed parameter names
and values.
.TP
\fB\fInewname\fB\fR
The new name of the database.
.TP
\fB\fInew_owner\fB\fR
The new owner of the database.
.SH "NOTES"
.PP
It is also possible to tie a session default to a specific user
rather than to a database; see
ALTER USER [\fBalter_user\fR(l)].
User-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
To disable index scans by default in the database
test:
.sp
.nf
ALTER DATABASE test SET enable_indexscan TO off;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER DATABASE\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
CREATE DATABASE [\fBcreate_database\fR(l)], DROP DATABASE [\fBdrop_database\fR(l)], SET [\fBset\fR(l)]
