---
title: PostgreSQL JDBC Driver 42.2.19 Released
date: 2021-02-18 14:25:56 +0000
categories:
  - new_release
version: 42.2.19
---
**Notable changes**

### Changed

### Added

### Fixed

## [42.2.19] (2021-02-18)

**Notable Changes**
- Now the driver uses SASLprep normalization for SCRAM authentication fixing some issues with spaces in passwords.
- If closeOnCompletion is called on an existing statement and the statement
is executed a second time it will fail.

### Changed
- Fix: Actually close unclosed results. Previously was not closing the first unclosed result fixes #1903 (#1905)
There is a small behaviour change here as a result. If closeOnCompletion is called on an existing statement and the statement
is executed a second time it will fail.

### Added 
- Verify code via forbidden-apis (jdk-internal and jdk-non-portable signatures) [PR #2012](https://github.com/pgjdbc/pgjdbc/pull/2012)

### Fixed
- Fix: properly set cancel socket timeout (#2044)
- Fix "Required class information missing" when old org.jboss:jandex parses pgjdbc classes [issue 2008][https://github.com/pgjdbc/pgjdbc/issues/2008]
- Fix PGCopyInputStream returning the last row twice when reading with CopyOut API [issue 2016][https://github.com/pgjdbc/pgjdbc/issues/2016]
- Fix Connnection.isValid() to not wait longer than existing network timeout [PR #2040](https://github.com/pgjdbc/pgjdbc/pull/2040)
- Fix Passwords with spaces (ASCII and non-ASCII) now work with SCRAM authentication (driver now uses SASLprep normalization) [PR #2052](https://github.com/pgjdbc/pgjdbc/pull/2052)
- Fix DatabaseMetaData.getTablePrivileges() to include views, materialized views, and foreign tables [PR #2049](https://github.com/pgjdbc/pgjdbc/pull/2049)


<!--more-->

**Commits by author**

Dave Cramer (5):

* remove gssEncMode to test default in tests, should default to allow now [PR 1927](https://github.com/pgjdbc/pgjdbc/pull/1927) [013ba273](https://github.com/pgjdbc/pgjdbc/commit/013ba2730848ba43762d85d3a36a487cf2ea0ad0)
* Fixsite release42.2 [PR 2032](https://github.com/pgjdbc/pgjdbc/pull/2032) [9fcfd76e](https://github.com/pgjdbc/pgjdbc/commit/9fcfd76e7b3cf53acf7f247b4965272ad7a21b13)
* chore: More42.2 site fixes [PR 2035](https://github.com/pgjdbc/pgjdbc/pull/2035) [411f39d6](https://github.com/pgjdbc/pgjdbc/commit/411f39d61f6f874a1d0c8940fe72da4ed8416c3d)
* fix: Actually close unclosed results. Previously was not closing the first unclosed result fixes [PR 1903](https://github.com/pgjdbc/pgjdbc/pull/1903) (#1905) [fc25aebc](https://github.com/pgjdbc/pgjdbc/commit/fc25aebcec1b8abf7628bccd8cf565107afd85b1)

Jeremy Mailen (3):

* fix: return metadata privileges for views and foreign tables [66690817](https://github.com/pgjdbc/pgjdbc/commit/66690817f4b8926f8ab47a104538970c6c5e0dd3)
* refactor: consolidate repeated drop code in TestUtil [f5abc65c](https://github.com/pgjdbc/pgjdbc/commit/f5abc65c813f6564a7b9c5a6a2a96a9ccc2f8dde)
* test: Add test for ACLs returned from metadata getTablePrivileges() for views [a6cf67d2](https://github.com/pgjdbc/pgjdbc/commit/a6cf67d24bc698f62e43867f5aa61383b386e74c)

Jorge Solórzano (1):

* fix: Use SASLprep normalization for SCRAM authentication [PR 2052](https://github.com/pgjdbc/pgjdbc/pull/2052) [b4800044](https://github.com/pgjdbc/pgjdbc/commit/b4800044b3db9aef0d264baef2a95355c9059a1f)

Pavel Bludov (2):

* chore: javadoc changes in PgResultSet.java to pass upcoming checkstyle version [70471c25](https://github.com/pgjdbc/pgjdbc/commit/70471c25dbc6e64b5ed7a3c9db8bce26fe27e94d)
* chore: javadoc changes in Driver.java to pass upcoming checkstyle version [c57ac5eb](https://github.com/pgjdbc/pgjdbc/commit/c57ac5eb5dec170a24f833c64f74a63fd7b53940)

Power (1):

* fix: isValid() should not wait longer than network timeout [0dbc6078](https://github.com/pgjdbc/pgjdbc/commit/0dbc6078b98215f11413a8b0f3a15a7c08180a29)

Roman Kozlov (1):

* fix: properly set cancel socket timeout [PR 2044](https://github.com/pgjdbc/pgjdbc/pull/2044) [e551d1a6](https://github.com/pgjdbc/pgjdbc/commit/e551d1a6b41adbca8c905762bd24299a29463db2)

Sehrope Sarkuni (5):

* test: Add tests for broken PGCopyInputStream.readFromCopy() [c6794f09](https://github.com/pgjdbc/pgjdbc/commit/c6794f09572c51bceb284e38b14c07a999d1aab9)
* fix: Fix last row duplicated in PGCopyInputStream.readFromCopy() [6c296a52](https://github.com/pgjdbc/pgjdbc/commit/6c296a52d5437c318ad3a1a40af4046ce7d1ac3f)
* test: Add TestUtils.closeQuietly(...) [c152f7f0](https://github.com/pgjdbc/pgjdbc/commit/c152f7f0639391f180a74b31b3527b213818b0d0)
* test: Add StrangeProxyServer [8f773a15](https://github.com/pgjdbc/pgjdbc/commit/8f773a15ec4898af66806e851090e62d38edfb88)
* docs: Add getTablePrivileges() fix to changelog [444cb1b1](https://github.com/pgjdbc/pgjdbc/commit/444cb1b17b17bcde378e97805b3ee61c50eba0be)

Vladimir Sitnikov (14):

* chore: make javadoc optional for building from a reduced-pom.xml [736eb70d](https://github.com/pgjdbc/pgjdbc/commit/736eb70d76549afc3906362ffd3747cb6a311443)
* chore: make buildSrc.jar reproducible [ff0774da](https://github.com/pgjdbc/pgjdbc/commit/ff0774da883287e9f012dd09f510e062167143e3)
* chore: use cleanup-gradle-cache for Travis cache cleanup [0e0ae208](https://github.com/pgjdbc/pgjdbc/commit/0e0ae208e50de479c64e4afd25e5b3c1e5874d68)
* fix: allow specifying binaryTransferEnable even for those types that are not enabled by default [ed5891e3](https://github.com/pgjdbc/pgjdbc/commit/ed5891e3f019977ee0a999c7e572ace34b3bd918)
* fix: binary transfer for numeric [PR 1935](https://github.com/pgjdbc/pgjdbc/pull/1935) [a4173079](https://github.com/pgjdbc/pgjdbc/commit/a4173079dfd35c95de984f369cab0d5e7f951ed7)
* chore: update Gradle 6.3 -> 6.7.1 [PR 2011](https://github.com/pgjdbc/pgjdbc/pull/2011) [dbb12e41](https://github.com/pgjdbc/pgjdbc/commit/dbb12e41390054ee8a58508e4004e3834a86a7ea)
* chore: verify code via forbidden-apis (jdk-internal and jdk-non-portable signatures) [991a9c0b](https://github.com/pgjdbc/pgjdbc/commit/991a9c0b4d2eea6bbbccc0afd2aa5d63b804e306)
* chore: add org.postgresql.util.internal.Unsafe for forbidden-apis suppressions [6e3be122](https://github.com/pgjdbc/pgjdbc/commit/6e3be12203fd4f76992d2ab88bcdb4a21a0b44d0)
* fix: "Required class information missing" when old org.jboss:jandex parses pgjdbc classes (PR [PR 2010](https://github.com/pgjdbc/pgjdbc/pull/2010) [2df6c97b](https://github.com/pgjdbc/pgjdbc/commit/2df6c97b6b4a1c39d03099efa62e85bbc907723f)
* test: set gssEncMode only in case it is not already present in Properties [97f6abd1](https://github.com/pgjdbc/pgjdbc/commit/97f6abd1c8cc16af4056bceccc3c1f52faa27c02)
* test: temporarily allow CONNECTION_UNABLE_TO_CONNECT in SslTest for bad client certificates [5f584cd4](https://github.com/pgjdbc/pgjdbc/commit/5f584cd4a5c2f19a526874e14c66fad4ab1b2d79)
* perf: avoid duplicate PGStream#changeSocket calls [b7e70d85](https://github.com/pgjdbc/pgjdbc/commit/b7e70d856276ff75dc487bc20694c7ff5ddebbaa)
* chore: cancel stale workflows in GitHub Actions CI [d255bd21](https://github.com/pgjdbc/pgjdbc/commit/d255bd21778c00dafa40e6b096f052aea61d29a8)
* doc: update README link from travis-ci.org to travis-ci.com [1bd679e8](https://github.com/pgjdbc/pgjdbc/commit/1bd679e84edf854df92d1bd7d1cd006cc0360c61)

odubaj (1):

* Remove dependency on java-comment-preprocesor [df2297ef](https://github.com/pgjdbc/pgjdbc/commit/df2297ef6b4d26c1de9a5c90e0f8c524dd437425)

rtrier (1):

* * Fix resolve ParseError in PGtokenizer fixes [PR 2050](https://github.com/pgjdbc/pgjdbc/pull/2050) [9d6ab68e](https://github.com/pgjdbc/pgjdbc/commit/9d6ab68ebfaba68244a49c86186021d32f93ff2f)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[Dave Cramer](davec@postgresintl.com)  
[Jeremy Mailen](https://github.com/jeremymailen)  
[Jorge Solórzano](https://github.com/jorsol)  
[odubaj](https://github.com/odubaj)  
[Pavel Bludov](https://github.com/pbludov)  
[Power](https://github.com/Powerrr)  
[Roman Kozlov](https://github.com/Powerrr)  
[rtrier](https://github.com/rtrier)  
[Sehrope Sarkuni](https://github.com/sehrope)  
[Vladimir Sitnikov](https://github.com/vlsi)  
