---
title: PostgreSQL JDBC Driver 42.2.15 Released
date: 2020-08-14 21:39:56 +0300
categories:
  - new_release
version: 42.2.15
---
**Notable changes**

### Known issues
- The driver returns enum and jsonb arrays elements are returned as PGobject instances (fixed in 42.2.17)

### Changed
- Rename source distribution archive to `postgresql-$version-jdbc-src.tar.gz`, and add top-level archive folder [ba017507](https://github.com/pgjdbc/pgjdbc/commit/ba0175072ee9c751c1496d2fe170f4af7256f1a5)
- Add the ability to connect with a GSSAPI encrypted connection. As of PostgreSQL version 12 GSSAPI encrypted connections
are possible. Now the driver will attempt to connect to the server with a GSSAPI encrypted connection. If that fails then
attempt an SSL connection, finally falling back to a plain text connection. All of this is controlled using both the gssEncMode
and sslMode parameters which, in concert with pg_hba.conf, determine if a particular mode is allowed and or required. [PR 1821](https://github.com/pgjdbc/pgjdbc/pull/1821) [ad921b9e](https://github.com/pgjdbc/pgjdbc/commit/ad921b9e3563b28b9a03b1e2dfaad0e34efc02f1)
- Source release archive shades dependencies (scram) by default. It affects only postgresql-version-src.tar.gz release artifact [f0301eb9](https://github.com/pgjdbc/pgjdbc/commit/f0301eb901f880059b00b0fb0a3ee93ef7d749a8)
- Refactor decoding arrays [PR 1194](https://github.com/pgjdbc/pgjdbc/pull/1194) [0fd09396](https://github.com/pgjdbc/pgjdbc/commit/0fd0939696cc7020a98c8fc67471d6c5ce2b375f)

### Added
- Verify nullness with CheckerFramework [6e524ae5](https://github.com/pgjdbc/pgjdbc/commit/6e524ae51cee67b25426c09a7083465c820c0a0d)

### Fixed
- Avoid preparedStatement leak when using updateable ResultSet via insert/update/refreshRow [PR 1815](https://github.com/pgjdbc/pgjdbc/pull/1815) [9a0d2b18](https://github.com/pgjdbc/pgjdbc/commit/9a0d2b18a81c7ec5974d4caf2ff2d218312da25f)
- Change order of checks for oid vs primary keys. OID's have been deprecated. [PR 1613](https://github.com/pgjdbc/pgjdbc/pull/1613)
- Close certificate file stream. [PR 1837](https://github.com/pgjdbc/pgjdbc/pull/1837) [a40052c9](https://github.com/pgjdbc/pgjdbc/commit/a40052c9176afaf68c7c4637e604dc427c2e7335)
- Make sure socketTimeout is enforced [PR 1831](https://github.com/pgjdbc/pgjdbc/pull/1831) [210b27a6](https://github.com/pgjdbc/pgjdbc/commit/210b27a62f39332d93e0b07b4bdc55b8a2ffebb7)
- Assume PKCS-8 SSL key format by default [PR 1819](https://github.com/pgjdbc/pgjdbc/pull/1819) [80d4ed34](https://github.com/pgjdbc/pgjdbc/commit/80d4ed34c99d51dd8b06df00baad0265fd620fec)
- Preserve unquoted unicode whitespace in array literals [PR 1266](https://github.com/pgjdbc/pgjdbc/pull/1266)

<!--more-->

**Commits by author**

Brett Okken (1):

* Refactor decoding arrays [PR 1194](https://github.com/pgjdbc/pgjdbc/pull/1194) [0fd09396](https://github.com/pgjdbc/pgjdbc/commit/0fd0939696cc7020a98c8fc67471d6c5ce2b375f)

Dave Cramer (12):

* use jdk8 [PR 1806](https://github.com/pgjdbc/pgjdbc/pull/1806) [b86a7c32](https://github.com/pgjdbc/pgjdbc/commit/b86a7c32a79784566a0903a5bef8f4677bed3a15)
* fix: replication test we were not waiting for the view to be updated [PR 1805](https://github.com/pgjdbc/pgjdbc/pull/1805) [ba84ddd3](https://github.com/pgjdbc/pgjdbc/commit/ba84ddd39ac275793c9867096d0b1560d254439a)
* fix up readonlyMode docs [PR 1807](https://github.com/pgjdbc/pgjdbc/pull/1807) [796bd4e2](https://github.com/pgjdbc/pgjdbc/commit/796bd4e21bbf3913967bf51a08ae6142f45cb6c4)
* remove old directories [PR 1809](https://github.com/pgjdbc/pgjdbc/pull/1809) [1a0991c5](https://github.com/pgjdbc/pgjdbc/commit/1a0991c56f768867476c311ad239237f3844d886)
* remove old links [PR 1810](https://github.com/pgjdbc/pgjdbc/pull/1810) [1ed7dd8e](https://github.com/pgjdbc/pgjdbc/commit/1ed7dd8e8162ceb7492c5fe7191b48172b2fc29b)
* fix: New PGStream constructor which copies settings from old pgstream [PR 1811](https://github.com/pgjdbc/pgjdbc/pull/1811) [7b49a694](https://github.com/pgjdbc/pgjdbc/commit/7b49a694339e93acbcddeaa2ecb12bcfa85407ec)
* fix: remove code borrowed from apache cxf project  [PR 1813](https://github.com/pgjdbc/pgjdbc/pull/1813) [a1980237](https://github.com/pgjdbc/pgjdbc/commit/a19802371a24303695bd1183cb25eec8d3461998)
* Gssapi encrypted [PR 1821](https://github.com/pgjdbc/pgjdbc/pull/1821) [ad921b9e](https://github.com/pgjdbc/pgjdbc/commit/ad921b9e3563b28b9a03b1e2dfaad0e34efc02f1)
* use connection encoding instead of hard coding ISO-8859-1 [PR 1833](https://github.com/pgjdbc/pgjdbc/pull/1833) [de239cc0](https://github.com/pgjdbc/pgjdbc/commit/de239cc09aee3916daa6cdb77abfa486675efbbd)
* Fix: change order of checks for oid vs primary keys. Fixes [PR 1613](https://github.com/pgjdbc/pgjdbc/pull/1613) (#1839) [08507f8e](https://github.com/pgjdbc/pgjdbc/commit/08507f8e04b0da47c09a296fae095a45c412c7b8)
* try java14 [PR 1844](https://github.com/pgjdbc/pgjdbc/pull/1844) [148ecb58](https://github.com/pgjdbc/pgjdbc/commit/148ecb589b6fc02f66831b382085e73646e312a3)
* update docs into the next century [PR 1770](https://github.com/pgjdbc/pgjdbc/pull/1770) [5801e321](https://github.com/pgjdbc/pgjdbc/commit/5801e321e90e06a66020bd015b9e43550ffdf7cd)

Eduardo Souza (1):

* Closing certificate file stream. [PR 1837](https://github.com/pgjdbc/pgjdbc/pull/1837) [a40052c9](https://github.com/pgjdbc/pgjdbc/commit/a40052c9176afaf68c7c4637e604dc427c2e7335)

Mike Noordermeer (1):

* fix: make sure socketTimeout is enforced [PR 1831](https://github.com/pgjdbc/pgjdbc/pull/1831) [210b27a6](https://github.com/pgjdbc/pgjdbc/commit/210b27a62f39332d93e0b07b4bdc55b8a2ffebb7)

Vladimir Sitnikov (18):

* chore: configure method parameter wrapping in IntelliJ via editorconfig [aa70d2f4](https://github.com/pgjdbc/pgjdbc/commit/aa70d2f43fdb80626e115217e913485bf50d7178)
* fix: avoid NPE when initializing SingleCertValidatingFactory with classpath resource and contextclassloader is null [0b7575a9](https://github.com/pgjdbc/pgjdbc/commit/0b7575a97efac445f1a1a645942f364c9b93aef2)
* fix: avoid preparedStatement leak when using updateable ResultSet via insert/update/refreshRow [PR 1815](https://github.com/pgjdbc/pgjdbc/pull/1815) [9a0d2b18](https://github.com/pgjdbc/pgjdbc/commit/9a0d2b18a81c7ec5974d4caf2ff2d218312da25f)
* chore: rename source distribution archive to `postgresql-$version-jdbc-src.tar.gz`, add top-level archive folder [ba017507](https://github.com/pgjdbc/pgjdbc/commit/ba0175072ee9c751c1496d2fe170f4af7256f1a5)
* chore: fix style in pgjbc/build.gradle.kts [44b12472](https://github.com/pgjdbc/pgjdbc/commit/44b124724a1ad6cad27247233942e93a19d8a7e3)
* chore: move testgss to main.yml to avoid duplicate CI groups in GitHub Actions [PR 1824](https://github.com/pgjdbc/pgjdbc/pull/1824) [6d4dc763](https://github.com/pgjdbc/pgjdbc/commit/6d4dc7637028725cbb3ecda87a38be8599a7c178)
* tests: add gssEncMode to SslTest [PR 1823](https://github.com/pgjdbc/pgjdbc/pull/1823) [08bfc033](https://github.com/pgjdbc/pgjdbc/commit/08bfc033f41f300dbf80e7c5afe1241e77c2e919)
* chore: add checkerframework for nullness verification [6e524ae5](https://github.com/pgjdbc/pgjdbc/commit/6e524ae51cee67b25426c09a7083465c820c0a0d)
* doc: add null safety documentation to CONTRIBUTING.md [2ba3028e](https://github.com/pgjdbc/pgjdbc/commit/2ba3028ee5dbb5596d8981801051fca5c233b8ec)
* refactor: add nullness annotations [529e5dc3](https://github.com/pgjdbc/pgjdbc/commit/529e5dc3a8f071ad4946daf3bde1422c21a99524)
* test: reduce stdout verbosity of CopyLargeFileTest [aa190cce](https://github.com/pgjdbc/pgjdbc/commit/aa190cce2c27ac5f5d4fa33f5d156f8bf04cbe0c)
* chore: add S3 Gradle build cache [67155873](https://github.com/pgjdbc/pgjdbc/commit/67155873114a6199ecbb0e3bbcc0a8e34d53db79)
* chore: collect Gradle Build Scan from CI jobs [8b3bf922](https://github.com/pgjdbc/pgjdbc/commit/8b3bf922af615c2420319796480d49fe0732ae35)
* fix: nullability annotations for LruCache/Gettable/GettableHashMap [34cd4f93](https://github.com/pgjdbc/pgjdbc/commit/34cd4f93e49087c216bb4b516cb5b1fee35968f1)
* chore: enable local build cache, and use burrunan/gradle-cache-action@v1 for GitHub Actions caching [3802b453](https://github.com/pgjdbc/pgjdbc/commit/3802b453608349b11a81585f3dbca9f623687d3d)
* chore: shade dependencies when building from the source archive [f0301eb9](https://github.com/pgjdbc/pgjdbc/commit/f0301eb901f880059b00b0fb0a3ee93ef7d749a8)
* fix: use Assertions#assertThrows instead of Assert#assertThrows to keep the code junit 4.12 compatible [075bd102](https://github.com/pgjdbc/pgjdbc/commit/075bd1020b3eb53897add95f5eccc35ea5dd11c4)
* docs: update the current version in readme.md [e901ff74](https://github.com/pgjdbc/pgjdbc/commit/e901ff74ff01245a8712e832da18558ed5b47b84)

azraino (1):

* docs: change readOnlyMode on connect.md documentation [PR 1784](https://github.com/pgjdbc/pgjdbc/pull/1784) [19a835a4](https://github.com/pgjdbc/pgjdbc/commit/19a835a403d7ab0e4d42988d7586a73550462ed3)

pip25 (2):

* fix: assume PKCS-8 SSL key format by default [PR 1819](https://github.com/pgjdbc/pgjdbc/pull/1819) (#1832) [80d4ed34](https://github.com/pgjdbc/pgjdbc/commit/80d4ed34c99d51dd8b06df00baad0265fd620fec)
* docs: touch up SSL keyfile documentation [PR 1836](https://github.com/pgjdbc/pgjdbc/pull/1836) [2c5517af](https://github.com/pgjdbc/pgjdbc/commit/2c5517afec26f5dd784d1f41276210a2cb1e3370)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[azraino](https://github.com/azraino)  
[Brett Okken](https://github.com/bokken)  
[Dave Cramer](davec@postgresintl.com)  
[Eduardo Souza](https://github.com/emsouza)  
[Mike Noordermeer](https://github.com/MikeN123)  
[pip25](https://github.com/pip25)  
[Vladimir Sitnikov](https://github.com/vlsi)  
