---
title: PostgreSQL JDBC Driver 42.2.10 Released
date: 2020-01-30 20:12:11 +0000
categories:
  - new_release
version: 42.2.10
---
**Notable changes**

### Changed
 - (!) Regression: remove receiving EOF from backend after cancel [PR 1641](https://github.com/pgjdbc/pgjdbc/pull/1252). The regression is that the subsequent query might receive the cancel signal.

### Added
 - Add maxResultBuffer property [PR 1657](https://github.com/pgjdbc/pgjdbc/pull/1657)
 - add caller push of binary data (rebase of #953) [PR 1659](https://github.com/pgjdbc/pgjdbc/pull/1659)
 
### Fixed
 - Cleanup PGProperty, sort values, and add some missing to docs [PR 1686](https://github.com/pgjdbc/pgjdbc/pull/1686)
 - Fixing LocalTime rounding (losing precision) [PR 1570](https://github.com/pgjdbc/pgjdbc/pull/1570)
 - Network Performance of PgDatabaseMetaData.getTypeInfo() method [PR 1668](https://github.com/pgjdbc/pgjdbc/pull/1668)
 - Issue #1680 updating a boolean field requires special handling to set it to t or f instead of true or false [PR 1682](https://github.com/pgjdbc/pgjdbc/pull/1682)
 - bug in pgstream for replication [PR 1681](https://github.com/pgjdbc/pgjdbc/pull/1681)
 - Issue #1677 NumberFormatException when fetching PGInterval with small value [PR 1678](https://github.com/pgjdbc/pgjdbc/pull/1678)
 - Metadata queries improvements with large schemas. [PR 1673](https://github.com/pgjdbc/pgjdbc/pull/1673)
 - Utf 8 encoding optimizations [PR 1444](https://github.com/pgjdbc/pgjdbc/pull/1444)
 - interval overflow [PR 1658](https://github.com/pgjdbc/pgjdbc/pull/1658)
 - Issue #1482 where the port was being added to the GSSAPI service name [PR 1651](https://github.com/pgjdbc/pgjdbc/pull/1651)
 - remove receiving EOF from backend after cancel since according to protocol the server closes the connection once cancel is sent (connection reset exception is always thrown) [PR 1641](https://github.com/pgjdbc/pgjdbc/pull/1641)
 - Unable to register out parameter Issue #1646 [PR 1648](https://github.com/pgjdbc/pgjdbc/pull/1648)
  
## [42.2.9] (2019-12-06)
### Changed

### Added
 - read only transactions [PR 1252](https://github.com/pgjdbc/pgjdbc/pull/1252)
 - pkcs12 key functionality [PR 1599](https://github.com/pgjdbc/pgjdbc/pull/1599)
 - new "escapeSyntaxCallMode" connection property [PR 1560](https://github.com/pgjdbc/pgjdbc/pull/1560)
 - connection property to limit server error detail in exception exceptions [PR 1579](https://github.com/pgjdbc/pgjdbc/pull/1579)
 - cancelQuery() to PGConnection public interface [PR 1157](https://github.com/pgjdbc/pgjdbc/pull/1157) 
 - support for large update counts (JDBC 4.2) [PR 935](https://github.com/pgjdbc/pgjdbc/pull/935)
 - Add Binary Support for Oid.NUMERIC and Oid.NUMERIC_ARRAY [PR 1636](https://github.com/pgjdbc/pgjdbc/pull/1636) 
 
### Fixed
 - issue 716 getTypeInfo() may not return data in the order specified in Oracle documentation [PR 1506](https://github.com/pgjdbc/pgjdbc/pull/1506)
 - PgSQLXML setCharacterStream() results in null value  [PR 1608](https://github.com/pgjdbc/pgjdbc/pull/1608)
 - get correct column length for simple domains [PR 1605](https://github.com/pgjdbc/pgjdbc/pull/1605)
 - NPE as a result of calling executeQuery twice on a statement fixes issue [#684](https://github.com/pgjdbc/pgjdbc/issues/684) [PR 1610] (https://github.com/pgjdbc/pgjdbc/pull/1610)
 - handle numeric domain types [PR 1611](https://github.com/pgjdbc/pgjdbc/pull/1611) 
 - pginterval to take iso8601 strings [PR 1612](https://github.com/pgjdbc/pgjdbc/pull/1612)
 - remove currentTimeMillis from code, tests are OK [PR 1617](https://github.com/pgjdbc/pgjdbc/pull/1617) 
 - NPE when calling setNull on a PreparedStatement with no parameters [PR 1620](https://github.com/pgjdbc/pgjdbc/pull/1620)
 - allow OUT parameter registration when using CallableStatement native CALL [PR 1561](https://github.com/pgjdbc/pgjdbc/pull/1561)
 - add release save point into execute with batch [PR 1583](https://github.com/pgjdbc/pgjdbc/pull/1583) 
 - Prevent use of extended query protocol for BEGIN before COPY [PR 1639](https://github.com/pgjdbc/pgjdbc/pull/1639)


<!--more-->

**Commits by author**

Brett Okken (2):

* feat: read only transactions [PR 1252](https://github.com/pgjdbc/pgjdbc/pull/1252) [05079793](https://github.com/pgjdbc/pgjdbc/commit/050797934a8a9c0ce2dff068eba14931988370ca)
* Utf 8 encoding optimizations [PR 1444](https://github.com/pgjdbc/pgjdbc/pull/1444) [c84e62ef](https://github.com/pgjdbc/pgjdbc/commit/c84e62efa5b98323562753e45fbf0d974eaca483)

Craig Ringer (1):

* Prevent use of extended query protocol for BEGIN before COPY [PR 1639](https://github.com/pgjdbc/pgjdbc/pull/1639) [b3711537](https://github.com/pgjdbc/pgjdbc/commit/b37115373935732b1ab5e59b56837ac49942718a)

Dave Cramer (33):

* Add simple test to make sure we can load a key [PR 1588](https://github.com/pgjdbc/pgjdbc/pull/1588) [7c591262](https://github.com/pgjdbc/pgjdbc/commit/7c591262792b8ff8f6139f67a98c16d41f2adf4f)
* Update prepare.md [PR 1601](https://github.com/pgjdbc/pgjdbc/pull/1601) [5e48eaa4](https://github.com/pgjdbc/pgjdbc/commit/5e48eaa4c9f6fc07904944bd98ad45fbb4aefd10)
* fix: issue 716 getTypeInfo() may not return data in the order specified in Oracle documentation [PR 1506](https://github.com/pgjdbc/pgjdbc/pull/1506) [9b8a3ffd](https://github.com/pgjdbc/pgjdbc/commit/9b8a3ffd8a952a55be28d14cb80a23fdbb955133)
* chore: Document how to use unix domain sockets.  [PR 1607](https://github.com/pgjdbc/pgjdbc/pull/1607) [e64b0a2d](https://github.com/pgjdbc/pgjdbc/commit/e64b0a2df8dd5e94a24fbb2e2e197f6d7fed7d9a)
* fix: PgSQLXML setCharacterStream() results in null value  [PR 1608](https://github.com/pgjdbc/pgjdbc/pull/1608) [1e370263](https://github.com/pgjdbc/pgjdbc/commit/1e370263d2f59da04fd1f8fe55bb83afdc0a51dc)
* add test for table name with values in it [PR 1609](https://github.com/pgjdbc/pgjdbc/pull/1609) [47f756fa](https://github.com/pgjdbc/pgjdbc/commit/47f756fa926f7c78a7f55f030aadf7be82195e52)
* fix: get correct column length for simple domains [PR 1605](https://github.com/pgjdbc/pgjdbc/pull/1605) [8abf3161](https://github.com/pgjdbc/pgjdbc/commit/8abf3161d17fef3783c0c597e91c1fe455efc2e8)
* fix: NPE as a result of calling executeQuery twice on a statement fixes issue [PR 684](https://github.com/pgjdbc/pgjdbc/pull/684) (#1610) [00fa4485](https://github.com/pgjdbc/pgjdbc/commit/00fa448587532cc219977679bb8c573a1dcae11c)
* fix:handle numeric domain types [PR 1611](https://github.com/pgjdbc/pgjdbc/pull/1611) [7f1752a1](https://github.com/pgjdbc/pgjdbc/commit/7f1752a1f2853c88333b3ac75c2dc0212272b254)
* add checks for null results [PR 1616](https://github.com/pgjdbc/pgjdbc/pull/1616) [69320c7a](https://github.com/pgjdbc/pgjdbc/commit/69320c7a7dc065f44db5ddeec8143c606298b382)
* fix: pginterval to take iso8601 strings [PR 1612](https://github.com/pgjdbc/pgjdbc/pull/1612) [7b454355](https://github.com/pgjdbc/pgjdbc/commit/7b454355939aebd995b1b79598a1e945c168eb68)
* fix: remove currentTimeMillis from code, tests are OK [PR 1617](https://github.com/pgjdbc/pgjdbc/pull/1617) [ff4a66d2](https://github.com/pgjdbc/pgjdbc/commit/ff4a66d29d863cb4a6d2aecee2faec424f8d51d7)
* fix: NPE when calling setNull on a PreparedStatement with no parameters [PR 1620](https://github.com/pgjdbc/pgjdbc/pull/1620) [6899a43d](https://github.com/pgjdbc/pgjdbc/commit/6899a43dff735ab14a02bedea853266de768da50)
* doc: correct documentation about last applied message fixes [PR 760](https://github.com/pgjdbc/pgjdbc/pull/760) (#1621) [fdf898c7](https://github.com/pgjdbc/pgjdbc/commit/fdf898c781c00839210936d668d2341ca6c08406)
* docs: fix documentation about oids [PR 1624](https://github.com/pgjdbc/pgjdbc/pull/1624) [4edca517](https://github.com/pgjdbc/pgjdbc/commit/4edca517bfdc0bffb2141369394d611803b43523)
* fix: javadoc requires throws annotation [PR 1625](https://github.com/pgjdbc/pgjdbc/pull/1625) [4258e0d0](https://github.com/pgjdbc/pgjdbc/commit/4258e0d0cfdc50aaec3d31301fd793e221740bda)
* fix: Add pkcs12 key functionality [PR 1599](https://github.com/pgjdbc/pgjdbc/pull/1599) [82c2008f](https://github.com/pgjdbc/pgjdbc/commit/82c2008f83dd687e80b1e3acdeeb618dccc2fb5c)
* Actually test cleanSavePoints [PR 1509](https://github.com/pgjdbc/pgjdbc/pull/1509) [97d32caa](https://github.com/pgjdbc/pgjdbc/commit/97d32caad1f72c11d3e89ffaf16a17a22c6b9790)
* fix: DatabaseMetaData.getFunctions should not limit the search to the search_path if the schema is provided [PR 1633](https://github.com/pgjdbc/pgjdbc/pull/1633) [8106d3df](https://github.com/pgjdbc/pgjdbc/commit/8106d3df5c3f6ea3cbc3e621977df5542b182b56)
* feat: WIP Filter DatabaseMetaData using privileges for the user [PR 1630](https://github.com/pgjdbc/pgjdbc/pull/1630) [ec76bace](https://github.com/pgjdbc/pgjdbc/commit/ec76bace1d4e3c02a7bf235f726a6c6d7feb6ee3)
* new pr for release notes [PR 1640](https://github.com/pgjdbc/pgjdbc/pull/1640) [fa69e7e9](https://github.com/pgjdbc/pgjdbc/commit/fa69e7e951d6f7dc48a605ac1c44393645512aa3)
* Update [03fdf75d](https://github.com/pgjdbc/pgjdbc/commit/03fdf75d7b3be54aa6b47c37c1c7fbdf57bda4ab)
* use TestUtil to find path of certdir [PR 1643](https://github.com/pgjdbc/pgjdbc/pull/1643) [4a8a8544](https://github.com/pgjdbc/pgjdbc/commit/4a8a85445a739bc9bdaa9660f1d9b9a17d129267)
* fix: Unable to register out parameter Issue [PR 1646](https://github.com/pgjdbc/pgjdbc/pull/1646) (#1648) [ea2ca87c](https://github.com/pgjdbc/pgjdbc/commit/ea2ca87c326dfc793df133d6cf39777e3c8da177)
* remove more currentTimeMillis in order to get tests to be more reliable [PR 1647](https://github.com/pgjdbc/pgjdbc/pull/1647) [617f0487](https://github.com/pgjdbc/pgjdbc/commit/617f0487adddb6601e681e25006e5555bc644c3e)
* fix unstable test. Originally this would loop creating many statements, now it should timeout properly [PR 1650](https://github.com/pgjdbc/pgjdbc/pull/1650) [aaccf431](https://github.com/pgjdbc/pgjdbc/commit/aaccf431f444df80cfed7633a12bd77d63a4b1fc)
* fix: issue 1482 where the port was being added to the GSSAPI service name [PR 1651](https://github.com/pgjdbc/pgjdbc/pull/1651) [f7a55cf9](https://github.com/pgjdbc/pgjdbc/commit/f7a55cf90c3152c982169a896e5e80d3a89fff52)
* Update README to reflect version 42.2.9 [2972add8](https://github.com/pgjdbc/pgjdbc/commit/2972add8e47d747655585fc423ac75c609f21c11)
* be explicit about which JDK [PR 1672](https://github.com/pgjdbc/pgjdbc/pull/1672) [39c73a6a](https://github.com/pgjdbc/pgjdbc/commit/39c73a6ab292f3f41db4ac54d3eed3ea0651e2f5)
* fix: actually use milliseconds instead of microseconds for timeouts [PR 1653](https://github.com/pgjdbc/pgjdbc/pull/1653) [3dd5dff2](https://github.com/pgjdbc/pgjdbc/commit/3dd5dff2b095ed7665fbed386a7cbad7c3254fd1)
* fix: Issue [PR 1680](https://github.com/pgjdbc/pgjdbc/pull/1680) updating a boolean field requires special handling to set it to t or f instead of true or false (#1682) [c266b088](https://github.com/pgjdbc/pgjdbc/commit/c266b0885141f48912d7883ec17855c420641a72)
* add DatabaseMetaDataCacheTest to test suite to run it [PR 1685](https://github.com/pgjdbc/pgjdbc/pull/1685) [b21f474c](https://github.com/pgjdbc/pgjdbc/commit/b21f474c58f4be978310076d11bfaed6e8a8240f)
* fix: Fixes issue [PR 1592](https://github.com/pgjdbc/pgjdbc/pull/1592) where one thread is reading the copy and another thread closes the connection (#1594) [1191076c](https://github.com/pgjdbc/pgjdbc/commit/1191076c8141ce796d4bae9bb7e8bc955aae528a)

Dongming (1):

* Adjust the default port to 5432. [PR 1619](https://github.com/pgjdbc/pgjdbc/pull/1619) [9a193de7](https://github.com/pgjdbc/pgjdbc/commit/9a193de71d3e834a231f8f5027fb887e00e903d2)

Frane Roje (1):

* Fixing LocalTime rounding (losing precision) [PR 1570](https://github.com/pgjdbc/pgjdbc/pull/1570) [a7480d20](https://github.com/pgjdbc/pgjdbc/commit/a7480d20370fefa70c5df30a402b952d1216b63c)

GregN (2):

* feat: add new "escapeSyntaxCallMode" connection property [PR 1560](https://github.com/pgjdbc/pgjdbc/pull/1560) [d7559138](https://github.com/pgjdbc/pgjdbc/commit/d75591385538cd704a066c4ed026f767ce3784ab)
* fix: allow OUT parameter registration when using CallableStatement native CALL [PR 1561](https://github.com/pgjdbc/pgjdbc/pull/1561) [ed74670f](https://github.com/pgjdbc/pgjdbc/commit/ed74670fae932935a156eccfb4b1ff16758f5693)

Igor Volkov (1):

* Fix exception on PGCopyOutputStream.close() after endCopy() [PR 1574](https://github.com/pgjdbc/pgjdbc/pull/1574) (#1575) [539a0925](https://github.com/pgjdbc/pgjdbc/commit/539a09258f6009581785474fe5f15a46992ade6f)

IvyDev0 (1):

* fix: null pointer exception from PgResultSetMetaData when there's no column metadata [PR 1615](https://github.com/pgjdbc/pgjdbc/pull/1615) [08bd46bf](https://github.com/pgjdbc/pgjdbc/commit/08bd46bfccc9c9481650e4ee09c943ec78d77895)

Jorge Solorzano (1):

* feat: support for large update counts (JDBC 4.2) [PR 935](https://github.com/pgjdbc/pgjdbc/pull/935) [0888e935](https://github.com/pgjdbc/pgjdbc/commit/0888e9355ca065ac2eae4e3085442ffd54f6dec6)

Knut Wannheden (1):

* Fix Markdown formatting issue [PR 1576](https://github.com/pgjdbc/pgjdbc/pull/1576) [69edc0b8](https://github.com/pgjdbc/pgjdbc/commit/69edc0b8f0985465af0ba0ee258f6b2564240232)

Lőrinc Pap (1):

* feat: add caller push of binary data (rebase of [PR 953](https://github.com/pgjdbc/pgjdbc/pull/953) (#1659) [db228a4f](https://github.com/pgjdbc/pgjdbc/commit/db228a4ffd8b356a9028363b35b0eb9055ea53f0)

Mahmoud Bahaa (4):

* Add Binary Support for Oid.NUMERIC and Oid.NUMERIC_ARRAY [PR 1636](https://github.com/pgjdbc/pgjdbc/pull/1636) [c85b149d](https://github.com/pgjdbc/pgjdbc/commit/c85b149d68c30ede0559d4bff6bc616ec03b2517)
* Only allow binary transfer for those Oids that the pgjdbc currently supports [PR 1637](https://github.com/pgjdbc/pgjdbc/pull/1637) [ad83cb33](https://github.com/pgjdbc/pgjdbc/commit/ad83cb332058f0a891b89f47ceefb538cbf031db)
* Fix test case by changing executeQuery to execute [PR 1642](https://github.com/pgjdbc/pgjdbc/pull/1642) [1d47c3cc](https://github.com/pgjdbc/pgjdbc/commit/1d47c3cc7c8abe18b72012a1c0bb4bfb3b7b5dc7)
* fix: remove receiving EOF from backend after cancel since according to protocol the server closes the connection once cancel is sent (connection reset exception is always thrown) [PR 1641](https://github.com/pgjdbc/pgjdbc/pull/1641) [23cce8ad](https://github.com/pgjdbc/pgjdbc/commit/23cce8ad35d9af6e2a1cb97fac69fdc0a7f94b42)

Michail Nikolaev (1):

* fix: do ssl handshake after socket timeout and buffer size settings [PR 1584](https://github.com/pgjdbc/pgjdbc/pull/1584) [e39a0be0](https://github.com/pgjdbc/pgjdbc/commit/e39a0be0739d016f524e7aef567f95e6ea59fd54)

Pavel Raiskup (1):

* rpm: drop BR on properties-maven-plugin [91186c08](https://github.com/pgjdbc/pgjdbc/commit/91186c08968f15b11b7338f1a565124abedcbfae)

Roman Ivanov (1):

* minor: fix checkstyle violation of unused import [PR 1683](https://github.com/pgjdbc/pgjdbc/pull/1683) [2ea7311e](https://github.com/pgjdbc/pgjdbc/commit/2ea7311e40b8611061766784401e727c4dd0ad32)

Russell Briggs (1):

* Fix Network Performance of PgDatabaseMetaData.getTypeInfo() method [PR 1668](https://github.com/pgjdbc/pgjdbc/pull/1668) [beb354eb](https://github.com/pgjdbc/pgjdbc/commit/beb354eb4dd8196c72b6fa7780187d9f7a491a6d)

Sehrope Sarkuni (7):

* Clean up some tests and fix IsValidTest race condition [PR 1581](https://github.com/pgjdbc/pgjdbc/pull/1581) [ad734574](https://github.com/pgjdbc/pgjdbc/commit/ad734574726eb0decf5178071c87a1b513e484f2)
* Fix test suite order [PR 1593](https://github.com/pgjdbc/pgjdbc/pull/1593) [003ea835](https://github.com/pgjdbc/pgjdbc/commit/003ea8352dab2b49b4734cdf7338befb4d9b9ed4)
* fix: Update error message for COPY commands executed using JDBC API [PR 1300](https://github.com/pgjdbc/pgjdbc/pull/1300) [c99ed121](https://github.com/pgjdbc/pgjdbc/commit/c99ed1213410872915930bea4471df6b1bdc503e)
* Add connection property to limit server error detail in exception exceptions [PR 1579](https://github.com/pgjdbc/pgjdbc/pull/1579) [cd0b555c](https://github.com/pgjdbc/pgjdbc/commit/cd0b555c8045fc71e6f4d0fb0f24a2deb726301e)
* feat: Add cancelQuery() to PGConnection public interface [PR 1157](https://github.com/pgjdbc/pgjdbc/pull/1157) [f0af538f](https://github.com/pgjdbc/pgjdbc/commit/f0af538f59924fd9d692627102c94517e5f6008e)
* Add disallow multiple empty lines [PR 1427](https://github.com/pgjdbc/pgjdbc/pull/1427) [be5c9f43](https://github.com/pgjdbc/pgjdbc/commit/be5c9f434c3ce68b9140f3ff929023e69cb2f984)
* Cleanup PGProperty, sort values, and add some missing to docs [PR 1686](https://github.com/pgjdbc/pgjdbc/pull/1686) [47e366dd](https://github.com/pgjdbc/pgjdbc/commit/47e366ddfda40a136233bd79371cef8af001d38e)

Svein Baardsen (1):

* fix: [PR 1677](https://github.com/pgjdbc/pgjdbc/pull/1677) NumberFormatException when fetching PGInterval with small value (#1678) [e38868b2](https://github.com/pgjdbc/pgjdbc/commit/e38868b29cafa7e8a9a5db67adb5a67cc2b5f230)

Tom Eicher (1):

* fix: DataSources broken by connection failover urls [PR 1039](https://github.com/pgjdbc/pgjdbc/pull/1039) (#1457) [bd9485ef](https://github.com/pgjdbc/pgjdbc/commit/bd9485ef7b889ec7397b1e39f77f5d396f06ed05)

Torsten Brodbeck (1):

* fix camel case writing of 'cleanupSavepoints' [PR 1587](https://github.com/pgjdbc/pgjdbc/pull/1587) [0fd45353](https://github.com/pgjdbc/pgjdbc/commit/0fd45353e504ed7821af69c8053814918212b8d7)

Vladimir Sitnikov (1):

* style: use fixed checkstyle version so the build does not depend on user machine [d164cba2](https://github.com/pgjdbc/pgjdbc/commit/d164cba20e7df21d1ac060bdabff20f08fb8e7cf)

Yuriy Yudin (1):

* fix: add release save point into execute with batch [PR 1583](https://github.com/pgjdbc/pgjdbc/pull/1583) [504bb316](https://github.com/pgjdbc/pgjdbc/commit/504bb316b91fdbc6506a2e9870453fb75fbbb083)

Zhenlei Huang (2):

* style: prepare for upcoming Checkstyle release 8.28 [PR 1654](https://github.com/pgjdbc/pgjdbc/pull/1654) [0b60c626](https://github.com/pgjdbc/pgjdbc/commit/0b60c62672eac051f2d2696b96de028623afe69c)
* chore: upgrade checkstyle to 8.28 [PR 1660](https://github.com/pgjdbc/pgjdbc/pull/1660) [63316802](https://github.com/pgjdbc/pgjdbc/commit/6331680298db5e65503c31bc89c000111675a8ea)

adrklos (1):

* feat: Add maxResultBuffer property [PR 1657](https://github.com/pgjdbc/pgjdbc/pull/1657) [557e2de4](https://github.com/pgjdbc/pgjdbc/commit/557e2de462b0f52ddc0b151971a9aa6e2d553622)

bjanczak (1):

* Metadata queries improvements. [PR 1673](https://github.com/pgjdbc/pgjdbc/pull/1673) [c574147a](https://github.com/pgjdbc/pgjdbc/commit/c574147af450fdac4a222dceef21991a67235396)

draderaws (2):

* Stored procedure with transaction control test case and doc. [PR 1645](https://github.com/pgjdbc/pgjdbc/pull/1645) [d10ab8d6](https://github.com/pgjdbc/pgjdbc/commit/d10ab8d68229b691d9492c942d2cb9183ee9fe32)
* sync error message value with tested value [PR 1664](https://github.com/pgjdbc/pgjdbc/pull/1664) [91d422d6](https://github.com/pgjdbc/pgjdbc/commit/91d422d6fd7976fa740295bb398fbfd79cb01c65)

hyunkshinft (1):

* fix testSetNetworkTimeoutEnforcement test failure [PR 1681](https://github.com/pgjdbc/pgjdbc/pull/1681) [799e78d5](https://github.com/pgjdbc/pgjdbc/commit/799e78d578573bd520ff04c6bd72a97c50cb984d)

reibitto (1):

* Fix interval overflow [PR 1658](https://github.com/pgjdbc/pgjdbc/pull/1658) [a44ab4be](https://github.com/pgjdbc/pgjdbc/commit/a44ab4becd9e5c198bfbce84fc87da6d01e5f25a)

rnveach (1):

* upgrade maven-checkstyle-plugin to 3.1.0 [PR 1573](https://github.com/pgjdbc/pgjdbc/pull/1573) [831115c1](https://github.com/pgjdbc/pgjdbc/commit/831115c1e8ede27d6a0434022b11edab7082721a)

Árpád Magosányi (2):

* fix documentation on generating the pk8 key. closes: [PR 1585](https://github.com/pgjdbc/pgjdbc/pull/1585) (#1586) [635cc865](https://github.com/pgjdbc/pgjdbc/commit/635cc86562aebc223dcc0d163639c5039a6b54c0)
* security notice and clarifications on choosing the right cipher suite for client key [PR 1591](https://github.com/pgjdbc/pgjdbc/pull/1591) [c67b0b0b](https://github.com/pgjdbc/pgjdbc/commit/c67b0b0b667a6b9f1b13ed5359687f3bc20ac61b)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[adrklos](https://github.com/adrklos)  
[Árpád Magosányi](https://github.com/magwas)  
[bjanczak](https://github.com/bjanczak)  
[Brett Okken](https://github.com/bokken)  
[Craig Ringer](https://github.com/ringerc)  
[Dave Cramer](davec@postgresintl.com)  
[Dongming](https://github.com/Dongming)  
[draderaws](https://github.com/draderaws)
[Frane Roje](https://github.com/franetw)  
[GregN](https://github.com/gregn123  
[hyunkshinft](https://github.com/hyunkshinft)  
[Igor Volkov](https://github.com/virtual-machinist)  
[IvyDev0](https://github.com/IvyDev0)  
[Jorge Solorzano](https://github.com/jorsol)  
Knut Wannheden  
[Lőrinc Pap](https://github.com/paplorinc)  
[Mahmoud Bahaa](https://github.com/mahmoudbahaa)  
[Michail Nikolaev](https://github.com/michail-nikolaev)  
[Pavel Raiskup](https://github.com/praiskup)  
[reibitto](https://github.com/reibitto)  
[rnveach](https://github.com/rnveach)  
[Roman Ivanov](https://github.com/romani)  
[Russell Briggs](https://github.com/dupski)  
[Sehrope Sarkuni](https://github.com/sehrope)  
Svein Baardsen  
[Tom Eicher](https://github.com/teicher)  
[Torsten Brodbeck](https://github.com/tbrodbeck-adc)  
[Vladimir Sitnikov](https://github.com/vlsi)  
[Yuriy Yudin](https://github.com/junixar)
[Zhenlei Huang](https://github.com/gmshake)  
