# -*- coding: utf-8; mode: tcl; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- vim:fenc=utf-8:ft=tcl:et:sw=4:ts=4:sts=4
#
# This portgroup works around problems that occur on some systems with projects
# that use gnulib and have configure scripts generated by autoconf. If a
# configure script contains the strings gl_cv_func_getcwd_succeeds_beyond_4k or
# gl_cv_func_getcwd_path_max then this portgroup should be included in that
# portfile even if you don't see a problem on your system because your system
# may not be one of those affected. There are no options.

namespace eval gnulib {}

proc gnulib::setup {} {
    global os.platform os.major
    if {${os.platform} eq "darwin" && ${os.major} <= 9} {
        # Override configure tests that causes problems on older macOS.
        # https://trac.macports.org/ticket/62994
        configure.args-append \
            gl_cv_func_getcwd_path_max="yes, but with shorter paths" \
            gl_cv_func_getcwd_succeeds_beyond_4k=no
    }
}

port::register_callback gnulib::setup
