/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.util.concurrent.CopyOnWriteArrayList;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/** Thread safe implementation of a linked list of ChangeListeners. Use 
 * {@link #add(ChangeListener, ChangeListener)} to combine two 
 * <code>ChangeListener</code>s and {@link #remove(ChangeListener, ChangeListener)
 * to remove a <code>ChangeListener</code>. The thread safeness refers to adding and
 * removing of listeners while a changeEvent is broadcasted. Simultaneous remove and add
 * access lead to unspecified behavior. 
 *
 *  Created on Apr 30, 2004
 *  
 *  @depricated Use {@link CopyOnWriteArrayList} instead.
 */
@Deprecated
final public class ChangeEventMulticaster implements ChangeListener
{
	private final ChangeListener a, b;
	private ChangeEventMulticaster(ChangeListener a, ChangeListener b) {
		this.a = a; this.b = b;
	}

	private ChangeListener remove(ChangeListener oldl) {
		if(oldl == a)  return b;
		if(oldl == b)  return a;
		ChangeListener a2 = remove(a, oldl);
		ChangeListener b2 = remove(b, oldl);
		if(a2 == a && b2 == b) return this;
		return add(a2, b2);
	}

	/** This adds two <code>ChangeListener</code>s. The returned  <code>ChangeListener</code> will
	 * take care of propagating <code>ChangeEvent</code>s to both. In order to add more <code>ChangeListener</code>s
	 * call this method again on the result. 
	 * 
	 * @param a
	 * @param b
	 * @return the combined  <code>ChangeListener</code>
	 */
	public static ChangeListener add(ChangeListener a, ChangeListener b)
	{
		final ChangeListener result;
		if(a==null) result=b; else if(b==null) result=a;
		else result=new ChangeEventMulticaster(a, b);
		return result;
	}

	/** Removes a <code>ChangeListener</code> from the list of <code>ChangeListener</code>s 
	 * obtained via {@link #add(ChangeListener, ChangeListener)} or {@link #remove(ChangeListener, ChangeListener)}. 
	 * 
	 * @param l a <code>ChangeListener</code> which was obtained by {@link #add(ChangeListener, ChangeListener)}
	 *   or {@link #remove(ChangeListener, ChangeListener)}.
	 * @param oldl the <code>ChangeListener</code> to be removed from <code>l</code>
	 * @return a (possibly new) reference to a <code>ChangeListener</code> that will 
	 * take care of propagating <code>ChangeEvent</code>s to the remaining <code>ChangeListener</code>s
	 */
	public static ChangeListener remove(ChangeListener l, ChangeListener oldl)
	{
		final ChangeListener result;
		if(l==oldl||l==null) result=null;
		else if(l instanceof ChangeEventMulticaster)
			result=((ChangeEventMulticaster)l).remove(oldl);
		else result=l;
		return result;
	}
	
	/* (non-Javadoc)
	 * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
	 */
	public void stateChanged(ChangeEvent arg0) {
		a.stateChanged(arg0); b.stateChanged(arg0);
	}
}
