/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.management;

import de.smrj.ClientFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Local {
    static boolean broadcast = true;
    static String[] clients;
    static int[] clientPorts;
    static String broadcastInetAddress;
    static int broadcastPort;

    public static void send(String message) throws IOException {
        if (broadcast) {
            DatagramSocket socket = new DatagramSocket(broadcastPort);
            InetAddress group = InetAddress.getByName(broadcastInetAddress);
            byte[] bm = message.getBytes();
            byte[] buf = new byte[bm.length + 4];
            ByteBuffer bb = ByteBuffer.wrap(buf);
            bb.asIntBuffer().put(bm.length);
            System.arraycopy(bm, 0, buf, 4, bm.length);
            if (buf.length > 256) {
                throw new IllegalArgumentException("message too long");
            }
            DatagramPacket packet = new DatagramPacket(buf, buf.length, group, 4446);
            socket.send(packet);
            socket.close();
            Logger.getLogger("SMRJ").log(Level.FINE, "sent: " + message);
        } else {
            for (int i = 0; i < clients.length; ++i) {
                String client = clients[i];
                int port = clientPorts[i];
                Socket socket = new Socket(client, port);
                PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String line = in.readLine();
                if (!line.equals("Ready.")) {
                    throw new IllegalStateException(client + ": unexpected response: " + line);
                }
                out.println(message);
                line = in.readLine();
                if (line.equals("OK")) continue;
                throw new IllegalStateException(client + ": unexpected confirmation: " + line);
            }
        }
    }

    public static void sendStop() throws IOException {
        Local.send("shutdown");
    }

    public static void sendStart(int port, int cpPort, Class<? extends ClientFactory> cfType) throws IOException {
        Local.sendStart(port, cpPort, 1, cfType);
    }

    public static void sendStart(int port, int cpPort, int responseType, Class<? extends ClientFactory> cfType) throws IOException {
        String hostName = System.getProperty("de.smrj.tcp.host", InetAddress.getLocalHost().getHostName());
        Local.send("new-connection: " + hostName + " " + port);
        Local.send("response-type: " + responseType);
        Local.send("cp-server: " + hostName + " " + cpPort);
        URLClassLoader ucl = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        for (URL url : ucl.getURLs()) {
            Local.send("cp-element: " + url.getFile());
        }
        Local.send("do-connect: " + cfType.getName());
    }

    public static void sendStart(int port, int cpPort, int responseType, Class<? extends ClientFactory> cfType, String clientHostName) throws IOException {
        String hostName = System.getProperty("de.smrj.tcp.host", InetAddress.getLocalHost().getHostName());
        Local.send("new-connection: " + hostName + " " + port + " " + clientHostName);
        Local.send("response-type: " + responseType);
        Local.send("cp-server: " + hostName + " " + cpPort);
        URLClassLoader ucl = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        for (URL url : ucl.getURLs()) {
            Local.send("cp-element: " + url.getFile());
        }
        Local.send("do-connect: " + cfType.getName());
    }

    static {
        broadcastInetAddress = "230.0.0.1";
        broadcastPort = 4445;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    Logger.getLogger("SMRJ").log(Level.INFO, "SHUTDOWN HOOK: sending shutdown");
                    Local.send("shutdown");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        String clientProp = System.getProperty("de.smrj.clients");
        if (clientProp != null) {
            broadcast = false;
            String clientPortProp = System.getProperty("de.smrj.clients.port", "4446");
            int clientPort = Integer.parseInt(clientPortProp);
            String[] clientNames = clientProp.split(" ");
            int numClients = clientNames.length;
            clients = new String[numClients];
            clientPorts = new int[numClients];
            for (int i = 0; i < numClients; ++i) {
                String[] cl = clientNames[i].split(":");
                Local.clients[i] = cl[0];
                Local.clientPorts[i] = cl.length > 1 ? Integer.parseInt(cl[1]) : clientPort;
            }
            String clientSysout = "Clients: \n";
            for (int i = 0; i < clientNames.length; ++i) {
                clientSysout = clientSysout + "\t" + clients[i] + ":" + clientPorts[i] + "\n";
            }
            Logger.getLogger("SMRJ").log(Level.INFO, clientSysout);
        } else {
            Logger.getLogger("SMRJ").log(Level.INFO, "broadcasting for clients at " + broadcastInetAddress + ":" + broadcastPort);
        }
    }
}

