/*
 * Decompiled with CFR 0.152.
 */
package de.smrj;

import de.smrj.Receiver;
import de.smrj.RemoteCall;
import de.smrj.RemoteKey;
import de.smrj.RemoteThrowable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientFactory {
    private static final Logger log = Logger.getLogger("SMRJ");
    private final HashMap<RemoteKey, Object> keyToLocal = new HashMap();
    private final HashMap<Object, RemoteKey> localToKey = new HashMap();
    private Receiver receiver;
    private Set<ResetCallback> resetCallbacks = new HashSet<ResetCallback>();

    public void gc(Object[] localObjects) {
        for (Object o : localObjects) {
            RemoteKey key = this.localToKey.remove(o);
            assert (this.keyToLocal.remove(key) != null);
        }
    }

    public ClientFactory() {
        this.keyToLocal.put(RemoteKey.CLIENT_FACTORY, this);
    }

    protected ClientFactory(Receiver r) {
        this();
        this.receiver = r;
    }

    void setReceiver(Receiver r) {
        this.receiver = r;
    }

    Object executeRemoteCall(RemoteCall rc) throws RemoteThrowable {
        this.preCall(rc);
        try {
            if (rc.isMethod()) {
                Object object = this.executeMethod(rc);
                return object;
            }
            if (rc.isConstructor()) {
                Object object = this.createObject(rc);
                return object;
            }
            if (rc.isStaticFactoryMethod()) {
                Object object = this.createObjectStaticFactory(rc);
                return object;
            }
            throw new IllegalArgumentException("unknown remote call type");
        }
        finally {
            this.postCall(rc);
        }
    }

    protected void postCall(RemoteCall rc) {
    }

    protected void preCall(RemoteCall rc) {
    }

    private Object executeMethod(RemoteCall rm) throws RemoteThrowable {
        Object local = rm.getObject();
        try {
            Method m = local.getClass().getMethod(rm.getName(), rm.getSignature());
            return m.invoke(local, rm.getParameters());
        }
        catch (InvocationTargetException ie) {
            log.info("exception thrown in method " + rm.getName() + "  " + ie.getCause());
            throw new RemoteThrowable(ie.getCause());
        }
        catch (Throwable e) {
            throw new RemoteThrowable(e);
        }
    }

    private Object createObject(RemoteCall rc) throws RemoteThrowable {
        try {
            Object[] params = rc.getParameters();
            Object instance = Class.forName(rc.getName()).getConstructor(rc.getSignature()).newInstance(params);
            this.registerNewObject(instance, rc.getKey());
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "exception thrown in method " + rc.getName(), t);
            throw new RemoteThrowable(t);
        }
        return null;
    }

    private Object createObjectStaticFactory(RemoteCall rc) throws RemoteThrowable {
        try {
            String str = rc.getName();
            int index = str.indexOf(64);
            Class<?> clazz = Class.forName(str.substring(0, index));
            Object instance = clazz.getMethod(str.substring(index + 1), rc.getSignature()).invoke(clazz, rc.getParameters());
            if (instance != null) {
                this.registerNewObject(instance, rc.getKey());
            }
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "exception thrown in method " + rc.getName(), t);
            throw new RemoteThrowable(t);
        }
        return null;
    }

    private void registerNewObject(Object instance, RemoteKey key) {
        this.keyToLocal.put(key, instance);
        this.localToKey.put(instance, key);
        if (instance instanceof ResetCallback) {
            log.log(Level.INFO, "registering disconnect callback" + instance.getClass().getName());
            this.resetCallbacks.add((ResetCallback)instance);
        }
    }

    public Object getLocal(RemoteKey key) {
        Object ret = this.keyToLocal.get(key);
        if (key == null) {
            throw new IllegalArgumentException("unknown key");
        }
        return ret;
    }

    public void dispose() {
        Logger.getLogger("SMRJ").log(Level.FINE, "ClientFactory.dispose()");
        this.receiver.stop();
        Iterator<ResetCallback> i = this.resetCallbacks.iterator();
        while (i.hasNext()) {
            i.next().resetCalled();
        }
        this.keyToLocal.clear();
        this.localToKey.clear();
    }

    public static interface ResetCallback {
        public void resetCalled();
    }
}

