/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.management;

import java.beans.Statement;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientEnvironment {
    private int port;
    private int cpPort;
    private String host;
    private String cpHost;
    private ArrayList<String> cpEntries = new ArrayList();
    private ArrayList<File> jars = new ArrayList();
    private Object receiver;
    private int responseType;
    private boolean inheritClasspath;

    public void setServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setCpServer(String host, int port) {
        this.cpHost = host;
        this.cpPort = port;
    }

    public void newCpEntry(String entryName) {
        this.cpEntries.add(entryName);
    }

    public void doConnect(String clientFactoryName) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Logger.getLogger("SMRJ").log(Level.INFO, "connecting to " + this.host + ":" + this.port + " with " + clientFactoryName);
        ClassLoader myCL = this.inheritClasspath ? Thread.currentThread().getContextClassLoader() : this.downloadClasses();
        Class<?> cfc = Class.forName(clientFactoryName, true, myCL);
        Thread.currentThread().setContextClassLoader(myCL);
        try {
            Class<?> recc = Class.forName("de.smrj.tcp.TCPReceiverIO", true, myCL);
            Constructor<?> cc = recc.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Class.forName("de.smrj.ClientFactory", true, myCL));
            this.receiver = cc.newInstance(this.host, this.port, this.responseType, cfc.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassLoader downloadClasses() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        byte[] BUF = new byte[2048];
        for (String cpEntryName : this.cpEntries) {
            int count;
            File f = new File(cpEntryName);
            URL url = new URL("http", this.cpHost, this.cpPort, cpEntryName + (f.exists() ? "?exists" : ""));
            Logger.getLogger("SMRJ").log(Level.FINE, "URL=" + url);
            URLConnection connection = null;
            int i = 0;
            while (true) {
                try {
                    connection = url.openConnection();
                }
                catch (ConnectException ce) {
                    Logger.getLogger("SMRJ").log(Level.FINE, "reconnect " + i);
                }
                if (connection != null) break;
                ++i;
            }
            if (connection == null) {
                throw new ConnectException();
            }
            BufferedInputStream bis = new BufferedInputStream(connection.getInputStream());
            FileOutputStream fos = null;
            if (!f.exists()) {
                File tmpFile = File.createTempFile(cpEntryName.replace(File.separatorChar, '_'), ".jar");
                tmpFile.deleteOnExit();
                this.jars.add(tmpFile);
                fos = new FileOutputStream(tmpFile);
                urls.add(tmpFile.toURI().toURL());
            } else {
                urls.add(f.toURI().toURL());
            }
            while ((count = bis.read(BUF, 0, BUF.length)) != -1) {
                if (fos == null) continue;
                fos.write(BUF, 0, count);
            }
            if (!f.exists()) {
                fos.flush();
                fos.close();
                Logger.getLogger("SMRJ").log(Level.FINE, "DOWNLOADED: " + cpEntryName);
                continue;
            }
            Logger.getLogger("SMRJ").log(Level.FINE, "USING LOCAL: " + cpEntryName);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    public void doShutdown() {
        if (this.receiver != null) {
            try {
                new Statement(this.receiver, "shutdown", null).execute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator<File> it = this.jars.iterator();
        while (it.hasNext()) {
            File jar = it.next();
            it.remove();
            jar.delete();
        }
    }

    public void setResponseType(int i) {
        this.responseType = i;
    }

    public boolean isInheritClasspath() {
        return this.inheritClasspath;
    }

    public void setInheritClasspath(boolean inheritClasspath) {
        this.inheritClasspath = inheritClasspath;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClientEnvironment env = new ClientEnvironment();
        env.setResponseType(2);
        env.setInheritClasspath(true);
        env.setServer(args[0], Integer.parseInt(args[1]));
        env.doConnect("de.smrj.ClientFactory");
    }
}

