/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcReq;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbTgsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private PrincipalName servName;
    private TGSReq tgsReqMessg;
    private KerberosTime ctime;
    private Ticket secondTicket = null;
    private boolean useSubkey = false;
    EncryptionKey tgsReqKey;
    private static final boolean DEBUG = Krb5.DEBUG;
    private int defaultTimeout = 30000;

    public KrbTgsReq(Credentials credentials, PrincipalName principalName) throws KrbException, IOException {
        this(new KDCOptions(), credentials, principalName, null, null, null, null, null, null, null, null);
    }

    KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket[] ticketArray, EncryptionKey encryptionKey) throws KrbException, IOException {
        this.princName = credentials.client;
        this.servName = principalName;
        this.ctime = new KerberosTime(true);
        if (kDCOptions.get(1) && !credentials.flags.get(1)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(2) && !credentials.flags.get(1)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(3) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(4) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(5) && !credentials.flags.get(5)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(8) && !credentials.flags.get(8)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(6)) {
            if (!credentials.flags.get(6)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime != null) {
            kerberosTime = null;
        }
        if (kDCOptions.get(8)) {
            if (!credentials.flags.get(8)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        if (kDCOptions.get(28)) {
            if (ticketArray == null) {
                throw new KrbException(101);
            }
            this.secondTicket = ticketArray[0];
        } else if (ticketArray != null) {
            ticketArray = null;
        }
        this.tgsReqMessg = this.createRequest(kDCOptions, credentials.ticket, credentials.key, this.ctime, this.princName, this.princName.getRealm(), this.servName, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, authorizationData, ticketArray, encryptionKey);
        this.obuf = this.tgsReqMessg.asn1Encode();
        if (credentials.flags.get(2)) {
            kDCOptions.set(2, true);
        }
    }

    public String send() throws IOException, KrbException {
        String string = null;
        if (this.servName != null) {
            string = this.servName.getRealmString();
        }
        return this.send(string);
    }

    public KrbTgsRep getReply() throws KrbException, IOException {
        return new KrbTgsRep(this.ibuf, this);
    }

    KerberosTime getCtime() {
        return this.ctime;
    }

    private TGSReq createRequest(KDCOptions kDCOptions, Ticket ticket, EncryptionKey encryptionKey, KerberosTime kerberosTime, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket[] ticketArray, EncryptionKey encryptionKey2) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, UnknownHostException, KrbCryptoException {
        Checksum checksum;
        Object object;
        KerberosTime kerberosTime5 = null;
        kerberosTime5 = kerberosTime3 == null ? new KerberosTime() : kerberosTime3;
        this.tgsReqKey = encryptionKey;
        int[] nArray2 = null;
        if (nArray == null) {
            nArray2 = EType.getDefaults("default_tgs_enctypes");
            if (nArray2 == null) {
                throw new KrbCryptoException("No supported encryption types listed in default_tgs_enctypes");
            }
        } else {
            nArray2 = nArray;
        }
        EncryptionKey encryptionKey3 = null;
        EncryptedData encryptedData = null;
        if (authorizationData != null) {
            object = authorizationData.asn1Encode();
            if (encryptionKey2 != null) {
                encryptionKey3 = encryptionKey2;
                this.tgsReqKey = encryptionKey2;
                this.useSubkey = true;
                encryptedData = new EncryptedData(encryptionKey3, (byte[])object, 5);
            } else {
                encryptedData = new EncryptedData(encryptionKey, (byte[])object, 4);
            }
        }
        object = new KDCReqBody(kDCOptions, principalName, principalName2.getRealm(), principalName2, kerberosTime2, kerberosTime5, kerberosTime4, Nonce.value(), nArray2, hostAddresses, encryptedData, ticketArray);
        byte[] byArray = ((KDCReqBody)object).asn1Encode(12);
        switch (Checksum.CKSUMTYPE_DEFAULT) {
            case -138: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                checksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, byArray, encryptionKey, 6);
                break;
            }
            default: {
                checksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, byArray);
            }
        }
        byte[] byArray2 = new KrbApReq(new APOptions(), ticket, encryptionKey, realm, principalName, checksum, kerberosTime, encryptionKey3, null, null).getMessage();
        PAData[] pADataArray = new PAData[]{new PAData(1, byArray2)};
        return new TGSReq(pADataArray, (KDCReqBody)object);
    }

    TGSReq getMessage() {
        return this.tgsReqMessg;
    }

    Ticket getSecondTicket() {
        return this.secondTicket;
    }

    private static void debug(String string) {
    }

    boolean usedSubkey() {
        return this.useSubkey;
    }
}

