/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.sidecontainer.widget;

import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkPanel;
import de.jtem.jrworkspace.plugin.sidecontainer.widget.ShrinkSlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class ShrinkSlotVertical
extends ShrinkSlot
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    protected JPanel content = new JPanel();
    protected JScrollPane scroller = new JScrollPane(21, 31);
    protected List<ShrinkPanel> panels = new LinkedList<ShrinkPanel>();
    private Map<ShrinkPanel, Integer> positionMap = new HashMap<ShrinkPanel, Integer>();
    private GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints normalConstraints = new GridBagConstraints();
    protected GridBagConstraints fillConstraints = new GridBagConstraints();
    private JPanel fillPanel = new JPanel();
    private int lastDrag = 0;
    private boolean showInsertHint = false;
    private Point insertHintPoint = new Point();
    private int width = 200;

    public ShrinkSlotVertical(int width) {
        this.width = width;
        this.content.setLayout(this.gbl);
        this.fillConstraints.fill = 1;
        this.fillConstraints.gridheight = 1;
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.normalConstraints.fill = 1;
        this.normalConstraints.gridheight = 1;
        this.normalConstraints.gridwidth = 0;
        this.normalConstraints.weightx = 1.0;
        this.normalConstraints.weighty = 0.0;
        this.scroller.setViewportView(this.content);
        this.scroller.setBorder(BorderFactory.createEmptyBorder());
        this.scroller.addMouseWheelListener(this);
        this.setLayout(new GridLayout());
        super.add(this.scroller);
        this.updateLayout();
    }

    protected void updateLayout() {
        this.content.removeAll();
        boolean fillerNeeded = true;
        for (ShrinkPanel sp : this.panels) {
            if (sp.isFillSpace()) {
                if (sp.isShrinked()) {
                    this.content.add((Component)sp, this.normalConstraints);
                    continue;
                }
                fillerNeeded = false;
                this.content.add((Component)sp, this.fillConstraints);
                continue;
            }
            this.content.add((Component)sp, this.normalConstraints);
        }
        if (fillerNeeded) {
            this.content.add((Component)this.fillPanel, this.fillConstraints);
        }
        if (this.panels.size() == 0) {
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        } else {
            this.setPreferredSize(null);
            this.setMinimumSize(new Dimension(this.width, 10));
        }
        this.content.doLayout();
        this.revalidate();
        this.updateUI();
    }

    @Override
    public Component add(Component arg0) {
        throw new UnsupportedOperationException("Use addShrinkPanel()");
    }

    @Override
    public void addShrinkPanel(ShrinkPanel panel) {
        this.addShrinkPanelAt(panel, panel.getPreferredPosition());
    }

    @Override
    public void addShrinkPanelAt(ShrinkPanel panel, Point p) {
        int scroll = this.scroller.getVerticalScrollBar().getValue();
        Point scrollPoint = new Point(p.x, p.y + scroll);
        Component c = this.content.getComponentAt(scrollPoint);
        if (c instanceof ShrinkPanel) {
            this.addShrinkPanelAt(panel, this.positionMap.get(c));
        } else {
            TreeSet<Integer> posSet = new TreeSet<Integer>(this.positionMap.values());
            if (posSet.size() != 0) {
                this.addShrinkPanelAt(panel, posSet.last() + 1);
            } else {
                this.addShrinkPanelAt(panel, 0);
            }
        }
        this.positionMap.clear();
        for (ShrinkPanel pl : this.panels) {
            this.positionMap.put(pl, this.panels.lastIndexOf(pl));
        }
    }

    protected void addShrinkPanelAt(ShrinkPanel p, int pos) {
        ShrinkPanel panel;
        Collection<Integer> occupied = this.positionMap.values();
        if (occupied.contains(pos)) {
            LinkedList<ShrinkPanel> panelList = new LinkedList<ShrinkPanel>(this.positionMap.keySet());
            for (ShrinkPanel panel2 : panelList) {
                int panelPos = this.positionMap.get(panel2);
                if (panelPos < pos) continue;
                this.positionMap.remove(panel2);
                this.positionMap.put(panel2, panelPos + 1);
                panel2.setPreferredPosition(panelPos + 1);
            }
        }
        this.positionMap.put(p, pos);
        p.setPreferredPosition(pos);
        TreeSet<Integer> posSet = new TreeSet<Integer>(this.positionMap.values());
        ShrinkPanel[] panelArray = new ShrinkPanel[posSet.last() + 1];
        Iterator<ShrinkPanel> iterator = this.positionMap.keySet().iterator();
        while (iterator.hasNext()) {
            panelArray[this.positionMap.get((Object)panel).intValue()] = panel = iterator.next();
        }
        this.panels.clear();
        ShrinkPanel[] shrinkPanelArray = panelArray;
        int n = panelArray.length;
        int n2 = 0;
        while (n2 < n) {
            panel = shrinkPanelArray[n2];
            if (panel != null) {
                this.panels.add(panel);
            }
            ++n2;
        }
        this.updateMouseListeners(p);
        p.setParentSlot(this);
        this.updateLayout();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeShrinkPanel(ShrinkPanel panel) {
        this.content.remove(panel);
        this.panels.remove(panel);
        this.positionMap.remove(panel);
        this.removeMouseListeners(panel);
        this.updateLayout();
        this.revalidate();
    }

    private void updateMouseListeners(Container container) {
        if (container instanceof JScrollPane) {
            return;
        }
        container.removeMouseListener(this);
        container.removeMouseMotionListener(this);
        container.removeMouseWheelListener(this);
        container.addMouseListener(this);
        container.addMouseMotionListener(this);
        container.addMouseWheelListener(this);
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                this.updateMouseListeners((Container)c);
            }
            ++n2;
        }
    }

    private void removeMouseListeners(Container container) {
        container.removeMouseWheelListener(this);
        container.removeMouseMotionListener(this);
        container.removeMouseListener(this);
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                this.removeMouseListeners((Container)c);
            }
            ++n2;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        JScrollBar vert = this.scroller.getVerticalScrollBar();
        int schroll_pos = vert.getValue();
        vert.setValue(schroll_pos - (e.getY() - this.lastDrag));
        this.lastDrag = e.getY() - (e.getY() - this.lastDrag);
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.lastDrag = arg0.getY();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent m) {
        int dx = -m.getUnitsToScroll() * 5;
        JScrollBar vert = this.scroller.getVerticalScrollBar();
        int schroll_pos = vert.getValue();
        vert.setValue(schroll_pos - dx);
        this.lastDrag = dx;
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.scroller.setBorder(null);
        super.paintChildren(g);
    }

    @Override
    public void showInsertHint(boolean show, Point p) {
        this.showInsertHint = show;
        this.insertHintPoint = p;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.showInsertHint) {
            Dimension size = this.getSize();
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            int scroll = this.scroller.getVerticalScrollBar().getValue();
            Point scrollPoint = new Point(this.insertHintPoint.x, this.insertHintPoint.y + scroll);
            Component c = this.content.getComponentAt(scrollPoint);
            if (c != null) {
                Rectangle r = c.getBounds();
                int hint = Math.max(r.y + 1 - scroll, 0);
                g.draw3DRect(0, hint, this.getSize().width, 2, false);
            }
        }
    }

    public int getPreferredWidth() {
        return this.width;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.fillPanel != null) {
            this.fillPanel.updateUI();
        }
    }
}

