/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import vrpn.VRPN;

public abstract class VRPNDevice
extends VRPN
implements Runnable {
    public static final int vrpn_TEXT_NORMAL = 0;
    public static final int vrpn_TEXT_WARNING = 1;
    public static final int vrpn_TEXT_ERROR = 2;
    public static final Date vrpn_TEXT_NOW = new Date(0L);
    protected long native_device = -1L;
    protected boolean keepRunning = true;
    Thread deviceThread = null;
    protected long mainloopPeriod = 100L;
    protected String connectionName = null;
    protected String localInLogfileName = null;
    protected String localOutLogfileName = null;
    protected String remoteInLogfileName = null;
    protected String remoteOutLogfileName = null;
    protected boolean liveReplayValid = false;
    protected boolean replay = false;
    protected boolean earliestTimeValid = false;
    protected Date earliestTime = new Date();
    protected boolean latestTimeValid = false;
    protected Date latestTime = new Date();

    public static String getTextSeverityString(int severity) {
        switch (severity) {
            case 0: {
                return "vrpn_TEXT_NORMAL";
            }
            case 1: {
                return "vrpn_TEXT_WARNING";
            }
            case 2: {
                return "vrpn_TEXT_ERROR";
            }
        }
        return "(unknown severity)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VRPNDevice(String name, String localInLogfileName, String localOutLogfileName, String remoteInLogfileName, String remoteOutLogfileName) throws InstantiationException {
        this.connectionName = name;
        this.localInLogfileName = localInLogfileName;
        this.localOutLogfileName = localOutLogfileName;
        this.remoteInLogfileName = remoteInLogfileName;
        this.remoteOutLogfileName = remoteOutLogfileName;
        try {
            Object object = downInVrpnLock;
            synchronized (object) {
                this.init(name, localInLogfileName, localOutLogfileName, remoteInLogfileName, remoteOutLogfileName);
            }
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Error initializing remote device " + name + ".");
            System.out.println(" -- Unable to find the right functions.  This may be a version problem.");
            throw new InstantiationException(e.getMessage());
        }
        this.deviceThread = new Thread((Runnable)this, "vrpn " + this.getClass().getName());
        this.deviceThread.start();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getLocalInLogfileName() {
        return this.localInLogfileName;
    }

    public String getLocalOutLogfileName() {
        return this.localOutLogfileName;
    }

    public String getRemoteInLogfileName() {
        return this.remoteInLogfileName;
    }

    public String getRemoteOutLogfileName() {
        return this.remoteOutLogfileName;
    }

    public final synchronized void setTimerPeriod(long period) {
        this.mainloopPeriod = period;
    }

    public final synchronized long getTimerPeriod() {
        return this.mainloopPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doingOkay() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.doingOkay_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.isConnected_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLive() {
        if (this.liveReplayValid) {
            return !this.replay;
        }
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.isLive_native();
        }
        this.replay = !retval;
        return retval;
    }

    public final boolean isReplay() {
        return !this.isLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getElapsedTimeSecs() {
        long retval = 0L;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.getElapsedTimeSecs_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getTime() {
        Date d = new Date(0L);
        Object object = downInVrpnLock;
        synchronized (object) {
            this.getTime_native(d);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReplayRate(float rate) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setReplayRate_native(rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reset() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.reset_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean eof() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.eof_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean playToElapsedTime(long seconds) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.playToElapsedTime_native(seconds);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean playToWallTime(Date date) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        boolean retval = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.playToWallTime_native(date);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getLengthSecs() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        double retval = -1.0;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.getLengthSecs_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getReplayRate() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        float retval = -1.0f;
        Object object = downInVrpnLock;
        synchronized (object) {
            retval = this.getReplayRate_native();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getEarliestTime() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        if (!this.earliestTimeValid) {
            Object object = downInVrpnLock;
            synchronized (object) {
                boolean success = this.getEarliestTime_native(this.earliestTime);
                if (!success) {
                    this.earliestTime.setTime(0L);
                } else {
                    this.earliestTimeValid = true;
                }
            }
        }
        return this.earliestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getLatestTime() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError("a live device");
        }
        if (!this.latestTimeValid) {
            Object object = downInVrpnLock;
            synchronized (object) {
                boolean success = this.getLatestTime_native(this.latestTime);
                if (!success) {
                    this.latestTime.setTime(0L);
                } else {
                    this.latestTimeValid = true;
                }
            }
        }
        return this.latestTime;
    }

    public final void stopRunning() {
        this.keepRunning = false;
        while (this.deviceThread.isAlive()) {
            try {
                this.deviceThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stoppedRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (this.keepRunning) {
            Object object = downInVrpnLock;
            synchronized (object) {
                this.mainloop();
            }
            try {
                Thread.sleep(this.mainloopPeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final void finalize() throws Throwable {
        this.stopRunning();
    }

    protected native boolean isLive_native();

    protected native boolean doingOkay_native();

    protected native boolean isConnected_native();

    protected native long getElapsedTimeSecs_native();

    protected native void setReplayRate_native(float var1);

    protected native float getReplayRate_native();

    protected native boolean reset_native();

    protected native boolean eof_native();

    protected native boolean playToElapsedTime_native(long var1);

    protected native boolean playToWallTime_native(Date var1);

    protected native double getLengthSecs_native();

    protected native boolean getEarliestTime_native(Date var1);

    protected native boolean getLatestTime_native(Date var1);

    protected native boolean getTime_native(Date var1);

    protected abstract void mainloop();

    protected abstract boolean init(String var1, String var2, String var3, String var4, String var5);

    protected abstract void stoppedRunning();

    private VRPNDevice() {
    }

    public class NotReplayError
    extends Exception {
        public NotReplayError(String msg) {
            super(msg);
        }
    }
}

