/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.latticeReduction;

public class LLL {
    private static final double EPS = 1.0E-13;
    static int dim = 0;
    static double[][] A;
    static double[][] mu;
    static double[] a;

    private static void setDimension(int n) {
        if (n != dim) {
            dim = n;
            A = new double[dim][dim];
            mu = new double[dim][dim];
            a = new double[dim];
        }
    }

    private static void initLLL(double[][] B, int[][] U, double[][] U_, double[][] mu, double[] a) {
        int j;
        int i;
        int n = B.length;
        if (U != null) {
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    U[i][j] = i == j ? 1 : 0;
                    ++j;
                }
                ++i;
            }
        }
        if (U_ != null) {
            i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    U_[i][j] = i == j ? 1 : 0;
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                LLL.A[i][j] = B[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j < i) {
                double d = LLL.dot(B[i], A[j]) / a[j];
                mu[i][j] = d;
                double t = d;
                int k = 0;
                while (k < n) {
                    double[] dArray = A[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - t * A[j][k];
                    ++k;
                }
                ++j;
            }
            a[i] = LLL.dot(A[i], A[i]);
            ++i;
        }
    }

    public static void reduce(double[][] B) {
        LLL.reduce(B, null, null, 0.75);
    }

    public static void reduce(double[][] B, int[][] U) {
        LLL.reduce(B, U, null, 0.75);
    }

    public static void reduce(double[][] B, double[][] U) {
        LLL.reduce(B, null, U, 0.75);
    }

    public static void reduce(double[][] B, int[][] U, double[][] U_, double c) {
        if (c < 0.25 || c > 1.0) {
            throw new IllegalArgumentException("constant is not in [1/4,1]");
        }
        int n = B.length;
        LLL.setDimension(n);
        LLL.initLLL(B, U, U_, mu, a);
        if (n < 2) {
            return;
        }
        int k = 1;
        while (true) {
            LLL.transform(B, U, U_, mu, k, k - 1);
            if (a[k] + 1.0E-13 < (c - mu[k][k - 1] * mu[k][k - 1]) * a[k - 1]) {
                LLL.swap(B, U, U_, mu, a, k);
                if (k <= 1) continue;
                --k;
                continue;
            }
            int l = k - 2;
            while (l >= 0) {
                LLL.transform(B, U, U_, mu, k, l);
                --l;
            }
            if (++k == n) break;
        }
    }

    private static void swap(double[][] B, int[][] U, double[][] U_, double[][] mu, double[] a, int k) {
        int n = B.length;
        double MU = mu[k][k - 1];
        double tmp = a[k] + MU * MU * a[k - 1];
        double[] dArray = mu[k];
        int n2 = k - 1;
        dArray[n2] = dArray[n2] * (a[k - 1] / tmp);
        int n3 = k;
        a[n3] = a[n3] * (a[k - 1] / tmp);
        a[k - 1] = tmp;
        LLL.swap(B, k, k - 1);
        if (U != null) {
            LLL.swap(U, k, k - 1);
        }
        if (U_ != null) {
            LLL.swap(U_, k, k - 1);
        }
        int j = 0;
        while (j < k - 1) {
            tmp = mu[k - 1][j];
            mu[k - 1][j] = mu[k][j];
            mu[k][j] = tmp;
            ++j;
        }
        int i = k + 1;
        while (i < n) {
            double t1;
            double t2 = mu[i][k - 1] - MU * mu[i][k];
            mu[i][k - 1] = t1 = mu[i][k] + t2 * mu[k][k - 1];
            mu[i][k] = t2;
            ++i;
        }
    }

    private static void transform(double[][] B, int[][] U, double[][] U_, double[][] mu, int k, int l) {
        if (Math.abs(mu[k][l]) > 0.5) {
            int r = (int)Math.floor(mu[k][l] + 0.5);
            int n = B.length;
            int i = 0;
            while (i < n) {
                double[] dArray = B[k];
                int n2 = i;
                dArray[n2] = dArray[n2] - (double)r * B[l][i];
                if (U != null) {
                    int[] nArray = U[k];
                    int n3 = i;
                    nArray[n3] = nArray[n3] - r * U[l][i];
                }
                if (U_ != null) {
                    double[] dArray2 = U_[k];
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] - (double)r * U_[l][i];
                }
                ++i;
            }
            int j = 0;
            while (j < l) {
                double[] dArray = mu[k];
                int n5 = j;
                dArray[n5] = dArray[n5] - (double)r * mu[l][j];
                ++j;
            }
            double[] dArray = mu[k];
            int n6 = l;
            dArray[n6] = dArray[n6] - (double)r;
        }
    }

    private static double dot(double[] a, double[] b) {
        double result = 0.0;
        int i = 0;
        while (i < a.length) {
            result += a[i] * b[i];
            ++i;
        }
        return result;
    }

    private static void swap(double[][] a, int k, int l) {
        double[] tmp = a[k];
        a[k] = a[l];
        a[l] = tmp;
    }

    private static void swap(int[][] a, int k, int l) {
        int[] tmp = a[k];
        a[k] = a[l];
        a[l] = tmp;
    }

    private static void print(double[] a, String name) {
        System.out.print(name);
        int i = 0;
        while (i < a.length) {
            System.out.print("  " + a[i]);
            ++i;
        }
        System.out.println("  ");
    }
}

