/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.DebugHelper;
import sun.awt.DisplayChangedListener;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WGlobalCursorManager;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.ScreenUpdateManager;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.Region;

public abstract class WComponentPeer
extends WObjectPeer
implements ComponentPeer,
DropTargetPeer,
DisplayChangedListener {
    protected volatile long hwnd;
    private static final DebugHelper dbg = DebugHelper.create(WComponentPeer.class);
    private static final Logger shapeLog = Logger.getLogger("sun.awt.windows.shape.WComponentPeer");
    SurfaceData surfaceData;
    private RepaintArea paintArea;
    protected Win32GraphicsConfig winGraphicsConfig;
    boolean isLayouting = false;
    boolean paintPending = false;
    int oldWidth = -1;
    int oldHeight = -1;
    private int numBackBuffers = 0;
    private VolatileImage backBuffer = null;
    private BufferCapabilities backBufferCaps = null;
    private Color foreground;
    private Color background;
    private Font font;
    int nDropTargets;
    long nativeDropTargetContext;
    public int serialNum = 0;
    private static final double BANDING_DIVISOR = 4.0;
    static final Font defaultFont;
    private int updateX1;
    private int updateY1;
    private int updateX2;
    private int updateY2;
    private volatile boolean isAccelCapable = true;

    static native void wheelInit();

    public native boolean isObscured();

    public boolean canDetermineObscurity() {
        return true;
    }

    public synchronized native void pShow();

    public synchronized native void hide();

    public synchronized native void enable();

    public synchronized native void disable();

    public long getHWnd() {
        return this.hwnd;
    }

    public native Point getLocationOnScreen();

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        Dimension dimension = ((Component)this.target).getSize();
        this.oldHeight = dimension.height;
        this.oldWidth = dimension.width;
        this.pShow();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    private native void reshapeNoCheck(int var1, int var2, int var3, int var4);

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.paintPending = n3 != this.oldWidth || n4 != this.oldHeight;
        if ((n5 & 0x4000) != 0) {
            this.reshapeNoCheck(n, n2, n3, n4);
        } else {
            this.reshape(n, n2, n3, n4);
        }
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            try {
                this.replaceSurfaceData();
            }
            catch (InvalidPipeException invalidPipeException) {
                // empty catch block
            }
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
        ++this.serialNum;
    }

    void dynamicallyLayoutContainer() {
        final Container container = (Container)this.target;
        WToolkit.executeOnEventHandlerThread(container, new Runnable(){

            public void run() {
                container.invalidate();
                container.validate();
                if (WComponentPeer.this.surfaceData instanceof D3DSurfaceData.D3DWindowSurfaceData || WComponentPeer.this.surfaceData instanceof OGLSurfaceData) {
                    try {
                        WComponentPeer.this.replaceSurfaceData();
                    }
                    catch (InvalidPipeException invalidPipeException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    void paintDamagedAreaImmediately() {
        this.updateWindow();
        WToolkit.getWToolkit();
        WToolkit.flushPendingEvents();
        this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
    }

    synchronized native void updateWindow();

    public void paint(Graphics graphics) {
        ((Component)this.target).paint(graphics);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    private native int[] createPrintedPixels(int var1, int var2, int var3, int var4, int var5);

    public void print(Graphics graphics) {
        Component component = (Component)this.target;
        int n = component.getWidth();
        int n2 = component.getHeight();
        int n3 = (int)((double)n2 / 4.0);
        if (n3 == 0) {
            n3 = n2;
        }
        for (int i = 0; i < n2; i += n3) {
            Color color;
            int n4;
            int[] nArray;
            int n5 = i + n3 - 1;
            if (n5 >= n2) {
                n5 = n2 - 1;
            }
            if ((nArray = this.createPrintedPixels(0, i, n, n4 = n5 - i + 1, (color = component.getBackground()) == null ? 255 : color.getAlpha())) == null) continue;
            BufferedImage bufferedImage = new BufferedImage(n, n4, 2);
            bufferedImage.setRGB(0, 0, n, n4, nArray, 0, n);
            graphics.drawImage(bufferedImage, 0, i, null);
            bufferedImage.flush();
        }
        component.print(graphics);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        if (!(paintEvent instanceof IgnorePaintEvent)) {
            this.paintArea.add(rectangle, paintEvent.getID());
        }
    }

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public boolean handleJavaKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    native void nativeHandleEvent(AWTEvent var1);

    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (((Component)this.target).isEnabled() && aWTEvent instanceof KeyEvent && !((KeyEvent)aWTEvent).isConsumed() && this.handleJavaKeyEvent((KeyEvent)aWTEvent)) {
            return;
        }
        switch (n) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, this.shouldClearRectBeforePaint());
                }
                return;
            }
        }
        this.nativeHandleEvent(aWTEvent);
    }

    public Dimension getMinimumSize() {
        return ((Component)this.target).getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void layout() {
    }

    public Rectangle getBounds() {
        return ((Component)this.target).getBounds();
    }

    public boolean isFocusable() {
        return false;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.winGraphicsConfig != null) {
            return this.winGraphicsConfig;
        }
        return ((Component)this.target).getGraphicsConfiguration();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public void replaceSurfaceData() {
        this.replaceSurfaceData(this.numBackBuffers, this.backBufferCaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData(int n, BufferCapabilities bufferCapabilities) {
        SurfaceData surfaceData = null;
        VolatileImage volatileImage = null;
        Object object = ((Component)this.target).getTreeLock();
        synchronized (object) {
            WComponentPeer wComponentPeer = this;
            synchronized (wComponentPeer) {
                if (this.pData == 0L) {
                    return;
                }
                this.numBackBuffers = n;
                Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
                ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
                surfaceData = this.surfaceData;
                screenUpdateManager.dropScreenSurface(surfaceData);
                this.surfaceData = screenUpdateManager.createScreenSurface(win32GraphicsConfig, this, this.numBackBuffers, true);
                if (surfaceData != null) {
                    surfaceData.invalidate();
                }
                volatileImage = this.backBuffer;
                if (this.numBackBuffers > 0) {
                    this.backBufferCaps = bufferCapabilities;
                    this.backBuffer = win32GraphicsConfig.createBackBuffer(this);
                } else if (this.backBuffer != null) {
                    this.backBufferCaps = null;
                    this.backBuffer = null;
                }
            }
        }
        if (surfaceData != null) {
            surfaceData.flush();
            surfaceData = null;
        }
        if (volatileImage != null) {
            volatileImage.flush();
            surfaceData = null;
        }
    }

    public void replaceSurfaceDataLater() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!WComponentPeer.this.isDisposed()) {
                    try {
                        WComponentPeer.this.replaceSurfaceData();
                    }
                    catch (InvalidPipeException invalidPipeException) {
                        // empty catch block
                    }
                }
            }
        };
        if (!PaintEventDispatcher.getPaintEventDispatcher().queueSurfaceDataReplacing((Component)this.target, runnable)) {
            this.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
        }
    }

    public void displayChanged() {
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            // empty catch block
        }
    }

    public void paletteChanged() {
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public ColorModel getDeviceColorModel() {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        if (win32GraphicsConfig != null) {
            return win32GraphicsConfig.getDeviceColorModel();
        }
        return null;
    }

    public ColorModel getColorModel(int n) {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel(n);
        }
        return null;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        if (this.isDisposed()) {
            return null;
        }
        Component component = (Component)this.getTarget();
        Window window = SunToolkit.getContainingWindow(component);
        if (window != null && !AWTAccessor.getWindowAccessor().isOpaque(window)) {
            Object object;
            int n = 0;
            int n2 = 0;
            for (object = component; object != window; object = ((Component)object).getParent()) {
                n += ((Component)object).getX();
                n2 += ((Component)object).getY();
            }
            object = ((WWindowPeer)window.getPeer()).getTranslucentGraphics();
            ((Graphics)object).translate(n, n2);
            ((Graphics)object).clipRect(0, 0, component.getWidth(), component.getHeight());
            return object;
        }
        SurfaceData surfaceData = this.surfaceData;
        if (surfaceData != null) {
            Font font;
            Color color;
            Color color2 = this.background;
            if (color2 == null) {
                color2 = SystemColor.window;
            }
            if ((color = this.foreground) == null) {
                color = SystemColor.windowText;
            }
            if ((font = this.font) == null) {
                font = defaultFont;
            }
            ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
            return screenUpdateManager.createGraphics(surfaceData, this, color, color2, font);
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return WFontMetrics.getFontMetrics(font);
    }

    private synchronized native void _dispose();

    protected void disposeImpl() {
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        ScreenUpdateManager.getInstance().dropScreenSurface(surfaceData);
        surfaceData.invalidate();
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public synchronized void setForeground(Color color) {
        this.foreground = color;
        this._setForeground(color.getRGB());
    }

    public synchronized void setBackground(Color color) {
        this.background = color;
        this._setBackground(color.getRGB());
    }

    public Color getBackgroundNoSync() {
        return this.background;
    }

    public native void _setForeground(int var1);

    public native void _setBackground(int var1);

    public synchronized void setFont(Font font) {
        this.font = font;
        this._setFont(font);
    }

    public synchronized native void _setFont(Font var1);

    public final void updateCursorImmediately() {
        WGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    static native boolean processSynchronousLightweightTransfer(Component var0, Component var1, boolean var2, boolean var3, long var4);

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        if (WComponentPeer.processSynchronousLightweightTransfer((Component)this.target, component, bl, bl2, l)) {
            return true;
        }
        return this._requestFocus(component, bl, bl2, l, cause);
    }

    public native boolean _requestFocus(Component var1, boolean var2, boolean var3, long var4, CausedFocusEvent.Cause var6);

    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        return win32GraphicsConfig.createAcceleratedImage((Component)this.target, n, n2);
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        return new SunVolatileImage((Component)this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.target + "]";
    }

    WComponentPeer(Component component) {
        this.target = component;
        this.paintArea = new RepaintArea();
        Container container = WToolkit.getNativeContainer(component);
        WComponentPeer wComponentPeer = (WComponentPeer)WToolkit.targetToPeer(container);
        this.create(wComponentPeer);
        this.checkCreation();
        this.winGraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
        this.surfaceData = screenUpdateManager.createScreenSurface(this.winGraphicsConfig, this, this.numBackBuffers, false);
        this.initialize();
        this.start();
    }

    abstract void create(WComponentPeer var1);

    protected void checkCreation() {
        if (this.hwnd == 0L || this.pData == 0L) {
            if (this.createError != null) {
                throw this.createError;
            }
            throw new InternalError("couldn't create component peer");
        }
    }

    synchronized native void start();

    void initialize() {
        Font font;
        Color color;
        if (((Component)this.target).isVisible()) {
            this.show();
        }
        if ((color = ((Component)this.target).getForeground()) != null) {
            this.setForeground(color);
        }
        if ((font = ((Component)this.target).getFont()) != null) {
            this.setFont(font);
        }
        if (!((Component)this.target).isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = ((Component)this.target).getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 3);
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
    }

    void handleExpose(int n, int n2, int n3, int n4) {
        this.postPaintIfNecessary(n, n2, n3, n4);
    }

    public void handlePaint(int n, int n2, int n3, int n4) {
        this.postPaintIfNecessary(n, n2, n3, n4);
    }

    private void postPaintIfNecessary(int n, int n2, int n3, int n4) {
        PaintEvent paintEvent;
        if (!((Component)this.target).getIgnoreRepaint() && (paintEvent = PaintEventDispatcher.getPaintEventDispatcher().createPaintEvent((Component)this.target, n, n2, n3, n4)) != null) {
            this.postEvent(paintEvent);
        }
    }

    void postEvent(AWTEvent aWTEvent) {
        WToolkit.postEvent(WToolkit.targetToAppContext(this.target), aWTEvent);
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintArea.isEmpty() || this.paintPending || ((Component)this.target).getIgnoreRepaint())) {
            this.postEvent(new PaintEvent((Component)this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public native void beginValidate();

    public native void endValidate();

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized void addDropTarget(DropTarget dropTarget) {
        if (this.nDropTargets == 0) {
            this.nativeDropTargetContext = this.addNativeDropTarget();
        }
        ++this.nDropTargets;
    }

    public synchronized void removeDropTarget(DropTarget dropTarget) {
        --this.nDropTargets;
        if (this.nDropTargets == 0) {
            this.removeNativeDropTarget();
            this.nativeDropTargetContext = 0L;
        }
    }

    native long addNativeDropTarget();

    native void removeNativeDropTarget();

    native boolean nativeHandlesWheelScrolling();

    public boolean handlesWheelScrolling() {
        return this.nativeHandlesWheelScrolling();
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        win32GraphicsConfig.assertOperationSupported((Component)this.target, n, bufferCapabilities);
        try {
            this.replaceSurfaceData(n - 1, bufferCapabilities);
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.getMessage());
        }
    }

    public void destroyBuffers() {
        this.replaceSurfaceData(0, null);
    }

    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        VolatileImage volatileImage = this.backBuffer;
        if (volatileImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        Win32GraphicsConfig win32GraphicsConfig = (Win32GraphicsConfig)this.getGraphicsConfiguration();
        win32GraphicsConfig.flip(this, (Component)this.target, volatileImage, n, n2, n3, n4, flipContents);
    }

    public synchronized Image getBackBuffer() {
        VolatileImage volatileImage = this.backBuffer;
        if (volatileImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return volatileImage;
    }

    public BufferCapabilities getBackBufferCaps() {
        return this.backBufferCaps;
    }

    public int getBackBuffersNum() {
        return this.numBackBuffers;
    }

    public boolean shouldClearRectBeforePaint() {
        return true;
    }

    native void pSetParent(ComponentPeer var1);

    public void reparent(ContainerPeer containerPeer) {
        this.pSetParent(containerPeer);
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void setBoundsOperation(int n) {
    }

    private static final boolean isContainingTopLevelAccelCapable(Component component) {
        while (component != null && !(component instanceof WEmbeddedFrame)) {
            component = component.getParent();
        }
        if (component == null) {
            return true;
        }
        return ((WEmbeddedFramePeer)component.getPeer()).isAccelCapable();
    }

    public boolean isAccelCapable() {
        if (!this.isAccelCapable || !WComponentPeer.isContainingTopLevelAccelCapable((Component)this.target)) {
            return false;
        }
        boolean bl = SunToolkit.isContainingTopLevelTranslucent((Component)this.target);
        return !bl || Win32GraphicsEnvironment.isVistaOS();
    }

    public void disableAcceleration() {
        this.isAccelCapable = false;
    }

    private native void setRectangularShape(int var1, int var2, int var3, int var4, Region var5);

    public void applyShape(Region region) {
        if (shapeLog.isLoggable(Level.FINER)) {
            shapeLog.finer("*** INFO: Setting shape: PEER: " + this + "; TARGET: " + this.target + "; SHAPE: " + region);
        }
        if (region != null) {
            this.setRectangularShape(region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY(), region.isRectangular() ? null : region);
        } else {
            this.setRectangularShape(0, 0, 0, 0, null);
        }
    }

    static {
        WComponentPeer.wheelInit();
        defaultFont = new Font("Dialog", 0, 12);
    }
}

