/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.widget;

import de.jtem.jrworkspace.logging.LoggingSystem;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.PluginInfo;
import de.jtem.jrworkspace.plugin.flavor.OpenAboutFlavor;
import de.jtem.jrworkspace.plugin.flavor.OpenPreferencesFlavor;
import de.jtem.jrworkspace.plugin.flavor.ShutdownFlavor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AppleApplicationPlugin
extends Plugin
implements ShutdownFlavor,
OpenAboutFlavor,
OpenPreferencesFlavor {
    public static String APPLE_APPLICATION_CLASS = "com.apple.eawt.Application";
    public static String APPLE_APPLICATION_LISTENER = "com.apple.eawt.ApplicationListener";
    private Object appleApplicationInstance;
    private ShutdownFlavor.ShutdownListener shutdownListener;
    private OpenAboutFlavor.OpenAboutListener openAboutListener;
    private OpenPreferencesFlavor.OpenPreferencesListener openPreferencesListener;

    public AppleApplicationPlugin() {
        Class<?> appleApplication = null;
        try {
            appleApplication = Class.forName(APPLE_APPLICATION_CLASS);
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.config("Seems we are not running in an Apple JRE. Could not access: " + APPLE_APPLICATION_CLASS);
            LoggingSystem.LOGGER.fine(e.toString());
        }
        if (appleApplication != null) {
            this.instanciateAppleApplication(appleApplication);
            this.registerApplicationListener(appleApplication);
            this.addMenuItems(appleApplication);
            LoggingSystem.LOGGER.config("Seems we are running in an Apple JRE. Handling of Apple events enabled.");
        }
    }

    public Object getAppleApplication() {
        return this.appleApplicationInstance;
    }

    @Override
    public PluginInfo getPluginInfo() {
        PluginInfo info = new PluginInfo("apple application", "G. Paul Peters");
        return info;
    }

    @Override
    public void setShutdownListener(ShutdownFlavor.ShutdownListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    @Override
    public void setOpenAboutListener(OpenAboutFlavor.OpenAboutListener openAboutListener) {
        this.openAboutListener = openAboutListener;
    }

    @Override
    public void setOpenPreferencesListener(OpenPreferencesFlavor.OpenPreferencesListener openPreferencesListener) {
        this.openPreferencesListener = openPreferencesListener;
    }

    private void registerApplicationListener(Class<?> appleApplication) {
        Object appListener = null;
        try {
            appListener = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Class.forName(APPLE_APPLICATION_LISTENER)}, (InvocationHandler)new AppleApplicationListener());
            appleApplication.getMethod("addApplicationListener", Class.forName(APPLE_APPLICATION_LISTENER)).invoke(this.appleApplicationInstance, appListener);
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.info(e.toString());
        }
    }

    private void instanciateAppleApplication(Class<?> appleApplication) {
        try {
            this.appleApplicationInstance = appleApplication.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.info(e.toString());
        }
    }

    private void addMenuItems(Class<?> appleApplication) {
        try {
            appleApplication.getMethod("addPreferencesMenuItem", new Class[0]).invoke(this.appleApplicationInstance, new Object[0]);
            appleApplication.getMethod("addAboutMenuItem", new Class[0]).invoke(this.appleApplicationInstance, new Object[0]);
        }
        catch (Exception e) {
            LoggingSystem.LOGGER.info(e.toString());
        }
    }

    private class AppleApplicationListener
    implements InvocationHandler {
        private AppleApplicationListener() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LoggingSystem.LOGGER.finer(method.getName());
            if (method.getName() == "handleQuit" && AppleApplicationPlugin.this.shutdownListener != null) {
                AppleApplicationPlugin.this.shutdownListener.shutdown();
            }
            if (method.getName() == "handleAbout" && AppleApplicationPlugin.this.openAboutListener != null) {
                AppleApplicationPlugin.this.openAboutListener.openAboutWindow();
            }
            if (method.getName() == "handlePreferences" && AppleApplicationPlugin.this.openPreferencesListener != null) {
                AppleApplicationPlugin.this.openPreferencesListener.openPreferencesWindow();
            }
            return null;
        }
    }
}

