/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.logging;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingSystem {
    public static final Logger LOGGER = Logger.getLogger(LoggingSystem.class.getName());

    static {
        LoggingSystem.tryToInitFileHandler();
    }

    static Level tryToGetLoglevel() {
        Level level = null;
        String levelName = null;
        try {
            levelName = System.getProperty("de.jtem.jrworkspace.level");
        }
        catch (SecurityException se) {
            LOGGER.config("No permission to read system property: " + se.getMessage());
        }
        try {
            level = levelName == null ? null : Level.parse(levelName);
        }
        catch (IllegalArgumentException e) {
            LOGGER.config("Could not parse the value of the system property de.jtem.jrworkspace.level \"" + levelName + "\" to a logging level:");
        }
        if (level == null) {
            level = Logger.getLogger("").getLevel();
        }
        return level;
    }

    private static void tryToInitFileHandler() {
        try {
            LoggingSystem.initFileHandler(System.getProperty("de.jtem.jrworkspace.logfile"));
        }
        catch (SecurityException se) {
            LOGGER.config("No permission to read system property or add file handler: " + se.getMessage());
        }
        catch (IOException ioe) {
            LOGGER.config(ioe.getMessage());
        }
        catch (Exception e) {
            LOGGER.config("Could not initializen file handler: " + e.getMessage());
        }
    }

    private static void initFileHandler(String filename) throws IOException {
        FileHandler handler = new FileHandler(filename, true);
        handler.setLevel(Level.ALL);
        LOGGER.addHandler(handler);
    }
}

