# PolyCalc
PolyCalc is a polynomial calculator.
It calculates and expands polynomials, equations, and relations.
It supports simple variable assignments for the ease of handling expressions.

## Usage
PolyCalc can be used as a simple calculator:
```
2^10 - 1
AST: (- (^ 2 10) 1)
VAL: 1023

2 * 3.14159265 * 7
AST: (* (* 2 3.141593) 7)
VAL: 43.982297
```
Both `AST` and `VAL` are generated by PolyCalc--you can check `AST` to ensure
that PolyCalc indeed parsed the given input as you have intended.
`VAL` is the result of the expression.

If `AST` is not necessary, you can hide the parsed result and remove both
`AST:` and `VAL:` labels altogether by invoking PolyCalc with the `-q` flag.
The `-v` flag does nothing--PolyCalc is by default verbose--but it is there for
completeness.
The `-q` flag is useful if you want to redirect the output to a file via shell
output redirection.

PolyCalc can also calculate and expand polynomials:
```
(x + y)^3
AST: (^ (+ x y) 3)
VAL: x^3 + 3 x^2 y + 3 x y^2 + y^3

(a^2 + 2ab + b^2)(a^2 - 2ab + b^2)
AST: (* (+ (+ (^ a 2) (* (* 2 a) b)) (^ b 2)) (+ (- (^ a 2) (* (* 2 a) b)) (^ b 2)))
VAL: a^4 + -2 a^2 b^2 + b^4

(x + y)(x - y) + y^2
AST: (+ (* (+ x y) (- x y)) (^ y 2))
VAL: x^2
```

Use assignments to improve readability and avoid repetitions:
```
'sum := a + b
AST: (:= sum (+ a b))
ASN: sum := a + b

'sub := a - b
AST: (:= sub (- a b))
ASN: sub := a + -1 b

'sum * 'sub
AST: (* sum sub)
VAL: a^2 + -1 b^2
```
Note that the assignment operator is `:=`, not `=` which represents a relation
presented below.

It can simplify (a system of) equations/inequalities as well:
```
a + b + c = 2a - b
AST: (= (+ (+ a b) c) (- (* 2 a) b))
REL: a + -2 b + -1 c = 0

x >= y & x = y & x - y <= 0
AST: (>= x y) & (= x y) & (<= (- x y) 0)
REL: x + -1 y = 0

a > 2a
AST: (> a (* 2 a))
REL: a < 0 

y < y
AST: (< y y)
REL: INCONSISTENT SYSTEM
```
The result will start with `VAL` if you have typed an expression without a
relation--`REL` will be shown otherwise.
PolyCalc will prompt you `INCONSISTENT SYSTEM` if it can figure out that the
given system has no solution.

If you need a variable with a name longer than a letter, put a quote(`'`)
before the name:
```
'long = 1
AST: (= long 1)
REL: long + -1 = 0
```

Since PolyCalc sorts the input variables composing a product, you can use it
creatively:
```
sorttheseletters
AST: (* (* (* (* (* (* (* (* (* (* (* (* (* (* (* s o) r) t) t) h) e) s) e) l) e) t) t) e) r) s)
VAL: e^4 h l o r^2 s^3 t^4
```

PolyCalc also accepts a file as an input.
For example, consider a file named `input.poly` with the below content:
```
x := 3
y := 2
x + y
```
Invoking PolyCalc via `./build/poly input.poly` outputs:
```
AST: (:= x 3)
ASN: x := 3 

AST: (:= y 3)
ASN: y := 3 

AST: (+ x y)
VAL: 6 
```
You can combine shell redirection and the `-q` flag to save the output:
```
./build/poly -q input.poly >out.txt
```
Note that the flag must precede the filename.

## Building Source
```sh
make
```

Requires GNU Bison and flex.
Tested on Ubuntu 20.04.2 LTS using GNU Bison 3.5.1 and flex 2.6.4.

## Running
After `make`, the executable is placed under `build` directory:
```sh
./build/poly
```

You can use [`rlwrap`](https://github.com/hanslub42/rlwrap), e.g., to use arrow
keys:
```sh
rlwrap ./build/poly
```
