/* Generated By:JJTree: Do not edit this line. ASTElement.java */

package net.sourceforge.pmd.jsp.ast;

public class ASTElement extends SimpleNode {

/* BEGIN CUSTOM CODE */

    /**
     * Name of the element-tag. Cannot be null.
     */
    private String name;

    /**
     * Flag indicating that the element consists of one tag ("<... />").
     */
    private boolean empty; //


    /**
     * @return boolean - true if the element has a namespace-prefix, false otherwise
     */
    public boolean isHasNamespacePrefix() {
        return (name.indexOf(':') >= 0);
    }

    /**
     * @return String - the part of the name that is before the (first) colon (":")
     */
    public String getNamespacePrefix() {
        int colonIndex = name.indexOf(':');
        return ((colonIndex >= 0)
                ? name.substring(0, colonIndex)
                : "");
    }

    /**
     * @return String - The part of the name that is after the first colon (":").
     *         If the name does not contain a colon, the full name is returned.
     */
    public String getLocalName() {
        int colonIndex = name.indexOf(':');
        return ((colonIndex >= 0)
                ? name.substring(colonIndex + 1)
                : name);
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the empty.
     */
    public boolean isEmpty() {
        return empty;
    }

    /**
     * @param empty The empty to set.
     */
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    /* (non-Javadoc)
     * @see com.applicationengineers.pmd4jsp.ast.SimpleNode#toString(java.lang.String)
     */
    public String toString(String prefix) {
        return super.toString(prefix) + " name=[" + name + "] ";
    }
/* END CUSTOM CODE */



    public ASTElement(int id) {
        super(id);
    }

    public ASTElement(JspParser p, int id) {
        super(p, id);
    }


    /**
     * Accept the visitor. *
     */
    public Object jjtAccept(JspParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}
