/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class UnusedFormalParameterRule
extends AbstractRule {
    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.check(node, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!node.isPrivate() && !this.hasProperty("checkall")) {
            return data;
        }
        if (!node.isNative()) {
            this.check(node, data);
        }
        return data;
    }

    private void check(SimpleNode node, Object data) {
        Node parent = node.jjtGetParent().jjtGetParent().jjtGetParent();
        if (parent instanceof ASTClassOrInterfaceDeclaration && !((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            Map vars = node.getScope().getVariableDeclarations();
            Iterator i = vars.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                VariableNameDeclaration nameDecl = (VariableNameDeclaration)entry.getKey();
                if (this.actuallyUsed(nameDecl, (List)entry.getValue())) continue;
                this.addViolation(data, (Node)node, new Object[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", nameDecl.getImage()});
            }
        }
    }

    private boolean actuallyUsed(VariableNameDeclaration nameDecl, List usages) {
        Iterator j = usages.iterator();
        while (j.hasNext()) {
            NameOccurrence occ = (NameOccurrence)j.next();
            if (occ.isOnLeftHandSide()) {
                if (!nameDecl.isArray() || occ.getLocation().jjtGetParent().jjtGetParent().jjtGetNumChildren() <= 1) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

