/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;

public class PapariTextRenderer
extends AbstractRenderer {
    private String pwd;
    private String yellowBold = "";
    private String whiteBold = "";
    private String redBold = "";
    private String cyan = "";
    private String green = "";
    private String colorReset = "";

    private void initializeColorsIfSupported() {
        if (System.getProperty("pmd.color") != null && !System.getProperty("pmd.color").equals("0") && !System.getProperty("pmd.color").equals("false")) {
            this.yellowBold = "\u001b[1;33m";
            this.whiteBold = "\u001b[1;37m";
            this.redBold = "\u001b[1;31m";
            this.green = "\u001b[0;32m";
            this.cyan = "\u001b[0;36m";
            this.colorReset = "\u001b[0m";
        }
    }

    public void render(Writer writer, Report report) throws IOException {
        StringBuffer buf = new StringBuffer(PMD.EOL);
        this.initializeColorsIfSupported();
        String lastFile = null;
        int numberOfErrors = 0;
        int numberOfWarnings = 0;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            buf.setLength(0);
            ++numberOfWarnings;
            IRuleViolation rv = (IRuleViolation)i.next();
            if (!rv.getFilename().equals(lastFile)) {
                lastFile = rv.getFilename();
                buf.append(this.yellowBold + "*" + this.colorReset + " file: " + this.whiteBold + this.getRelativePath(lastFile) + this.colorReset + PMD.EOL);
            }
            buf.append(this.green + "    src:  " + this.cyan + lastFile.substring(lastFile.lastIndexOf(File.separator) + 1) + this.colorReset + ":" + this.cyan + rv.getBeginLine() + (rv.getEndLine() == -1 ? "" : ":" + rv.getEndLine()) + this.colorReset + PMD.EOL);
            buf.append(this.green + "    rule: " + this.colorReset + rv.getRule().getName() + PMD.EOL);
            buf.append(this.green + "    msg:  " + this.colorReset + rv.getDescription() + PMD.EOL);
            buf.append(this.green + "    code: " + this.colorReset + this.getLine(lastFile, rv.getBeginLine()) + PMD.EOL + PMD.EOL);
            writer.write(buf.toString());
        }
        writer.write(PMD.EOL + PMD.EOL);
        writer.write("Summary:" + PMD.EOL + PMD.EOL);
        Map summary = report.getCountSummary();
        Iterator i2 = summary.entrySet().iterator();
        while (i2.hasNext()) {
            buf.setLength(0);
            Map.Entry entry = (Map.Entry)i2.next();
            String key = (String)entry.getKey();
            buf.append(key + " : " + (Integer)entry.getValue() + PMD.EOL);
            writer.write(buf.toString());
        }
        i2 = report.errors();
        while (i2.hasNext()) {
            buf.setLength(0);
            ++numberOfErrors;
            Report.ProcessingError error = (Report.ProcessingError)i2.next();
            if (error.getFile().equals(lastFile)) {
                lastFile = error.getFile();
                buf.append(this.redBold + "*" + this.colorReset + " file: " + this.whiteBold + this.getRelativePath(lastFile) + this.colorReset + PMD.EOL);
            }
            buf.append(this.green + "    err:  " + this.cyan + error.getMsg() + this.colorReset + PMD.EOL + PMD.EOL);
            writer.write(buf.toString());
        }
        if (numberOfErrors > 0) {
            writer.write(this.redBold + "*" + this.colorReset + " errors:   " + this.whiteBold + numberOfWarnings + this.colorReset + PMD.EOL);
        }
        writer.write(this.yellowBold + "*" + this.colorReset + " warnings: " + this.whiteBold + numberOfWarnings + this.colorReset + PMD.EOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getLine(String sourceFile, int line) {
        String code = null;
        BufferedReader br = null;
        br = new BufferedReader(new FileReader(new File(sourceFile)));
        for (int i = 0; line > i; ++i) {
            code = br.readLine().trim();
        }
        Object var7_7 = null;
        if (br == null) return code;
        try {
            br.close();
            return code;
        }
        catch (IOException ioErr2) {
            ioErr2.printStackTrace();
        }
        return code;
        {
            catch (IOException ioErr) {
                ioErr.printStackTrace();
                Object var7_8 = null;
                if (br == null) return code;
                try {
                    br.close();
                    return code;
                }
                catch (IOException ioErr2) {
                    ioErr2.printStackTrace();
                }
                return code;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException ioErr2) {
                ioErr2.printStackTrace();
            }
            throw throwable;
        }
    }

    private String getRelativePath(String fileName) {
        String relativePath;
        if (this.pwd == null) {
            try {
                this.pwd = new File(".").getCanonicalPath();
            }
            catch (IOException ioErr) {
                this.pwd = "";
            }
        }
        if (fileName.indexOf(this.pwd) == 0) {
            relativePath = "." + fileName.substring(this.pwd.length());
            if (relativePath.startsWith("." + File.separator + "." + File.separator)) {
                relativePath = relativePath.substring(2);
            }
        } else {
            relativePath = fileName;
        }
        return relativePath;
    }
}

