/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;

public class RuleSets {
    private Collection ruleSets = new ArrayList();

    public RuleSets() {
    }

    public RuleSets(RuleSet ruleSet) {
        this();
        this.addRuleSet(ruleSet);
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.ruleSets.add(ruleSet);
    }

    public RuleSet[] getAllRuleSets() {
        return this.ruleSets.toArray(new RuleSet[this.ruleSets.size()]);
    }

    public Iterator getRuleSetsIterator() {
        return this.ruleSets.iterator();
    }

    public Set getAllRules() {
        HashSet result = new HashSet();
        Iterator i = this.ruleSets.iterator();
        while (i.hasNext()) {
            result.addAll(((RuleSet)i.next()).getRules());
        }
        return result;
    }

    public boolean applies(Language languageOfSource, Language languageOfRule) {
        return languageOfSource.equals(languageOfRule) || languageOfSource.equals(Language.JAVA) && null == languageOfRule;
    }

    public void apply(List acuList, RuleContext ctx, Language language) {
        Iterator i = this.ruleSets.iterator();
        while (i.hasNext()) {
            RuleSet ruleSet = (RuleSet)i.next();
            if (!this.applies(language, ruleSet.getLanguage())) continue;
            ruleSet.apply(acuList, ctx);
        }
    }

    public boolean usesDFA(Language language) {
        Iterator i = this.ruleSets.iterator();
        while (i.hasNext()) {
            RuleSet ruleSet = (RuleSet)i.next();
            if (!this.applies(language, ruleSet.getLanguage()) || !ruleSet.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator i = this.ruleSets.iterator();
        while (i.hasNext() && rule == null) {
            RuleSet ruleSet = (RuleSet)i.next();
            rule = ruleSet.getRuleByName(ruleName);
        }
        return rule;
    }

    public boolean usesTypeResolution(Language language) {
        Iterator i = this.ruleSets.iterator();
        while (i.hasNext()) {
            RuleSet ruleSet = (RuleSet)i.next();
            if (!this.applies(language, ruleSet.getLanguage()) || !ruleSet.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }
}

