/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class StringToStringRule
extends AbstractJavaRule {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_MAP;
    private final Set<ASTMethodDeclaration> declaredMethods = new LinkedHashSet<ASTMethodDeclaration>();

    @Override
    public Object visit(ASTClassOrInterfaceBody body, Object data) {
        this.clearStateIfNewClass(body);
        List methodDeclarations = body.findDescendantsOfType(ASTMethodDeclaration.class);
        this.declaredMethods.addAll(methodDeclarations);
        return super.visit(body, data);
    }

    private void clearStateIfNewClass(ASTClassOrInterfaceBody body) {
        if (this.isBodyOfOuterClass(body)) {
            this.declaredMethods.clear();
        }
    }

    private boolean isBodyOfOuterClass(ASTClassOrInterfaceBody body) {
        return body.getFirstParentOfType(ASTClassOrInterfaceBody.class) == null;
    }

    @Override
    public Object visit(ASTVariableDeclaratorId varId, Object data) {
        if (this.isStringVariableDeclarator(varId)) {
            for (NameOccurrence varUsage : varId.getUsages()) {
                NameOccurrence qualifier = this.getVarUsageQualifier(varUsage);
                if (!this.isToStringOnStringCall(varId, qualifier)) continue;
                this.asCtx(data).addViolation((Node)varUsage.getLocation());
            }
        }
        return data;
    }

    private boolean isStringVariableDeclarator(ASTVariableDeclaratorId varDeclaratorId) {
        VariableNameDeclaration varNameDeclaration = varDeclaratorId.getNameDeclaration();
        return varNameDeclaration != null && TypeTestUtil.isExactlyA(String.class, (TypeNode)varDeclaratorId) || TypeTestUtil.isExactlyA(String[].class, (TypeNode)varDeclaratorId);
    }

    private NameOccurrence getVarUsageQualifier(NameOccurrence varUsage) {
        JavaNameOccurrence jVarUsage = (JavaNameOccurrence)varUsage;
        return jVarUsage.getNameForWhichThisIsAQualifier();
    }

    private boolean isToStringOnStringCall(ASTVariableDeclaratorId varDeclaratorId, NameOccurrence qualifier) {
        if (qualifier != null) {
            return this.isNotAMethodReference(qualifier) && this.isNotAnArrayField(varDeclaratorId, qualifier) && this.isToString(qualifier.getImage()) && this.isStringAccess(qualifier);
        }
        return false;
    }

    private boolean isStringAccess(NameOccurrence qualifier) {
        Node parent = qualifier.getLocation().getParent();
        if (parent instanceof ASTPrimaryPrefix) {
            return TypeTestUtil.isA(String.class, (TypeNode)((ASTPrimaryPrefix)parent));
        }
        return true;
    }

    private boolean isNotAnArrayField(ASTVariableDeclaratorId varDeclaratorId, NameOccurrence qualifier) {
        return !varDeclaratorId.hasArrayType() || this.isNotAName(qualifier);
    }

    private boolean isNotAMethodReference(NameOccurrence qualifier) {
        return this.isNotA(qualifier, ASTMethodReference.class);
    }

    private boolean isNotAName(NameOccurrence qualifier) {
        return this.isNotA(qualifier, ASTName.class);
    }

    private boolean isNotA(NameOccurrence qualifier, Class<? extends JavaNode> type) {
        ScopedNode location = qualifier.getLocation();
        return location == null || !type.isAssignableFrom(location.getClass());
    }

    @Override
    public Object visit(ASTPrimaryExpression primaryExpr, Object data) {
        if (this.hasChainedMethods(primaryExpr)) {
            for (int callIndex = 2; callIndex < primaryExpr.getNumChildren(); ++callIndex) {
                ASTPrimarySuffix prevMethodCallArgs;
                JavaNode prevMethodCall;
                JavaNode methodCall = (JavaNode)primaryExpr.getChild(callIndex);
                if (!this.isToStringMethodCall(methodCall) || !this.calledMethodReturnsString(prevMethodCall = (JavaNode)primaryExpr.getChild(callIndex - 2), prevMethodCallArgs = (ASTPrimarySuffix)primaryExpr.getChild(callIndex - 1))) continue;
                this.asCtx(data).addViolation((Node)methodCall);
            }
        }
        return super.visit(primaryExpr, data);
    }

    @Override
    public Object visit(ASTPrimarySuffix node, Object data) {
        JavaNode previousSibling;
        if (this.isToStringMethodCall(node) && node.getIndexInParent() > 0 && (previousSibling = ((JavaNode)node.getParent()).getChild(node.getIndexInParent() - 1)) instanceof ASTPrimaryPrefix && TypeTestUtil.isA(String.class, (TypeNode)((ASTPrimaryPrefix)previousSibling))) {
            this.asCtx(data).addViolation((Node)node);
        }
        return super.visit(node, data);
    }

    private boolean hasChainedMethods(ASTPrimaryExpression primaryExpr) {
        return primaryExpr.getNumChildren() >= 4;
    }

    private boolean isToStringMethodCall(JavaNode methodCall) {
        String methodName = this.getCalledMethodName(methodCall);
        return this.isToString(methodName);
    }

    private boolean isToString(String methodName) {
        return "toString".equals(methodName);
    }

    private boolean calledMethodReturnsString(JavaNode methodCall, ASTPrimarySuffix methodCallArgs) {
        if (methodCallArgs.isArguments() && methodCallArgs.getTypeDefinition() != null) {
            return TypeTestUtil.isA(String.class, (TypeNode)methodCallArgs);
        }
        String returnTypeName = this.getCalledMethodReturnTypeName(methodCall, methodCallArgs);
        return "String".equals(returnTypeName);
    }

    private String getCalledMethodReturnTypeName(JavaNode methodCall, ASTPrimarySuffix methodCallArgs) {
        ASTMethodDeclaration calledMethod = this.getCalledMethod(methodCall, methodCallArgs);
        return calledMethod != null ? this.getReturnTypeName(calledMethod) : null;
    }

    private String getCalledMethodName(JavaNode methodCall) {
        ASTName name = (ASTName)methodCall.getFirstChildOfType(ASTName.class);
        return name != null ? name.getImage() : methodCall.getImage();
    }

    private List<ASTMethodDeclaration> getMethodsByNameAndArgsCount(String name, int argsCount) {
        ArrayList<ASTMethodDeclaration> matchingMethods = new ArrayList<ASTMethodDeclaration>();
        for (ASTMethodDeclaration method : this.declaredMethods) {
            if (!name.equals(method.getName()) || method.getArity() != argsCount) continue;
            matchingMethods.add(method);
        }
        return matchingMethods;
    }

    private boolean argsMatchMethodParamsByType(ASTArgumentList argsList, ASTFormalParameters methodParams) {
        for (int paramIndex = 0; paramIndex < methodParams.size(); ++paramIndex) {
            ASTFormalParameter methodParam = (ASTFormalParameter)methodParams.getChild(paramIndex);
            Class<?> typeOfParam = methodParam.getType();
            ASTExpression arg = (ASTExpression)argsList.getChild(paramIndex);
            Class<?> typeOfArg = this.getTypeOfExpression(arg);
            if (typeOfParam == null || typeOfArg == null) {
                return false;
            }
            if (typeOfParam.isAssignableFrom(typeOfArg) || this.isPrimitiveWrapperMatch(typeOfArg, typeOfParam)) continue;
            return false;
        }
        return true;
    }

    private Class<?> getTypeOfExpression(ASTExpression expr) {
        if (expr.getType() != null) {
            return expr.getType();
        }
        if (this.isMethodCall(expr)) {
            ASTPrimaryExpression primary = (ASTPrimaryExpression)expr.getFirstChildOfType(ASTPrimaryExpression.class);
            ASTPrimaryPrefix methodCall = (ASTPrimaryPrefix)primary.getChild(0);
            ASTPrimarySuffix methodCallArgs = (ASTPrimarySuffix)primary.getChild(1);
            ASTMethodDeclaration method = this.getCalledMethod(methodCall, methodCallArgs);
            return this.getMethodReturnType(method);
        }
        return null;
    }

    private boolean isMethodCall(ASTExpression expr) {
        ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)expr.getFirstChildOfType(ASTPrimaryExpression.class);
        return primaryExpression != null && primaryExpression.getNumChildren() == 2;
    }

    private ASTMethodDeclaration getCalledMethod(JavaNode methodCall, ASTPrimarySuffix methodCallArgs) {
        String methodName = this.getCalledMethodName(methodCall);
        if (!methodCallArgs.isArguments()) {
            return null;
        }
        ASTArguments arguments = (ASTArguments)methodCallArgs.getFirstChildOfType(ASTArguments.class);
        ASTArgumentList argumentList = (ASTArgumentList)arguments.getFirstChildOfType(ASTArgumentList.class);
        List<ASTMethodDeclaration> candidates = this.getMethodsByNameAndArgsCount(methodName, arguments.size());
        for (ASTMethodDeclaration candidate : candidates) {
            ASTFormalParameters formalParameters = candidate.getFormalParameters();
            if (!this.argsMatchMethodParamsByType(argumentList, formalParameters)) continue;
            return candidate;
        }
        return null;
    }

    private boolean isPrimitiveWrapperMatch(Class<?> typeOfArg, Class<?> typeOfParam) {
        if (typeOfArg == null || typeOfParam == null) {
            return false;
        }
        Class<?> argType = this.toWrapperClassIfPrimitive(typeOfArg);
        Class<?> paramType = this.toWrapperClassIfPrimitive(typeOfParam);
        return paramType.isAssignableFrom(argType);
    }

    private Class<?> toWrapperClassIfPrimitive(Class<?> type) {
        if (PRIMITIVE_TO_WRAPPER_MAP.containsKey(type)) {
            return PRIMITIVE_TO_WRAPPER_MAP.get(type);
        }
        return type;
    }

    private String getReturnTypeName(ASTMethodDeclaration method) {
        Class<?> type = this.getMethodReturnType(method);
        return type != null ? type.getSimpleName() : null;
    }

    private Class<?> getMethodReturnType(ASTMethodDeclaration method) {
        ASTType returnType;
        ASTType aSTType = returnType = method != null ? (ASTType)method.getResultType().getFirstDescendantOfType(ASTType.class) : null;
        if (returnType != null) {
            return returnType.getType();
        }
        return null;
    }

    static {
        HashMap primitiveToWrapper = new HashMap();
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER_MAP = primitiveToWrapper;
    }
}

