/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.rule.codestyle.AbstractNamingConventionsRule;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class FormalParameterNamingConventionsRule
extends AbstractNamingConventionsRule {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    private static final PropertyDescriptor<Pattern> FINAL_METHOD_PARAMETER_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FormalParameterNamingConventionsRule.prop("finalMethodParameterPattern", "final method parameter", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();
    private static final PropertyDescriptor<Pattern> METHOD_PARAMETER_REGEX = ((PropertyBuilder.RegexPropertyBuilder)FormalParameterNamingConventionsRule.prop("methodParameterPattern", "method parameter", DESCRIPTOR_TO_DISPLAY_NAME).defaultValue((Object)CAMEL_CASE)).build();

    public FormalParameterNamingConventionsRule() {
        this.definePropertyDescriptor(FINAL_METHOD_PARAMETER_REGEX);
        this.definePropertyDescriptor(METHOD_PARAMETER_REGEX);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 1);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
        this.addRuleChainVisit(ASTParameter.class);
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        if (node.getImage() == null) {
            return data;
        }
        if (node.getModifiers().isFinal()) {
            this.checkMatches(FINAL_METHOD_PARAMETER_REGEX, node, data);
        } else {
            this.checkMatches(METHOD_PARAMETER_REGEX, node, data);
        }
        return data;
    }

    @Override
    protected String displayName(String name) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(name);
    }
}

