/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.renderer.CPDRenderer;
import net.sourceforge.pmd.cpd.renderer.CPDReportRenderer;
import net.sourceforge.pmd.util.StringUtil;

public class SimpleRenderer
implements Renderer,
CPDRenderer,
CPDReportRenderer {
    private String separator;
    private boolean trimLeadingWhitespace;
    public static final String DEFAULT_SEPARATOR = "=====================================================================";

    public SimpleRenderer() {
        this(false);
    }

    public SimpleRenderer(boolean trimLeadingWhitespace) {
        this(DEFAULT_SEPARATOR);
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    public SimpleRenderer(String theSeparator) {
        this.separator = theSeparator;
    }

    private void renderOn(Writer writer, Match match) throws IOException {
        writer.append("Found a ").append(String.valueOf(match.getLineCount())).append(" line (").append(String.valueOf(match.getTokenCount())).append(" tokens) duplication in the following files: ").append(PMD.EOL);
        for (Mark mark : match) {
            writer.append("Starting at line ").append(String.valueOf(mark.getBeginLine())).append(" of ").append(mark.getFilename()).append(PMD.EOL);
        }
        writer.append(PMD.EOL);
        String source = match.getSourceCodeSlice();
        if (this.trimLeadingWhitespace) {
            String[] lines = source.split("\n");
            int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll(lines);
            if (trimDepth > 0) {
                lines = StringUtil.trimStartOn(lines, trimDepth);
            }
            for (String line : lines) {
                writer.append(line).append(PMD.EOL);
            }
            return;
        }
        writer.append(source).append(PMD.EOL);
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringWriter writer = new StringWriter(300);
        try {
            this.render(matches, (Writer)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public void render(Iterator<Match> matches, Writer writer) throws IOException {
        if (matches.hasNext()) {
            this.renderOn(writer, matches.next());
        }
        while (matches.hasNext()) {
            Match match = matches.next();
            writer.append(this.separator).append(PMD.EOL);
            this.renderOn(writer, match);
        }
        writer.flush();
    }

    @Override
    public void render(CPDReport report, Writer writer) throws IOException {
        this.render(report.getMatches().iterator(), writer);
    }
}

