/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.AbstractConfiguration;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.cache.AnalysisCache;
import net.sourceforge.pmd.cache.FileAnalysisCache;
import net.sourceforge.pmd.cache.NoopAnalysisCache;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import org.apache.commons.lang3.StringUtils;

public class PMDConfiguration
extends AbstractConfiguration {
    public static final String DEFAULT_SUPPRESS_MARKER = "NOPMD";
    private String suppressMarker = "NOPMD";
    private int threads = Runtime.getRuntime().availableProcessors();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private LanguageVersionDiscoverer languageVersionDiscoverer = new LanguageVersionDiscoverer();
    private LanguageVersion forceLanguageVersion;
    private List<String> ruleSets = new ArrayList<String>();
    private RulePriority minimumPriority = RulePriority.LOW;
    private List<Path> inputPaths = new ArrayList<Path>();
    private URI inputUri;
    private Path inputFilePath;
    private Path ignoreFilePath;
    private boolean ruleSetFactoryCompatibilityEnabled = true;
    private String reportFormat;
    private Path reportFile;
    @Deprecated
    private boolean reportShortNames = false;
    private Properties reportProperties = new Properties();
    private boolean showSuppressedViolations = false;
    private boolean failOnViolation = true;
    @Deprecated
    private boolean stressTest;
    @Deprecated
    private boolean benchmark;
    private AnalysisCache analysisCache = new NoopAnalysisCache();
    private boolean ignoreIncrementalAnalysis;
    private final List<Path> relativizeRoots = new ArrayList<Path>();

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    @Deprecated
    public void prependClasspath(String classpath) throws IOException {
        try {
            this.prependAuxClasspath(classpath);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public void prependAuxClasspath(String classpath) {
        try {
            if (this.classLoader == null) {
                this.classLoader = PMDConfiguration.class.getClassLoader();
            }
            if (classpath != null) {
                this.classLoader = new ClasspathClassLoader(classpath, this.classLoader);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public LanguageVersionDiscoverer getLanguageVersionDiscoverer() {
        return this.languageVersionDiscoverer;
    }

    public LanguageVersion getForceLanguageVersion() {
        return this.forceLanguageVersion;
    }

    public boolean isForceLanguageVersion() {
        return this.forceLanguageVersion != null;
    }

    public void setForceLanguageVersion(LanguageVersion forceLanguageVersion) {
        this.forceLanguageVersion = forceLanguageVersion;
        this.languageVersionDiscoverer.setForcedVersion(forceLanguageVersion);
    }

    public void setDefaultLanguageVersion(LanguageVersion languageVersion) {
        Objects.requireNonNull(languageVersion);
        this.setDefaultLanguageVersions(Arrays.asList(languageVersion));
    }

    public void setDefaultLanguageVersions(List<LanguageVersion> languageVersions) {
        for (LanguageVersion languageVersion : languageVersions) {
            Objects.requireNonNull(languageVersion);
            this.languageVersionDiscoverer.setDefaultLanguageVersion(languageVersion);
        }
    }

    public LanguageVersion getLanguageVersionOfFile(String fileName) {
        LanguageVersion languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersionForFile(fileName);
        if (languageVersion == null) {
            languageVersion = this.languageVersionDiscoverer.getDefaultLanguageVersion(LanguageRegistry.getLanguage("Java"));
        }
        return languageVersion;
    }

    @Deprecated
    public String getRuleSets() {
        if (this.ruleSets.isEmpty()) {
            return null;
        }
        return StringUtils.join(this.ruleSets, (String)",");
    }

    public List<String> getRuleSetPaths() {
        return this.ruleSets;
    }

    public void setRuleSets(List<String> ruleSetPaths) {
        this.ruleSets = new ArrayList<String>(ruleSetPaths);
    }

    public void addRuleSet(String rulesetPath) {
        AssertionUtil.requireParamNotNull("rulesetPath", rulesetPath);
        this.ruleSets.add(rulesetPath);
    }

    @Deprecated
    public void setRuleSets(String ruleSets) {
        this.ruleSets = ruleSets == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(ruleSets.split(",")));
    }

    public RulePriority getMinimumPriority() {
        return this.minimumPriority;
    }

    public void setMinimumPriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
    }

    @Deprecated
    public String getInputPaths() {
        return this.inputPaths.isEmpty() ? null : StringUtils.join(this.inputPaths, (String)",");
    }

    @Deprecated
    public List<String> getAllInputPaths() {
        ArrayList<String> ret = new ArrayList<String>(this.inputPaths.size());
        for (Path p : this.inputPaths) {
            ret.add(p.toString());
        }
        return Collections.unmodifiableList(ret);
    }

    public List<Path> getInputPathList() {
        return Collections.unmodifiableList(this.inputPaths);
    }

    @Deprecated
    public void setInputPaths(String inputPaths) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String s : inputPaths.split(",")) {
            paths.add(Paths.get(s, new String[0]));
        }
        this.inputPaths = paths;
    }

    @Deprecated
    public void setInputPaths(List<String> inputPaths) {
        ArrayList<Path> paths = new ArrayList<Path>(inputPaths.size());
        for (String s : inputPaths) {
            paths.add(Paths.get(s, new String[0]));
        }
        this.inputPaths = paths;
    }

    public void setInputPathList(List<Path> inputPaths) {
        this.inputPaths = new ArrayList<Path>(inputPaths);
    }

    @Deprecated
    public void addInputPath(String inputPath) {
        Objects.requireNonNull(inputPath);
        this.inputPaths.add(Paths.get(inputPath, new String[0]));
    }

    public void addInputPath(Path inputPath) {
        Objects.requireNonNull(inputPath);
        this.inputPaths.add(inputPath);
    }

    @Deprecated
    public String getInputFilePath() {
        return this.inputFilePath == null ? null : this.inputFilePath.toString();
    }

    public Path getInputFile() {
        return this.inputFilePath;
    }

    @Deprecated
    public String getIgnoreFilePath() {
        return this.ignoreFilePath == null ? null : this.ignoreFilePath.toString();
    }

    public Path getIgnoreFile() {
        return this.ignoreFilePath;
    }

    @Deprecated
    public void setInputFilePath(String inputFilePath) {
        this.inputFilePath = inputFilePath == null ? null : Paths.get(inputFilePath, new String[0]);
    }

    public void setInputFilePath(Path inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    @Deprecated
    public void setIgnoreFilePath(String ignoreFilePath) {
        this.ignoreFilePath = ignoreFilePath == null ? null : Paths.get(ignoreFilePath, new String[0]);
    }

    public void setIgnoreFilePath(Path ignoreFilePath) {
        this.ignoreFilePath = ignoreFilePath;
    }

    @Deprecated
    public String getInputUri() {
        return this.inputUri == null ? null : this.inputUri.toString();
    }

    public URI getUri() {
        return this.inputUri;
    }

    @Deprecated
    public void setInputUri(String inputUri) {
        this.inputUri = inputUri == null ? null : URI.create(inputUri);
    }

    public void setInputUri(URI inputUri) {
        this.inputUri = inputUri;
    }

    @Deprecated
    public boolean isReportShortNames() {
        return this.reportShortNames;
    }

    @Deprecated
    public void setReportShortNames(boolean reportShortNames) {
        this.reportShortNames = reportShortNames;
    }

    public Renderer createRenderer() {
        return this.createRenderer(false);
    }

    public Renderer createRenderer(boolean withReportWriter) {
        Renderer renderer = RendererFactory.createRenderer(this.reportFormat, this.reportProperties);
        renderer.setShowSuppressedViolations(this.showSuppressedViolations);
        if (this.reportShortNames && this.inputPaths != null) {
            renderer.setUseShortNames(this.getAllInputPaths());
        }
        if (withReportWriter) {
            renderer.setReportFile(this.getReportFile());
        }
        return renderer;
    }

    public String getReportFormat() {
        return this.reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    @Deprecated
    public String getReportFile() {
        return this.reportFile == null ? null : this.reportFile.toString();
    }

    public Path getReportFilePath() {
        return this.reportFile;
    }

    @Deprecated
    public void setReportFile(String reportFile) {
        this.reportFile = reportFile == null ? null : Paths.get(reportFile, new String[0]);
    }

    public void setReportFile(Path reportFile) {
        this.reportFile = reportFile;
    }

    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    public Properties getReportProperties() {
        return this.reportProperties;
    }

    public void setReportProperties(Properties reportProperties) {
        this.reportProperties = reportProperties;
    }

    @Deprecated
    public boolean isStressTest() {
        return this.stressTest;
    }

    @Deprecated
    public void setStressTest(boolean stressTest) {
        this.stressTest = stressTest;
    }

    @Deprecated
    public boolean isBenchmark() {
        return this.benchmark;
    }

    @Deprecated
    public void setBenchmark(boolean benchmark) {
        this.benchmark = benchmark;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public boolean isRuleSetFactoryCompatibilityEnabled() {
        return this.ruleSetFactoryCompatibilityEnabled;
    }

    public void setRuleSetFactoryCompatibilityEnabled(boolean ruleSetFactoryCompatibilityEnabled) {
        this.ruleSetFactoryCompatibilityEnabled = ruleSetFactoryCompatibilityEnabled;
    }

    public AnalysisCache getAnalysisCache() {
        if (this.analysisCache == null || this.isIgnoreIncrementalAnalysis() && !(this.analysisCache instanceof NoopAnalysisCache)) {
            this.setAnalysisCache(new NoopAnalysisCache());
        }
        return this.analysisCache;
    }

    public void setAnalysisCache(AnalysisCache cache) {
        this.analysisCache = cache == null ? new NoopAnalysisCache() : cache;
    }

    public void setAnalysisCacheLocation(String cacheLocation) {
        this.setAnalysisCache(cacheLocation == null ? new NoopAnalysisCache() : new FileAnalysisCache(new File(cacheLocation)));
    }

    public void setIgnoreIncrementalAnalysis(boolean noCache) {
        this.ignoreIncrementalAnalysis = noCache;
    }

    public boolean isIgnoreIncrementalAnalysis() {
        return this.ignoreIncrementalAnalysis;
    }

    public void addRelativizeRoot(Path path) {
        this.relativizeRoots.add(Objects.requireNonNull(path));
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Relativize root should be a directory: " + path);
        }
    }

    public void addRelativizeRoots(List<Path> paths) {
        for (Path path : paths) {
            this.addRelativizeRoot(path);
        }
    }

    public List<Path> getRelativizeRoots() {
        return Collections.unmodifiableList(this.relativizeRoots);
    }
}

