/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.AbstractFieldInfo;
import apex.jorje.semantic.symbol.member.variable.VariableValidator;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SObjectFieldInfo
extends AbstractFieldInfo {
    private static final ValidateStoreFunction NOOP = (validator, sobjectField, context) -> true;
    private final Category category;
    private final ValidateStoreFunction validateStoreFunction;
    private final boolean isColumnInfo;
    private final boolean isPrimaryKey;
    private final List<TypeInfo> polymorphicTypes;
    private final Namespace namespace;

    private SObjectFieldInfo(Builder builder) {
        super(builder);
        this.category = builder.category;
        this.validateStoreFunction = builder.validateStoreFunction;
        this.isColumnInfo = builder.isColumnInfo;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.polymorphicTypes = builder.polymorphicTypes;
        this.namespace = builder.namespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T, C> T accept(VariableVisitor<T, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isColumnInfo() {
        return this.isColumnInfo;
    }

    public boolean validateStore(VariableValidator validator, VariableVisitor.Context context) {
        return this.validateStoreFunction.validate(validator, this, context);
    }

    @Override
    public Member.Type getMemberType() {
        return Member.Type.FIELD;
    }

    public List<TypeInfo> getPolymorphicTypes() {
        return this.polymorphicTypes;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    static /* synthetic */ ValidateStoreFunction access$700() {
        return NOOP;
    }

    public static class Builder
    extends AbstractFieldInfo.Builder<Builder, SObjectFieldInfo> {
        private Category category;
        private ValidateStoreFunction validateStoreFunction = SObjectFieldInfo.access$700();
        private boolean isColumnInfo = true;
        private boolean isPrimaryKey;
        private List<TypeInfo> polymorphicTypes = ImmutableList.of();
        private Namespace namespace = Namespaces.EMPTY;

        private Builder() {
        }

        public Builder setCategory(Category category) {
            this.category = category;
            return this;
        }

        @SfdcCalled
        public Builder setPrimaryKey(boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        @SfdcCalled
        public Builder setValidateStoreFunction(ValidateStoreFunction validateStoreFunction) {
            this.validateStoreFunction = validateStoreFunction;
            return this;
        }

        public Builder setColumnInfo(boolean isColumnInfo) {
            this.isColumnInfo = isColumnInfo;
            return this;
        }

        @SfdcCalled
        public Builder setPolymorphicTypes(List<TypeInfo> polymorphicTypes) {
            this.polymorphicTypes = polymorphicTypes;
            return this;
        }

        @SfdcCalled
        public Builder setNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        protected SObjectFieldInfo creator() {
            return new SObjectFieldInfo(this);
        }
    }

    public static interface ValidateStoreFunction {
        public boolean validate(VariableValidator var1, SObjectFieldInfo var2, VariableVisitor.Context var3);
    }

    public static enum Category {
        REGULAR(0),
        FOREIGN_KEY(1),
        AGGREGATE(2),
        ID_LIST(3);

        private final byte categoryNum;
        private static final Map<Byte, Category> map;

        private Category(int num) {
            this.categoryNum = (byte)num;
        }

        public static Category valueOf(byte categoryNum) {
            return map.get(categoryNum);
        }

        public byte getValue() {
            return this.categoryNum;
        }

        static {
            map = new HashMap<Byte, Category>();
            for (Category category : Category.values()) {
                map.put(category.categoryNum, category);
            }
        }
    }
}

