/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.rename;

import apex.common.base.Result;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.references.ReferenceLocationProvider;
import apex.jorje.lsp.api.rename.RenameHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.api.workspace.DependentCompilationTracker;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.rename.RenameUtil;
import apex.jorje.lsp.impl.visitors.FieldNameConflictScope;
import apex.jorje.lsp.impl.visitors.InnerUserClassScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.details.CodeUnitDetailsProvider;
import apex.jorje.services.I18nSupport;
import com.google.inject.Provider;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRenameHandler
implements RenameHandler {
    private static final Logger logger = LoggerFactory.getLogger(FieldRenameHandler.class);
    private final Variable variable;
    private final RenameParams renameParams;
    private final ApexCompilerService compilerService;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ReferenceLocationProvider referenceLocationProvider;
    private final ApexDocumentService documentService;
    private final VisitorFactory visitorFactory;
    private final DependentCompilationTracker dependentCompilationTracker;

    FieldRenameHandler(Variable variable, RenameParams renameParams, ApexCompilerService compilerService, Provider<ApexIndex> apexIndexProvider, ReferenceLocationProvider referenceLocationProvider, ApexDocumentService apexDocumentService, VisitorFactory visitorFactory, DependentCompilationTracker dependentCompilationTracker) {
        this.variable = variable;
        this.renameParams = renameParams;
        this.compilerService = compilerService;
        this.apexIndexProvider = apexIndexProvider;
        this.referenceLocationProvider = referenceLocationProvider;
        this.documentService = apexDocumentService;
        this.visitorFactory = visitorFactory;
        this.dependentCompilationTracker = dependentCompilationTracker;
    }

    @Override
    public List<Either<TextDocumentEdit, ResourceOperation>> getDocumentChanges() {
        List<Location> fieldReferences = this.referenceLocationProvider.getReferenceLocations((ApexIndex)this.apexIndexProvider.get(), this.variable);
        Map<String, List<Location>> uriToLocations = fieldReferences.stream().collect(Collectors.groupingBy(Location::getUri));
        List<Document> sourceDocuments = uriToLocations.keySet().stream().map(u -> this.documentService.retrieve(URI.create(u))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<CodeUnit> codeUnits = this.compilerService.compile(sourceDocuments, ParserEngine.HiddenTokenBehavior.IGNORE);
        Map<String, CodeUnit> uriToCodeUnit = RenameUtil.getUriToCodeUnitMap(sourceDocuments, codeUnits);
        Map<String, Document> uriToSourceDocument = sourceDocuments.stream().collect(Collectors.toMap(doc -> doc.getUri().toString(), doc -> doc));
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> documentChanges = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>();
        for (Map.Entry<String, List<Location>> entry : uriToLocations.entrySet()) {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            for (Location loc : entry.getValue()) {
                try {
                    int lineOffset = uriToSourceDocument.get(entry.getKey()).getLineOffset(loc.getRange().getStart().getLine());
                    int offset = lineOffset + loc.getRange().getStart().getCharacter();
                    FieldNameConflictScope fieldNameConflictScope = new FieldNameConflictScope(this.renameParams.getNewName(), offset);
                    uriToCodeUnit.get(entry.getKey()).getNode().traverse(this.visitorFactory.createFieldNameConflictVisitor(), fieldNameConflictScope);
                    String newText = fieldNameConflictScope.getNodeHavingConflict().isPresent() && !RenameUtil.isFullyQualifiedReference(fieldNameConflictScope.getNodeHavingConflict().get(), offset) ? RenameUtil.getFullyQualifiedName(this.variable, this.renameParams.getNewName()) : this.renameParams.getNewName();
                    edits.add(new TextEdit(loc.getRange(), newText));
                }
                catch (BadLocationException exception) {
                    logger.error("Encountered a bad location while providing rename", (Throwable)exception);
                }
            }
            if (TypeInfoUtil.isInnerType(this.variable.getDefiningType()) && TypeInfoEquivalence.isEquivalent(this.variable.getDefiningType().getEnclosingType(), uriToCodeUnit.get(entry.getKey()).getType())) {
                if (this.variable.getDefiningType().getEnclosingType().fields().all().stream().filter(fieldInfo -> fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)).map(Member::getName).anyMatch(this.renameParams.getNewName()::equalsIgnoreCase)) {
                    InnerUserClassScope innerUserClassScope = new InnerUserClassScope(this.variable.getDefiningType());
                    uriToCodeUnit.get(entry.getKey()).getNode().traverse(this.visitorFactory.createInnerUserClassVisitor(), innerUserClassScope);
                    edits.addAll(RenameUtil.fieldNameRewrites(innerUserClassScope.getUserClass(), this.renameParams.getNewName()));
                }
            }
            documentChanges.add((Either<TextDocumentEdit, ResourceOperation>)Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(entry.getKey(), null), edits)));
        }
        RenameUtil.addDependentCompilation(this.dependentCompilationTracker, this.variable.getDefiningType().getCodeUnitDetails().getSource().getKnownName(), uriToLocations.keySet());
        return documentChanges;
    }

    @Override
    public Optional<String> getConflictError() {
        if (this.renameParams.getNewName().equalsIgnoreCase(this.variable.getName())) {
            return Optional.empty();
        }
        return this.getFieldRenameConflictError(this.compilerService.getSymbolResolver(), this.apexIndexProvider, this.renameParams, this.variable);
    }

    @Override
    public Optional<String> canBeRenamed() {
        return CodeUnitDetailsProvider.isUserSourced(this.variable.getDefiningType().getCodeUnitDetails()) ? Optional.empty() : Optional.of(I18nSupport.getLabel("cannot.rename"));
    }

    @Override
    public Optional<String> isIdentifierNameInvalid() {
        Result<Void> validationResult = IdentifierValidator.get().validate(this.variable.getDefiningType(), this.renameParams.getNewName(), IdentifierValidator.Type.VARIABLE, false, false);
        if (validationResult.hasError()) {
            return Optional.of(validationResult.getError());
        }
        return Optional.empty();
    }

    private Optional<String> getFieldRenameConflictError(SymbolResolver symbols, Provider<ApexIndex> apexIndexProvider, RenameParams params, Variable variable) {
        if (variable.getDefiningType().fields().all().stream().map(Member::getName).anyMatch(params.getNewName()::equalsIgnoreCase)) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", variable.getDefiningType().getApexName()));
        }
        Optional<TypeInfo> ancestorType = this.getAncestorTypeHavingFieldConflict(apexIndexProvider, symbols, params.getNewName(), variable.getDefiningType());
        if (ancestorType.isPresent()) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", ancestorType.get().getApexName()));
        }
        Optional<TypeInfo> descendantType = this.getDescendantTypeHavingFieldConflict(apexIndexProvider, symbols, params.getNewName(), variable.getDefiningType());
        if (!variable.getModifiers().has(ModifierTypeInfos.PRIVATE) && descendantType.isPresent()) {
            return Optional.of(I18nSupport.getLabel("new.name.member.conflict", descendantType.get().getApexName()));
        }
        return Optional.empty();
    }

    private Optional<TypeInfo> getDescendantTypeHavingFieldConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, String newName, TypeInfo typeInfo) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId apexId = apexIndex.findExactTypeId(typeInfo.getApexName());
            Optional<TypeInfo> optional = this.findDescendantTypeHavingFieldConflict(apexIndexProvider, symbols, newName, apexId.getChildren(), new HashSet<String>());
            return optional;
        }
    }

    private Optional<TypeInfo> findDescendantTypeHavingFieldConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, String newName, List<ApexTypeId> children, Set<String> visitedTypes) {
        for (ApexTypeId childId : children) {
            TypeInfo apexTypeInfo = RenameUtil.getTypeInfo(apexIndexProvider, symbols, childId);
            if (apexTypeInfo.fields().all().stream().map(Member::getName).anyMatch(newName::equalsIgnoreCase)) {
                return Optional.of(apexTypeInfo);
            }
            if (visitedTypes.contains(apexTypeInfo.getApexName())) continue;
            return this.findDescendantTypeHavingFieldConflict(apexIndexProvider, symbols, newName, childId.getChildren(), visitedTypes);
        }
        return Optional.empty();
    }

    private Optional<TypeInfo> getAncestorTypeHavingFieldConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, String newName, TypeInfo typeInfo) {
        ApexIndex apexIndex = (ApexIndex)apexIndexProvider.get();
        try (IReader ignored = apexIndex.getNd().acquireReadLock();){
            ApexTypeId apexId = apexIndex.findExactTypeId(typeInfo.getApexName());
            Optional<TypeInfo> optional = this.findAncestorTypeHavingFieldConflict(apexIndexProvider, symbols, newName, apexId.getParent(), new HashSet<String>());
            return optional;
        }
    }

    private Optional<TypeInfo> findAncestorTypeHavingFieldConflict(Provider<ApexIndex> apexIndexProvider, SymbolResolver symbols, String newName, ApexTypeId apexId, Set<String> visitedTypes) {
        TypeInfo apexTypeInfo = RenameUtil.getTypeInfo(apexIndexProvider, symbols, apexId);
        visitedTypes.add(apexId.getApexName().getString());
        if (apexTypeInfo.fields().all().stream().filter(f -> !f.getModifiers().has(ModifierTypeInfos.PRIVATE)).map(Member::getName).anyMatch(newName::equalsIgnoreCase)) {
            return Optional.of(apexTypeInfo);
        }
        if (apexId.getParent() != null && !visitedTypes.contains(apexId.getParent().getApexName().getString())) {
            return this.findAncestorTypeHavingFieldConflict(apexIndexProvider, symbols, newName, apexId.getParent(), visitedTypes);
        }
        return Optional.empty();
    }
}

