/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.services.I18nSupport;

public class ContinueStatement
extends Statement {
    private final Location loc;

    public ContinueStatement(AstNode definingNode, Stmnt.ContinueStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        visitor.visit(this, scope);
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        if (!scope.isLooping()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.continue"));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        assert (!emitter.getLoopStack().isEmpty());
        emitter.emitStatementExecuted(this.loc, true, false);
        emitter.getLoopStack().emitContinue(this.loc);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }
}

