/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.internal.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class AssertionUtil {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("[\\w$]+(\\.[\\w$]+)*|");
    private static final Pattern BINARY_NAME_PATTERN = Pattern.compile("[\\w$]+(?:\\.[\\w$]+)*(?:\\[])*");

    private AssertionUtil() {
    }

    public static boolean isValidJavaPackageName(CharSequence name) {
        AssertionUtil.requireParamNotNull("name", name);
        return PACKAGE_PATTERN.matcher(name).matches();
    }

    public static void assertValidJavaBinaryName(CharSequence name) {
        if (!AssertionUtil.isJavaBinaryName(name)) {
            throw new IllegalArgumentException("Not a Java binary name '" + name + "'");
        }
    }

    public static boolean isJavaBinaryName(CharSequence name) {
        return BINARY_NAME_PATTERN.matcher(name).matches();
    }

    public static <T> T requireParamNotNull(String paramName, T obj) {
        if (obj == null) {
            throw new NullPointerException("Parameter " + paramName + " is null");
        }
        return obj;
    }

    public static AssertionError shouldNotReachHere(String message) {
        String prefix = "This should be unreachable";
        message = StringUtils.isBlank((CharSequence)message) ? prefix : prefix + ": " + message;
        return new AssertionError((Object)message);
    }
}

