/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.common;

import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.common.TestQueryValidators;
import apex.jorje.semantic.common.TestSymbolProvider;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.ValidationSettings;
import apex.jorje.semantic.compiler.parser.ParserEngine;
import apex.jorje.semantic.compiler.sfdc.NoopCompilerProgressCallback;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.matchers.ErrorMatchers;
import apex.jorje.services.Version;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class FullCompileTester {
    private final List<SourceFile> sources = new ArrayList<SourceFile>();
    private final TestSymbolProvider symbolProvider;
    private final TestAccessEvaluator accessEvaluator;
    private QueryValidator queryValidator;
    private AstVisitor<AdditionalPassScope> additionalPass = null;
    private ParserEngine.Type parserType = ParserEngine.Type.NAMED;
    private ParserEngine.HiddenTokenBehavior hiddenTokenBehavior;
    private ValidationSettings validationSettings;

    public FullCompileTester() {
        this.symbolProvider = new TestSymbolProvider();
        this.accessEvaluator = new TestAccessEvaluator();
        this.queryValidator = new TestQueryValidators.Noop();
        this.hiddenTokenBehavior = ParserEngine.HiddenTokenBehavior.IGNORE;
        this.validationSettings = ValidationSettings.getServerCompileSettings();
    }

    public FullCompileTester setAnonymous() {
        this.parserType = ParserEngine.Type.ANONYMOUS;
        return this;
    }

    public FullCompileTester setAdditionalPass(AstVisitor<AdditionalPassScope> additionalPass) {
        this.additionalPass = additionalPass;
        return this;
    }

    public FullCompileTester setQueryValidator(TestQueryValidators.Error queryValidator) {
        this.queryValidator = queryValidator;
        return this;
    }

    public FullCompileTester setValidationSettings(ValidationSettings validationSettings) {
        this.validationSettings = validationSettings;
        return this;
    }

    public FullCompileTester setHiddenTokenBehavior(ParserEngine.HiddenTokenBehavior hiddenTokenBehavior) {
        this.hiddenTokenBehavior = hiddenTokenBehavior;
        return this;
    }

    public TestAccessEvaluator getAccessEvaluator() {
        return this.accessEvaluator;
    }

    public TestSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    public TestSourceFile startSource(String code) {
        return new TestSourceFile(code);
    }

    public FullCompileTester addSources(String code) {
        this.sources.add(SourceFile.builder().setBody(code).build());
        return this;
    }

    public FullCompileTester addSourceFiles(SourceFile code) {
        this.sources.add(code);
        return this;
    }

    public FullCompileTester addSourceFiles(SourceFile ... codes) {
        return this.addSourceFiles(MoreLists.asImmutableList(codes));
    }

    public FullCompileTester addSourceFiles(List<SourceFile> codes) {
        this.sources.addAll(codes);
        return this;
    }

    public FullCompileTester addSources(String ... codes) {
        this.addSources(MoreLists.asImmutableList(codes));
        return this;
    }

    public FullCompileTester addSources(List<String> codes) {
        assert (!codes.isEmpty()) : "sources was empty and if you want to test something should be non empty";
        this.sources.addAll(codes.stream().map(code -> SourceFile.builder().setBody((String)code).build()).collect(Collectors.toList()));
        return this;
    }

    public void assertSuccess() {
        this.compileAndAssertSuccess();
    }

    public ApexCompiler assertFailures(String failure) {
        return this.assertFailures(ImmutableList.of(failure));
    }

    public ApexCompiler assertFailures(String ... failures) {
        return this.assertFailures(MoreLists.asImmutableList(failures));
    }

    public ApexCompiler assertFailures(List<String> failures) {
        ApexCompiler compiler = this.buildCompiler(CompilerStage.EMIT);
        MatcherAssert.assertThat((String)"compile should NOT have been successful", compiler.getErrors(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(compiler.getErrors(), ErrorMatchers.containsErrors(failures));
        return compiler;
    }

    @SafeVarargs
    public final void assertFailures(Matcher<CompilationException> ... failures) {
        ApexCompiler compiler = this.buildCompiler(CompilerStage.EMIT);
        MatcherAssert.assertThat((String)"compile should NOT have been successful", compiler.getErrors(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
        MatcherAssert.assertThat(compiler.getErrors(), (Matcher)Matchers.contains(failures));
    }

    public void assertExceptions(CompilationException ... failures) {
        this.assertExceptions(MoreLists.asImmutableList(failures));
    }

    private void assertExceptions(List<CompilationException> failures) {
        ApexCompiler compiler = this.buildCompiler(CompilerStage.EMIT);
        MatcherAssert.assertThat(compiler.getErrors(), (Matcher)Matchers.is(failures));
    }

    public ApexCompiler compileAndAssertSuccess() {
        ApexCompiler compiler = this.buildCompiler(CompilerStage.EMIT);
        MatcherAssert.assertThat((String)"compile should have been successful", compiler.getErrors(), (Matcher)Matchers.empty());
        return compiler;
    }

    public ApexCompiler compileAndAssertSuccess(CompilerStage stage) {
        ApexCompiler compiler = this.buildCompiler(stage);
        MatcherAssert.assertThat((String)"compile should have been successful", compiler.getErrors(), (Matcher)Matchers.empty());
        return compiler;
    }

    private ApexCompiler buildCompiler(CompilerStage stage) {
        ApexCompiler compiler = this.buildApexCompiler();
        compiler.compile(stage);
        this.sources.clear();
        return compiler;
    }

    private ApexCompiler buildApexCompiler() {
        assert (this.parserType == ParserEngine.Type.NAMED || this.sources.size() == 1) : "only one anonymous source is allowed";
        assert (!this.sources.isEmpty()) : "sources was empty and if you want to test something should be non empty";
        CompilationInput input = new CompilationInput(this.sources, this.symbolProvider, this.accessEvaluator, this.queryValidator, this.additionalPass, NoopCompilerProgressCallback.get());
        return ApexCompiler.builder().setInput(input).setParserType(this.parserType).setHiddenTokenBehavior(this.hiddenTokenBehavior).setValidationSettings(this.validationSettings).build();
    }

    public class TestSourceFile {
        private final SourceFile.Builder builder;

        private TestSourceFile(String body) {
            this.builder = SourceFile.builder().setBody(body);
        }

        public TestSourceFile setVersion(Version version) {
            this.builder.setVersion(version);
            return this;
        }

        public TestSourceFile setTrusted(boolean isTrusted) {
            this.builder.setTrusted(isTrusted);
            return this;
        }

        public TestSourceFile setFileBased(boolean isFileBased) {
            this.builder.setFileBased(isFileBased);
            return this;
        }

        public TestSourceFile setNamespace(Namespace namespace) {
            this.builder.setNamespace(namespace);
            return this;
        }

        public FullCompileTester build() {
            FullCompileTester.this.sources.add(this.builder.build());
            return FullCompileTester.this;
        }
    }
}

