/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.jorje.semantic.ast.modifier.rule.FieldContext;
import apex.jorje.semantic.ast.modifier.rule.MethodContext;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;

public class AnnotationRuleUtil {
    private AnnotationRuleUtil() {
    }

    static void validate(MethodContext context, ModifierOrAnnotationTypeInfo modifier, TypeInfoVisitor<Boolean> parameterTypeVisitor, TypeInfoVisitor<Boolean> returnTypeVisitor) {
        MethodInfo method = context.getMethodInfo();
        for (TypeInfo parameter : method.getParameterTypes()) {
            if (parameter.accept(parameterTypeVisitor).booleanValue()) continue;
            context.addNodeError(I18nSupport.getLabel("method.does.not.support.parameter.type", modifier, parameter));
        }
        if (!method.getReturnType().accept(returnTypeVisitor).booleanValue()) {
            context.addNodeError(I18nSupport.getLabel("method.does.not.support.return.type", modifier, method.getReturnType()));
        }
    }

    static void validate(FieldContext context, ModifierOrAnnotationTypeInfo modifier, TypeInfoVisitor<Boolean> visitor) {
        FieldInfo field = context.getFieldInfo();
        if (!field.getType().accept(visitor).booleanValue()) {
            context.addNodeError(I18nSupport.getLabel("field.does.not.support.type", modifier, field.getType()));
        }
    }

    static boolean isConnectApiAndNotBatchResult(TypeInfo type) {
        return Namespace.equals(Namespaces.CONNECT_API, type.getNamespace()) && !type.getApexName().equalsIgnoreCase("ConnectApi.BatchResult");
    }

    static boolean hasConnectDeserializer(AccessEvaluator evaluator, TypeInfo type) {
        return type.getModifiers().has(AnnotationTypeInfos.USE_CONNECT_DESERIALIZER) && evaluator.hasConnectDeserializer(type);
    }

    static boolean hasConnectSerializer(TypeInfo type) {
        return type.getModifiers().has(AnnotationTypeInfos.USE_CONNECT_SERIALIZER);
    }
}

