/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.pmd.internal.LanguageServiceBase;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import org.apache.commons.lang3.StringUtils;

public final class LanguageRegistry
extends LanguageServiceBase<Language> {
    private static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return o1.getTerseName().compareToIgnoreCase(o2.getTerseName());
        }
    };
    private static final LanguageServiceBase.NameExtractor<Language> NAME_EXTRACTOR = new LanguageServiceBase.NameExtractor<Language>(){

        @Override
        public String getName(Language language) {
            return language.getName();
        }
    };
    private static final LanguageRegistry INSTANCE = new LanguageRegistry();

    private LanguageRegistry() {
        super(Language.class, LANGUAGE_COMPARATOR, NAME_EXTRACTOR);
    }

    @Deprecated
    public static LanguageRegistry getInstance() {
        return INSTANCE;
    }

    public static Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            LanguageVersionHandler languageVersionHandler = language.getDefaultVersion().getLanguageVersionHandler();
            boolean pmdSupported = false;
            if (languageVersionHandler != null) {
                ParserOptions defaultParserOptions = languageVersionHandler.getDefaultParserOptions();
                Parser parser = languageVersionHandler.getParser(defaultParserOptions);
                pmdSupported = parser.canParse();
            }
            if (!pmdSupported) continue;
            languages.add(language);
        }
        return languages;
    }

    public static Language getLanguage(String languageName) {
        return (Language)LanguageRegistry.getInstance().languages.get(languageName);
    }

    public static Language getDefaultLanguage() {
        Collection allLanguages;
        Language defaultLanguage = LanguageRegistry.getLanguage("Java");
        if (defaultLanguage == null && !(allLanguages = LanguageRegistry.getInstance().languages.values()).isEmpty()) {
            defaultLanguage = (Language)allLanguages.iterator().next();
        }
        return defaultLanguage;
    }

    public static Language findLanguageByTerseName(String terseName) {
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.getTerseName().equals(terseName)) continue;
            return language;
        }
        return null;
    }

    @Deprecated
    public static LanguageVersion findLanguageVersionByTerseName(String terseNameAndVersion) {
        String terseName;
        String version;
        if (terseNameAndVersion.contains(" ")) {
            version = StringUtils.trimToNull((String)terseNameAndVersion.substring(terseNameAndVersion.lastIndexOf(32) + 1));
            terseName = terseNameAndVersion.substring(0, terseNameAndVersion.lastIndexOf(32));
        } else {
            version = null;
            terseName = terseNameAndVersion;
        }
        Language language = LanguageRegistry.findLanguageByTerseName(terseName);
        if (language != null) {
            if (version == null) {
                return language.getDefaultVersion();
            }
            return language.getVersion(version);
        }
        return null;
    }

    public static List<Language> findByExtension(String extensionWithoutDot) {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (Language language : LanguageRegistry.getInstance().languages.values()) {
            if (!language.hasExtension(extensionWithoutDot)) continue;
            languages.add(language);
        }
        return languages;
    }

    @Deprecated
    public static List<LanguageVersion> findAllVersions() {
        ArrayList<LanguageVersion> versions = new ArrayList<LanguageVersion>();
        for (Language language : LanguageRegistry.getLanguages()) {
            versions.addAll(language.getVersions());
        }
        return versions;
    }

    @Deprecated
    public static List<Language> findWithRuleSupport() {
        return new ArrayList<Language>(LanguageRegistry.getLanguages());
    }

    @Deprecated
    public static String commaSeparatedTerseNamesForLanguage(List<Language> languages) {
        StringBuilder builder = new StringBuilder();
        for (Language language : languages) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(language.getTerseName());
        }
        return builder.toString();
    }

    @Deprecated
    public static String commaSeparatedTerseNamesForLanguageVersion(List<LanguageVersion> languageVersions) {
        if (languageVersions == null || languageVersions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(languageVersions.get(0).getTerseName());
        for (int i = 1; i < languageVersions.size(); ++i) {
            builder.append(", ").append(languageVersions.get(i).getTerseName());
        }
        return builder.toString();
    }
}

