/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.common.tuple.BooleanHolder;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.WhenBlock;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.PolymorphicTypes;
import apex.jorje.semantic.ast.statement.ElseWhenBlock;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.TypeWhenBlock;
import apex.jorje.semantic.ast.statement.ValueWhenBlock;
import apex.jorje.semantic.ast.statement.WhenBlock;
import apex.jorje.semantic.ast.statement.WhenCase;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.services.I18nSupport;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Label;

public class SwitchStatement
extends Statement {
    private static final Set<TypeInfo> BASIC_TYPES_ALLOWED = ImmutableSet.of(TypeInfos.INTEGER, TypeInfos.LONG, TypeInfos.STRING, TypeInfos.SOBJECT);
    private final Location loc;
    private final Expression expression;
    private final List<WhenBlock> whenBlocks;
    private final Label exit;
    private int varIndex;

    public SwitchStatement(AstNode definingNode, Stmnt.SwitchStmnt stmnt) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.expression = AstNodes.get().create((AstNode)this, stmnt.expr);
        final BooleanHolder hasElseBlock = new BooleanHolder(false);
        this.whenBlocks = AstNodes.filterNullTransform(stmnt.whenBlocks, w -> w.match(new WhenBlock.MatchBlock<WhenBlock>(){

            @Override
            public WhenBlock _case(WhenBlock.ValueWhen x) {
                return new ValueWhenBlock(SwitchStatement.this, x);
            }

            @Override
            public WhenBlock _case(WhenBlock.TypeWhen x) {
                return new TypeWhenBlock(SwitchStatement.this, x);
            }

            @Override
            public WhenBlock _case(WhenBlock.ElseWhen x) {
                hasElseBlock.value = true;
                return new ElseWhenBlock(SwitchStatement.this, x);
            }
        }));
        this.exit = new Label();
        boolean areWhenBlocksReturnable = this.whenBlocks.stream().map(WhenBlock::getBlock).allMatch(Statement::isReturnable);
        if (areWhenBlocksReturnable && hasElseBlock.value) {
            this.setReturnable();
        }
    }

    private static void validateWhenType(SwitchStatement switchStatement, WhenBlock node, TypeInfo type, Errors errors) {
        boolean canAssign = PolymorphicTypes.isAssignable(switchStatement.getDefiningType(), type, switchStatement.expression);
        if (!canAssign) {
            errors.markInvalid((AstNode)node, I18nSupport.getLabel("invalid.when.expression.type", type, switchStatement.getExpressionType()));
            errors.markInvalid(switchStatement);
        }
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            for (WhenBlock whenBlock : this.whenBlocks) {
                whenBlock.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.whenBlocks.isEmpty()) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("illegal.no.when.blocks"));
        }
        if (!this.validExpression(symbols, scope, errors)) {
            return;
        }
        for (WhenBlock whenBlock : this.whenBlocks) {
            whenBlock.validate(symbols, scope);
            if (!errors.isInvalid(whenBlock)) continue;
            errors.markInvalid(this);
        }
        AstVisitor whenValidator = TypeInfoEquivalence.isEquivalent(this.expression.getType(), TypeInfos.SOBJECT) ? new WhenTypeValidator(this) : new WhenValueValidator(this);
        this.traverse(whenValidator, scope);
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.getLoc(), true, false);
        this.expression.emit(emitter);
        this.varIndex = emitter.getMethodStack().peek().getLocalVariables().add();
        emitter.emitVar(Locations.NONE, 58, this.varIndex);
        for (WhenBlock whenBlock : this.whenBlocks) {
            whenBlock.emit(emitter);
        }
        emitter.emit(this.exit);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Label getExit() {
        return this.exit;
    }

    TypeInfo getExpressionType() {
        return this.expression.getType();
    }

    int getVarIndex() {
        return this.varIndex;
    }

    private boolean validExpression(SymbolResolver symbols, ValidationScope scope, Errors errors) {
        this.expression.validate(symbols, scope);
        if (errors.isInvalid(this.expression)) {
            errors.markInvalid(this);
            return false;
        }
        if (!BASIC_TYPES_ALLOWED.contains(this.expression.getType()) && this.expression.getType().getUnitType() != UnitType.ENUM) {
            scope.getErrors().markInvalid((AstNode)this.expression, I18nSupport.getLabel("illegal.switch.expression.type", this.expression.getType()));
            return false;
        }
        return true;
    }

    private static class WhenTypeValidator
    extends AstVisitor<SymbolScope> {
        private final SwitchStatement switchStatement;
        private final Set<Equivalence.Wrapper<TypeInfo>> types;
        private int index;

        private WhenTypeValidator(SwitchStatement switchStatement) {
            this.switchStatement = switchStatement;
            this.types = new HashSet<Equivalence.Wrapper<TypeInfo>>();
            this.index = 0;
        }

        @Override
        public boolean visit(SwitchStatement node, SymbolScope scope) {
            return true;
        }

        @Override
        public void visitEnd(ValueWhenBlock node, SymbolScope scope) {
            ++this.index;
            Errors errors = scope.getErrors();
            for (WhenCase whenCase : node.getWhenCases()) {
                TypeInfo type = whenCase.getType();
                if (TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.NULL)) {
                    if (this.types.add(type.getEquivalenceWrapper())) continue;
                    errors.markInvalid(this.switchStatement);
                    errors.markInvalid((AstNode)node, I18nSupport.getLabel("not.unique.when.value.or.type", type));
                    continue;
                }
                if (errors.isInvalid(node)) continue;
                errors.markInvalid(this.switchStatement);
                errors.markInvalid((AstNode)node, I18nSupport.getLabel("illegal.non.when.type"));
            }
        }

        @Override
        public void visitEnd(ElseWhenBlock node, SymbolScope scope) {
            ++this.index;
            if (this.index != this.switchStatement.whenBlocks.size()) {
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("when.else.not.last"));
            }
        }

        @Override
        public void visitEnd(TypeWhenBlock node, SymbolScope scope) {
            ++this.index;
            Errors errors = scope.getErrors();
            if (TypeInfoEquivalence.isEquivalent(node.getType(), this.switchStatement.getExpressionType())) {
                errors.markInvalid((AstNode)node, I18nSupport.getLabel("invalid.already.match.type", node.getType(), this.switchStatement.getExpressionType()));
            }
            SwitchStatement.validateWhenType(this.switchStatement, node, node.getType(), errors);
            if (!this.types.add(node.getType().getEquivalenceWrapper())) {
                errors.markInvalid(this.switchStatement);
                errors.markInvalid((AstNode)node, I18nSupport.getLabel("not.unique.when.value.or.type", node.getType()));
            }
        }
    }

    private static class WhenValueValidator
    extends AstVisitor<SymbolScope> {
        private final SwitchStatement switchStatement;
        private final Set<Object> values;
        private int index;

        private WhenValueValidator(SwitchStatement switchStatement) {
            this.switchStatement = switchStatement;
            this.values = new HashSet<Object>();
            this.index = 0;
        }

        @Override
        public boolean visit(SwitchStatement node, SymbolScope scope) {
            return true;
        }

        @Override
        public void visitEnd(ValueWhenBlock node, SymbolScope scope) {
            ++this.index;
            Errors errors = scope.getErrors();
            for (WhenCase whenCase : node.getWhenCases()) {
                SwitchStatement.validateWhenType(this.switchStatement, node, whenCase.getType(), errors);
                if (this.values.add(whenCase.getValue())) continue;
                errors.markInvalid(this.switchStatement);
                errors.markInvalid((AstNode)node, I18nSupport.getLabel("not.unique.when.value.or.type", whenCase.getValue()));
            }
        }

        @Override
        public void visitEnd(ElseWhenBlock node, SymbolScope scope) {
            ++this.index;
            if (this.index != this.switchStatement.whenBlocks.size()) {
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("when.else.not.last"));
            }
        }

        @Override
        public void visitEnd(TypeWhenBlock node, SymbolScope scope) {
            ++this.index;
            Errors errors = scope.getErrors();
            errors.markInvalid(this.switchStatement);
            errors.markInvalid((AstNode)node, I18nSupport.getLabel("illegal.when.type", this.switchStatement.getExpressionType()));
        }
    }
}

