/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.impl.visitors.CodeActionScope;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.services.I18nSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionsUtil {
    public static WorkspaceEdit getWorkspaceEdit(Expression node, List<TextEdit> edits) {
        Preconditions.checkNotNull(node, edits);
        return CodeActionsUtil.getWorkspaceEdit(node.getDefiningNode().getDefiningType().getCodeUnitDetails().getSource().getKnownName(), edits);
    }

    public static WorkspaceEdit getWorkspaceEdit(String uri, Range range, String newText) {
        Preconditions.checkNotNull(uri, newText);
        return CodeActionsUtil.getWorkspaceEdit(uri, ImmutableList.of(new TextEdit(range, newText)));
    }

    public static WorkspaceEdit getWorkspaceEdit(String uri, List<TextEdit> edits) {
        Preconditions.checkNotNull(uri, edits);
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        workspaceEdit.setDocumentChanges(ImmutableList.of(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits))));
        return workspaceEdit;
    }

    public static TextEdit buildTextEdit(int lineNum, int startIndex, int endIndex, String text) {
        return new TextEdit(new Range(new Position(lineNum, startIndex), new Position(lineNum, endIndex)), text);
    }

    public static String getNewStatementText(Expression node, CodeActionScope scope, String name) {
        String newStatementText = scope.getSource().substring(scope.getNodeStartOffset(), scope.getNodeEndOffset());
        return CodeActionsUtil.getLineIndentation(scope.getSource(), scope.getNodeDeclarationLine()) + node.getType().getApexName() + " " + name + " = " + newStatementText + ";\n";
    }

    public static String getLineIndentation(String source, int selectedLineNumber) {
        Preconditions.checkNotNull(source, selectedLineNumber);
        String[] textLines = source.split("[\\n|\\r]");
        String lineText = textLines[selectedLineNumber - 1];
        String[] parts = lineText.split("[A-Za-z]", 2);
        return parts[0];
    }

    public static Optional<CodeAction> buildCodeAction(String labelKey, String kind, Expression node, List<TextEdit> edits) {
        CodeAction codeAction = new CodeAction(I18nSupport.getLabel(labelKey));
        codeAction.setKind(kind);
        codeAction.setEdit(CodeActionsUtil.getWorkspaceEdit(node, edits));
        return Optional.of(codeAction);
    }
}

