/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.data.ast.BinaryOp;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.LiteralType;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.PostfixOp;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VersionRef;
import apex.jorje.data.soql.Query;
import apex.jorje.data.sosl.Search;
import java.util.List;
import java.util.Optional;

public abstract class Expr {
    private Expr() {
    }

    public static final Expr _AssignmentExpr(Expr left, AssignmentOp op, Expr right) {
        return new AssignmentExpr(left, op, right);
    }

    public static final Expr _TernaryExpr(Expr condition, Expr trueExpr, Expr falseExpr) {
        return new TernaryExpr(condition, trueExpr, falseExpr);
    }

    public static final Expr _BinaryExpr(Expr left, BinaryOp op, Expr right) {
        return new BinaryExpr(left, op, right);
    }

    public static final Expr _CastExpr(Location loc, Expr expr, TypeRef type) {
        return new CastExpr(loc, expr, type);
    }

    public static final Expr _InstanceOf(Expr expr, TypeRef type) {
        return new InstanceOf(expr, type);
    }

    public static final Expr _BooleanExpr(Expr left, BooleanOp op, Expr right) {
        return new BooleanExpr(left, op, right);
    }

    public static final Expr _TriggerVariableExpr(Location loc, Identifier variable) {
        return new TriggerVariableExpr(loc, variable);
    }

    public static final Expr _PackageVersionExpr(Location loc, VersionRef version) {
        return new PackageVersionExpr(loc, version);
    }

    public static final Expr _PrefixExpr(Location loc, Expr expr, PrefixOp op) {
        return new PrefixExpr(loc, expr, op);
    }

    public static final Expr _PostfixExpr(Location loc, Expr expr, PostfixOp op) {
        return new PostfixExpr(loc, expr, op);
    }

    public static final Expr _ArrayExpr(Expr expr, Expr index) {
        return new ArrayExpr(expr, index);
    }

    public static final Expr _VariableExpr(Optional<Expr> dottedExpr, boolean isSafeNav, List<Identifier> names) {
        return new VariableExpr(dottedExpr, isSafeNav, names);
    }

    public static final Expr _MethodCallExpr(Optional<Expr> dottedExpr, boolean isSafeNav, List<Identifier> names, List<Expr> inputParameters) {
        return new MethodCallExpr(dottedExpr, isSafeNav, names, inputParameters);
    }

    public static final Expr _JavaMethodCallExpr(Location loc, List<Identifier> names, List<Expr> inputParameters) {
        return new JavaMethodCallExpr(loc, names, inputParameters);
    }

    public static final Expr _JavaVariableExpr(Location loc, List<Identifier> names) {
        return new JavaVariableExpr(loc, names);
    }

    public static final Expr _SuperMethodCallExpr(Location loc, List<Expr> inputParameters) {
        return new SuperMethodCallExpr(loc, inputParameters);
    }

    public static final Expr _SuperVariableExpr(Location loc) {
        return new SuperVariableExpr(loc);
    }

    public static final Expr _ThisMethodCallExpr(Location loc, List<Expr> inputParameters) {
        return new ThisMethodCallExpr(loc, inputParameters);
    }

    public static final Expr _ThisVariableExpr(Location loc) {
        return new ThisVariableExpr(loc);
    }

    public static final Expr _ClassRefExpr(Location loc, TypeRef type) {
        return new ClassRefExpr(loc, type);
    }

    public static final Expr _LiteralExpr(Location loc, LiteralType type, Object literal) {
        return new LiteralExpr(loc, type, literal);
    }

    public static final Expr _NewExpr(Location loc, NewObject creator) {
        return new NewExpr(loc, creator);
    }

    public static final Expr _NestedExpr(Expr expr) {
        return new NestedExpr(expr);
    }

    public static final Expr _SoqlExpr(Location loc, String rawQuery, Query query) {
        return new SoqlExpr(loc, rawQuery, query);
    }

    public static final Expr _SoslExpr(Location loc, String rawQuery, Search search) {
        return new SoslExpr(loc, rawQuery, search);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class SoslExpr
    extends Expr {
        public Location loc;
        public String rawQuery;
        public Search search;

        public SoslExpr(Location loc, String rawQuery, Search search) {
            this.loc = loc;
            this.rawQuery = rawQuery;
            this.search = search;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.rawQuery == null ? 0 : this.rawQuery.hashCode());
            result = 31 * result + (this.search == null ? 0 : this.search.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SoslExpr other = (SoslExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.rawQuery == null ? other.rawQuery != null : !this.rawQuery.equals(other.rawQuery)) {
                return false;
            }
            return !(this.search == null ? other.search != null : !this.search.equals(other.search));
        }

        public String toString() {
            return "SoslExpr(loc = " + this.loc + ", rawQuery = " + this.rawQuery + ", search = " + this.search + ")";
        }
    }

    public static final class SoqlExpr
    extends Expr {
        public Location loc;
        public String rawQuery;
        public Query query;

        public SoqlExpr(Location loc, String rawQuery, Query query) {
            this.loc = loc;
            this.rawQuery = rawQuery;
            this.query = query;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.rawQuery == null ? 0 : this.rawQuery.hashCode());
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SoqlExpr other = (SoqlExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.rawQuery == null ? other.rawQuery != null : !this.rawQuery.equals(other.rawQuery)) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }

        public String toString() {
            return "SoqlExpr(loc = " + this.loc + ", rawQuery = " + this.rawQuery + ", query = " + this.query + ")";
        }
    }

    public static final class NestedExpr
    extends Expr {
        public Expr expr;

        public NestedExpr(Expr expr) {
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NestedExpr other = (NestedExpr)obj;
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "NestedExpr(expr = " + this.expr + ")";
        }
    }

    public static final class NewExpr
    extends Expr {
        public Location loc;
        public NewObject creator;

        public NewExpr(Location loc, NewObject creator) {
            this.loc = loc;
            this.creator = creator;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.creator == null ? 0 : this.creator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NewExpr other = (NewExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.creator == null ? other.creator != null : !this.creator.equals(other.creator));
        }

        public String toString() {
            return "NewExpr(loc = " + this.loc + ", creator = " + this.creator + ")";
        }
    }

    public static final class LiteralExpr
    extends Expr {
        public Location loc;
        public LiteralType type;
        public Object literal;

        public LiteralExpr(Location loc, LiteralType type, Object literal) {
            this.loc = loc;
            this.type = type;
            this.literal = literal;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LiteralExpr other = (LiteralExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
                return false;
            }
            return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
        }

        public String toString() {
            return "LiteralExpr(loc = " + this.loc + ", type = " + (Object)((Object)this.type) + ", literal = " + this.literal + ")";
        }
    }

    public static final class ClassRefExpr
    extends Expr {
        public Location loc;
        public TypeRef type;

        public ClassRefExpr(Location loc, TypeRef type) {
            this.loc = loc;
            this.type = type;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassRefExpr other = (ClassRefExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "ClassRefExpr(loc = " + this.loc + ", type = " + this.type + ")";
        }
    }

    public static final class ThisVariableExpr
    extends Expr {
        public Location loc;

        public ThisVariableExpr(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThisVariableExpr other = (ThisVariableExpr)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "ThisVariableExpr(loc = " + this.loc + ")";
        }
    }

    public static final class ThisMethodCallExpr
    extends Expr {
        public Location loc;
        public List<Expr> inputParameters;

        public ThisMethodCallExpr(Location loc, List<Expr> inputParameters) {
            this.loc = loc;
            this.inputParameters = inputParameters;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThisMethodCallExpr other = (ThisMethodCallExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters));
        }

        public String toString() {
            return "ThisMethodCallExpr(loc = " + this.loc + ", inputParameters = " + this.inputParameters + ")";
        }
    }

    public static final class SuperVariableExpr
    extends Expr {
        public Location loc;

        public SuperVariableExpr(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuperVariableExpr other = (SuperVariableExpr)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "SuperVariableExpr(loc = " + this.loc + ")";
        }
    }

    public static final class SuperMethodCallExpr
    extends Expr {
        public Location loc;
        public List<Expr> inputParameters;

        public SuperMethodCallExpr(Location loc, List<Expr> inputParameters) {
            this.loc = loc;
            this.inputParameters = inputParameters;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuperMethodCallExpr other = (SuperMethodCallExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters));
        }

        public String toString() {
            return "SuperMethodCallExpr(loc = " + this.loc + ", inputParameters = " + this.inputParameters + ")";
        }
    }

    public static final class JavaVariableExpr
    extends Expr {
        public Location loc;
        public List<Identifier> names;

        public JavaVariableExpr(Location loc, List<Identifier> names) {
            this.loc = loc;
            this.names = names;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaVariableExpr other = (JavaVariableExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.names == null ? other.names != null : !this.names.equals(other.names));
        }

        public String toString() {
            return "JavaVariableExpr(loc = " + this.loc + ", names = " + this.names + ")";
        }
    }

    public static final class JavaMethodCallExpr
    extends Expr {
        public Location loc;
        public List<Identifier> names;
        public List<Expr> inputParameters;

        public JavaMethodCallExpr(Location loc, List<Identifier> names, List<Expr> inputParameters) {
            this.loc = loc;
            this.names = names;
            this.inputParameters = inputParameters;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaMethodCallExpr other = (JavaMethodCallExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
                return false;
            }
            return !(this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters));
        }

        public String toString() {
            return "JavaMethodCallExpr(loc = " + this.loc + ", names = " + this.names + ", inputParameters = " + this.inputParameters + ")";
        }
    }

    public static final class MethodCallExpr
    extends Expr {
        public Optional<Expr> dottedExpr;
        public boolean isSafeNav;
        public List<Identifier> names;
        public List<Expr> inputParameters;

        public MethodCallExpr(Optional<Expr> dottedExpr, boolean isSafeNav, List<Identifier> names, List<Expr> inputParameters) {
            this.dottedExpr = dottedExpr;
            this.isSafeNav = isSafeNav;
            this.names = names;
            this.inputParameters = inputParameters;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dottedExpr == null ? 0 : this.dottedExpr.hashCode());
            result = 31 * result + (this.isSafeNav ? 1 : 0);
            result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodCallExpr other = (MethodCallExpr)obj;
            if (this.dottedExpr == null ? other.dottedExpr != null : !this.dottedExpr.equals(other.dottedExpr)) {
                return false;
            }
            if (this.isSafeNav != other.isSafeNav) {
                return false;
            }
            if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
                return false;
            }
            return !(this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters));
        }

        public String toString() {
            return "MethodCallExpr(dottedExpr = " + this.dottedExpr + ", isSafeNav = " + this.isSafeNav + ", names = " + this.names + ", inputParameters = " + this.inputParameters + ")";
        }
    }

    public static final class VariableExpr
    extends Expr {
        public Optional<Expr> dottedExpr;
        public boolean isSafeNav;
        public List<Identifier> names;

        public VariableExpr(Optional<Expr> dottedExpr, boolean isSafeNav, List<Identifier> names) {
            this.dottedExpr = dottedExpr;
            this.isSafeNav = isSafeNav;
            this.names = names;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dottedExpr == null ? 0 : this.dottedExpr.hashCode());
            result = 31 * result + (this.isSafeNav ? 1 : 0);
            result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableExpr other = (VariableExpr)obj;
            if (this.dottedExpr == null ? other.dottedExpr != null : !this.dottedExpr.equals(other.dottedExpr)) {
                return false;
            }
            if (this.isSafeNav != other.isSafeNav) {
                return false;
            }
            return !(this.names == null ? other.names != null : !this.names.equals(other.names));
        }

        public String toString() {
            return "VariableExpr(dottedExpr = " + this.dottedExpr + ", isSafeNav = " + this.isSafeNav + ", names = " + this.names + ")";
        }
    }

    public static final class ArrayExpr
    extends Expr {
        public Expr expr;
        public Expr index;

        public ArrayExpr(Expr expr, Expr index) {
            this.expr = expr;
            this.index = index;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayExpr other = (ArrayExpr)obj;
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.index == null ? other.index != null : !this.index.equals(other.index));
        }

        public String toString() {
            return "ArrayExpr(expr = " + this.expr + ", index = " + this.index + ")";
        }
    }

    public static final class PostfixExpr
    extends Expr {
        public Location loc;
        public Expr expr;
        public PostfixOp op;

        public PostfixExpr(Location loc, Expr expr, PostfixOp op) {
            this.loc = loc;
            this.expr = expr;
            this.op = op;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostfixExpr other = (PostfixExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.op == null ? other.op != null : !this.op.equals((Object)other.op));
        }

        public String toString() {
            return "PostfixExpr(loc = " + this.loc + ", expr = " + this.expr + ", op = " + (Object)((Object)this.op) + ")";
        }
    }

    public static final class PrefixExpr
    extends Expr {
        public Location loc;
        public Expr expr;
        public PrefixOp op;

        public PrefixExpr(Location loc, Expr expr, PrefixOp op) {
            this.loc = loc;
            this.expr = expr;
            this.op = op;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrefixExpr other = (PrefixExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.op == null ? other.op != null : !this.op.equals((Object)other.op));
        }

        public String toString() {
            return "PrefixExpr(loc = " + this.loc + ", expr = " + this.expr + ", op = " + (Object)((Object)this.op) + ")";
        }
    }

    public static final class PackageVersionExpr
    extends Expr {
        public Location loc;
        public VersionRef version;

        public PackageVersionExpr(Location loc, VersionRef version) {
            this.loc = loc;
            this.version = version;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageVersionExpr other = (PackageVersionExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "PackageVersionExpr(loc = " + this.loc + ", version = " + this.version + ")";
        }
    }

    public static final class TriggerVariableExpr
    extends Expr {
        public Location loc;
        public Identifier variable;

        public TriggerVariableExpr(Location loc, Identifier variable) {
            this.loc = loc;
            this.variable = variable;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TriggerVariableExpr other = (TriggerVariableExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
        }

        public String toString() {
            return "TriggerVariableExpr(loc = " + this.loc + ", variable = " + this.variable + ")";
        }
    }

    public static final class BooleanExpr
    extends Expr {
        public Expr left;
        public BooleanOp op;
        public Expr right;

        public BooleanExpr(Expr left, BooleanOp op, Expr right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanExpr other = (BooleanExpr)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals((Object)other.op)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return "BooleanExpr(left = " + this.left + ", op = " + (Object)((Object)this.op) + ", right = " + this.right + ")";
        }
    }

    public static final class InstanceOf
    extends Expr {
        public Expr expr;
        public TypeRef type;

        public InstanceOf(Expr expr, TypeRef type) {
            this.expr = expr;
            this.type = type;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceOf other = (InstanceOf)obj;
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "InstanceOf(expr = " + this.expr + ", type = " + this.type + ")";
        }
    }

    public static final class CastExpr
    extends Expr {
        public Location loc;
        public Expr expr;
        public TypeRef type;

        public CastExpr(Location loc, Expr expr, TypeRef type) {
            this.loc = loc;
            this.expr = expr;
            this.type = type;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CastExpr other = (CastExpr)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "CastExpr(loc = " + this.loc + ", expr = " + this.expr + ", type = " + this.type + ")";
        }
    }

    public static final class BinaryExpr
    extends Expr {
        public Expr left;
        public BinaryOp op;
        public Expr right;

        public BinaryExpr(Expr left, BinaryOp op, Expr right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinaryExpr other = (BinaryExpr)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals((Object)other.op)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return "BinaryExpr(left = " + this.left + ", op = " + (Object)((Object)this.op) + ", right = " + this.right + ")";
        }
    }

    public static final class TernaryExpr
    extends Expr {
        public Expr condition;
        public Expr trueExpr;
        public Expr falseExpr;

        public TernaryExpr(Expr condition, Expr trueExpr, Expr falseExpr) {
            this.condition = condition;
            this.trueExpr = trueExpr;
            this.falseExpr = falseExpr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            result = 31 * result + (this.trueExpr == null ? 0 : this.trueExpr.hashCode());
            result = 31 * result + (this.falseExpr == null ? 0 : this.falseExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TernaryExpr other = (TernaryExpr)obj;
            if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
                return false;
            }
            if (this.trueExpr == null ? other.trueExpr != null : !this.trueExpr.equals(other.trueExpr)) {
                return false;
            }
            return !(this.falseExpr == null ? other.falseExpr != null : !this.falseExpr.equals(other.falseExpr));
        }

        public String toString() {
            return "TernaryExpr(condition = " + this.condition + ", trueExpr = " + this.trueExpr + ", falseExpr = " + this.falseExpr + ")";
        }
    }

    public static final class AssignmentExpr
    extends Expr {
        public Expr left;
        public AssignmentOp op;
        public Expr right;

        public AssignmentExpr(Expr left, AssignmentOp op, Expr right) {
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AssignmentExpr other = (AssignmentExpr)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op == null ? other.op != null : !this.op.equals((Object)other.op)) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        public String toString() {
            return "AssignmentExpr(left = " + this.left + ", op = " + (Object)((Object)this.op) + ", right = " + this.right + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(AssignmentExpr x) {
            this._default(x);
        }

        @Override
        public void _case(TernaryExpr x) {
            this._default(x);
        }

        @Override
        public void _case(BinaryExpr x) {
            this._default(x);
        }

        @Override
        public void _case(CastExpr x) {
            this._default(x);
        }

        @Override
        public void _case(InstanceOf x) {
            this._default(x);
        }

        @Override
        public void _case(BooleanExpr x) {
            this._default(x);
        }

        @Override
        public void _case(TriggerVariableExpr x) {
            this._default(x);
        }

        @Override
        public void _case(PackageVersionExpr x) {
            this._default(x);
        }

        @Override
        public void _case(PrefixExpr x) {
            this._default(x);
        }

        @Override
        public void _case(PostfixExpr x) {
            this._default(x);
        }

        @Override
        public void _case(ArrayExpr x) {
            this._default(x);
        }

        @Override
        public void _case(VariableExpr x) {
            this._default(x);
        }

        @Override
        public void _case(MethodCallExpr x) {
            this._default(x);
        }

        @Override
        public void _case(JavaMethodCallExpr x) {
            this._default(x);
        }

        @Override
        public void _case(JavaVariableExpr x) {
            this._default(x);
        }

        @Override
        public void _case(SuperMethodCallExpr x) {
            this._default(x);
        }

        @Override
        public void _case(SuperVariableExpr x) {
            this._default(x);
        }

        @Override
        public void _case(ThisMethodCallExpr x) {
            this._default(x);
        }

        @Override
        public void _case(ThisVariableExpr x) {
            this._default(x);
        }

        @Override
        public void _case(ClassRefExpr x) {
            this._default(x);
        }

        @Override
        public void _case(LiteralExpr x) {
            this._default(x);
        }

        @Override
        public void _case(NewExpr x) {
            this._default(x);
        }

        @Override
        public void _case(NestedExpr x) {
            this._default(x);
        }

        @Override
        public void _case(SoqlExpr x) {
            this._default(x);
        }

        @Override
        public void _case(SoslExpr x) {
            this._default(x);
        }

        protected abstract void _default(Expr var1);
    }

    public static interface SwitchBlock {
        public void _case(AssignmentExpr var1);

        public void _case(TernaryExpr var1);

        public void _case(BinaryExpr var1);

        public void _case(CastExpr var1);

        public void _case(InstanceOf var1);

        public void _case(BooleanExpr var1);

        public void _case(TriggerVariableExpr var1);

        public void _case(PackageVersionExpr var1);

        public void _case(PrefixExpr var1);

        public void _case(PostfixExpr var1);

        public void _case(ArrayExpr var1);

        public void _case(VariableExpr var1);

        public void _case(MethodCallExpr var1);

        public void _case(JavaMethodCallExpr var1);

        public void _case(JavaVariableExpr var1);

        public void _case(SuperMethodCallExpr var1);

        public void _case(SuperVariableExpr var1);

        public void _case(ThisMethodCallExpr var1);

        public void _case(ThisVariableExpr var1);

        public void _case(ClassRefExpr var1);

        public void _case(LiteralExpr var1);

        public void _case(NewExpr var1);

        public void _case(NestedExpr var1);

        public void _case(SoqlExpr var1);

        public void _case(SoslExpr var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(AssignmentExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(TernaryExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BinaryExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(CastExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(InstanceOf x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BooleanExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(TriggerVariableExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(PackageVersionExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(PrefixExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(PostfixExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ArrayExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(VariableExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(MethodCallExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(JavaMethodCallExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(JavaVariableExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SuperMethodCallExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SuperVariableExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ThisMethodCallExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ThisVariableExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ClassRefExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(LiteralExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(NewExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(NestedExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SoqlExpr x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SoslExpr x) {
            return this._default(x);
        }

        protected abstract ResultType _default(Expr var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(AssignmentExpr var1);

        public ResultType _case(TernaryExpr var1);

        public ResultType _case(BinaryExpr var1);

        public ResultType _case(CastExpr var1);

        public ResultType _case(InstanceOf var1);

        public ResultType _case(BooleanExpr var1);

        public ResultType _case(TriggerVariableExpr var1);

        public ResultType _case(PackageVersionExpr var1);

        public ResultType _case(PrefixExpr var1);

        public ResultType _case(PostfixExpr var1);

        public ResultType _case(ArrayExpr var1);

        public ResultType _case(VariableExpr var1);

        public ResultType _case(MethodCallExpr var1);

        public ResultType _case(JavaMethodCallExpr var1);

        public ResultType _case(JavaVariableExpr var1);

        public ResultType _case(SuperMethodCallExpr var1);

        public ResultType _case(SuperVariableExpr var1);

        public ResultType _case(ThisMethodCallExpr var1);

        public ResultType _case(ThisVariableExpr var1);

        public ResultType _case(ClassRefExpr var1);

        public ResultType _case(LiteralExpr var1);

        public ResultType _case(NewExpr var1);

        public ResultType _case(NestedExpr var1);

        public ResultType _case(SoqlExpr var1);

        public ResultType _case(SoslExpr var1);
    }
}

